<?php
// api/users/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
        
    // parametros obligatorios
    $parmsob = array('offset','numofrecords');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $order = determinateOrder($_GET['order']);
    $offset = $_GET['offset'];
    $numofrec = $_GET['numofrecords'];
    
    // Validamos la session
    isSessionValidAPI($db, $sessionid);
    
    // Consultamos la cantidad de registros(status = 1)
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM users ".
    "       WHERE id > 0 ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Retornamos el total
    $out->numofrecords = (int)$row["qty"];
    
    // Consultamos los detalles de los registros
    $sql = "SELECT * ".
    "       FROM users ".
    "       WHERE id > 0 ".
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->usr = $row['usr'];
        $record->datecreated = date('Y-m-d', strtotime($row['datecreated']));
        
        $record->status = new stdClass();
        $record->status->id = (int)$row['status'];
        $record->status->dsc = $record->status->id == 1 ? 'Activo' : 'Inactivo';
        
        $record->level = new stdClass();
        $record->level->id = (int)$row['level'];
        $record->level->dsc = "Nivel ".$row['level'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar orden de los registros, donde:
    *   1 = id asc
    *   2 = user asc
    *   1 = id desc
    *   2 = user desc
    */
    function determinateOrder($order){
        $str = '';
        
        switch($order){
            case 1:
                $str = ' ORDER BY id ASC ';
                break;
            case 2:
                $str = ' ORDER BY usr ASC ';
                break;
            case -1:
                $str = ' ORDER BY id DESC ';
                break;
            case -2:
                $str = ' ORDER BY usr DESC ';
                break;
            default:
                $str = ' ORDER BY id ASC ';
        }
        
        return $str;
    }
?>
