<?php 
    function getPairDetails($db, $pairid, $userid){
        $ask =  "SELECT		O.pairid, MIN(O.price) price ".
                "FROM       orders O ".
                "LEFT JOIN	(SELECT		T.orderid, T.accountid, SUM(T.amount) ABO ".
                "           FROM		transactions T  ".
                "           WHERE		T.amount < 0 ".
                "           GROUP BY	T.orderid, T.accountid) T ".
                "ON			O.id=T.orderid ".
                "AND		O.accountid=T.accountid ".
                "WHERE		O.canceled IS NULL ".
                "AND		O.side=1 ".
                "AND		O.quantity+IFNULL(T.ABO,0) <> 0 ".
                "GROUP BY	O.pairid";

        $bid =  "SELECT		O.pairid, MAX(O.price) price ".
                "FROM       orders O ".
                "LEFT JOIN	(SELECT		T.orderid, T.accountid, SUM(T.amount) ABO ".
                "           FROM		transactions T  ".
                "           WHERE		T.amount > 0 ".
                "           GROUP BY	T.orderid, T.accountid) T ".
                "ON			O.id=T.orderid ".
                "AND		O.paymentid=T.accountid ".
                "WHERE		O.canceled IS NULL ".
                "AND		O.side=2 ".
                "AND		O.quantity-IFNULL(T.ABO,0) <> 0 ".
                "GROUP BY	O.pairid";

        $lstp =     "SELECT		O.pairid, O.price ".
                    "FROM		orders O  ".
                    "INNER JOIN	transactions T ".
                    "ON			O.id=T.orderid ".
                    "WHERE		T.id IN ".
                    "            ( ".
                    "            SELECT		MAX(T.id) tid ".
                    "            FROM		transactions T  ".
                    "            INNER JOIN	orders O  ".
                    "            ON			T.orderid=O.id ".
                    "            WHERE		T.id IN ".
                    "            			( ".
                    "            			SELECT 		MIN(T.id) tid ".
                    "            			FROM 		transactions T  ".
                    "            			INNER JOIN	orders O ".
                    "            			ON			T.orderid=O.id ".
                    "                       GROUP BY    O.id ".
                    "            			) ".
                    "            GROUP BY	O.pairid ".
                    "            )";
            
        $lst24  =   "SELECT		O.pairid, O.price ".
                    "FROM		orders O  ".
                    "INNER JOIN	transactions T ".
                    "ON			O.id=T.orderid ".
                    "WHERE		T.id IN ".
                    "            ( ".
                    "            SELECT		MAX(T.id) tid ".
                    "            FROM		transactions T  ".
                    "            INNER JOIN	orders O  ".
                    "            ON			T.orderid=O.id ".
                    "            WHERE		T.id IN ".
                    "            			( ".
                    "            			SELECT 		MIN(T.id) tid ".
                    "            			FROM 		transactions T  ".
                    "            			INNER JOIN	orders O ".
                    "            			ON			T.orderid=O.id ".
                    "                       WHERE		T.datecreated <= DATE_SUB(NOW(), INTERVAL 1 DAY) " .
                    "                       GROUP BY    O.id ".
                    "            			) ".
                    "            GROUP BY	O.pairid ".
                    "            )";
            
                    
        $volume =   "SELECT     O.pairid, A.currencyid acccurid, ".
                    "           ABS(SUM(T.amount)) AS transactionamount ".
                    "FROM       transactions T ".
                    "INNER JOIN orders O ".
                    "ON         T.orderid=O.id ".
                    "INNER JOIN accounts A ".
                    "ON         T.accountid=A.id ".
                    "WHERE      T.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY) AND T.accountid = O.accountid ".
                    "GROUP BY   O.pairid, A.currencyid";

        $low24 =   "SELECT		O.pairid, MIN(O.price) AS price ".
                    "FROM		orders O  ".
                    "INNER JOIN	transactions T ".
                    "ON			O.id=T.orderid ".
                    "WHERE		T.id IN ( ".
                    "           	SELECT 		MIN(T.id) tid ".
                    "           	FROM 		transactions T  ".
                    "           	INNER JOIN	orders O ".
                    "           	ON			T.orderid=O.id ".
                    "               WHERE       T.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
                    "               GROUP BY    O.id ".
                    "           ) ".
                    "           GROUP BY	O.pairid ";

        $high24 =   "SELECT		O.pairid, MAX(O.price) AS price ".
                    "FROM		orders O  ".
                    "INNER JOIN	transactions T ".
                    "ON			O.id=T.orderid ".
                    "WHERE		T.id IN ( ".
                    "           	SELECT 		MIN(T.id) tid ".
                    "           	FROM 		transactions T  ".
                    "           	INNER JOIN	orders O ".
                    "           	ON			T.orderid=O.id ".
                    "               WHERE       T.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
                    "               GROUP BY    O.id ".
                    "           ) ".
                    "           GROUP BY	O.pairid ";

        $fees =     "SELECT      C.pctmktfee, C.pctlimitfee, C.pairid ".
                    "FROM        cmspreffees C ".
                    "INNER JOIN  users U " .
                    "ON          U.type = C.usertype " . 
                    "AND         U.level = C.levelid " .
                    "AND         U.id = " .$userid . " " .
                    "WHERE       C.currencyid IS NULL " .
                    "GROUP BY	 C.pairid";   

        $min =      "SELECT      C.minexchange, P.id AS pairid ".
                    "FROM        cmspreffees C ".
                    "INNER JOIN  users U " .
                    "ON          U.type = C.usertype " . 
                    "AND         U.id = " .$userid . " ".
                    "INNER JOIN  pairs P " .
                    "ON          P.refcurrencyid = C.currencyid " .
                    "WHERE       C.pairid IS NULL " .
                    "GROUP BY	 P.id";

        $exon =     "SELECT      IF(exonerated IS NULL, 0, exonerated) AS exonerated, UP.pairid, UP.preffeesfield ".
                    "FROM        userxchgprefs UP ".
                    "WHERE       UP.userid = ".$userid . " " .
                    "AND         (preffeesfield = 'pctmktfee' ".
                    "OR          preffeesfield = 'pctlimitfee') ".
                    "GROUP BY    UP.pairid";

        $sql =      "SELECT 	P.id AS pairsid, " .
                    "           P.refcurrencyid AS pairsrefcurrency,  ".
                    "           C.name AS currencyname, ".
                    "           C.symbol AS currencysymbol, ".
                    "           C.icon AS currencyicon, ".
                    "           C.decimals AS currencydecimals, ".
                    "           C.id AS currencyid, ".
                    "           CR.name AS refcurrencyname, ".
                    "           CR.symbol AS refcurrencysymbol, ".
                    "           CR.icon AS refcurrencyicon, ".
                    "           CR.decimals AS refcurrencydecimals, ".
                    "           IFNULL(V.transactionamount, 0) transactionamount, ".
                    "           IFNULL(A.price, 0) askprice, ".
                    "           IFNULL(B.price, 0) bidprice, ".
                    "           IFNULL(L.price, 0) lastprice, ".
                    "           IFNULL(D.price, 0) lastprice24, ".
                    "           IFNULL(LW.price, 0) lowprice24, ".
                    "           IFNULL(HI.price, 0) highprice24, ".
                    "           IFNULL(F.pctmktfee, 0) pctmktfee, ".
                    "           IFNULL(F.pctlimitfee, 0) pctlimitfee, ".
                    "           IFNULL(M.minexchange, 0) minexchange, ".
                    "           IFNULL(EL.exonerated, 0) exoneratedlmt, ".
                    "           IFNULL(EM.exonerated, 0) exoneratedmkt ".
                    "FROM 		pairs P ".
                    "INNER JOIN currencies C ".
                    "ON			C.id = P.currencyid ".
                    "INNER JOIN currencies CR ".
                    "ON			P.refcurrencyid= CR.id ".
                    "LEFT JOIN  (".$volume.") V ".
                    "ON         V.pairid=P.id ".
                    "AND        V.acccurid=P.refcurrencyid ".
                    "LEFT JOIN  (".$ask.") A ".
                    "ON         A.pairid=P.id " .
                    "LEFT JOIN  (".$bid.") B ".
                    "ON         B.pairid=P.id " .
                    "LEFT JOIN  (".$lstp.") L ".
                    "ON         L.pairid=P.id " .
                    "LEFT JOIN  (".$lst24.") D ".
                    "ON         D.pairid=P.id " .
                    "LEFT JOIN  (".$low24.") LW ".
                    "ON         LW.pairid=P.id " .
                    "LEFT JOIN  (".$high24.") HI ".
                    "ON         HI.pairid=P.id " .
                    "LEFT JOIN  (".$fees.") F ".
                    "ON         F.pairid=P.id " .
                    "LEFT JOIN  (".$min.") M ".
                    "ON         M.pairid=P.id " .
                    "LEFT JOIN  (".$exon.") EL ".
                    "ON         EL.pairid=P.id " .
                    "AND        EL.preffeesfield = 'pctlimitfee' " .
                    "LEFT JOIN  (".$exon.") EM ".
                    "ON         EM.pairid=P.id " .
                    "AND        EM.preffeesfield = 'pctmktfee' " .
                    "WHERE 		P.status = 1 AND P.id = " .$pairid. " ".
                    "ORDER BY   P.id";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                        
            $row = $res->fetch_assoc();
            
        //Ordenamos los valores
        $pair = new stdClass();
        $pair->id = (int)$pairid;
        //Consultamos los datos requeridos
        /*
        $sql = "SELECT pairs.refcurrencyid AS pairsrefcurrency, ".
        "       currencies.name AS currencyname, currencies.symbol AS currencysymbol, currencies.icon AS currencyicon, ".
        "       currencies.id AS currencyid, pairs.id AS pairsid, ".
        "       currencies.decimals AS decimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.status = 1 AND ".
        "       pairs.id = ".$pairid." AND ".
        "       currencies.id = pairs.currencyid ".
        "       GROUP BY pairs.id";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
        $pairdata = $rs->fetch_assoc();
        
        //Consultamos decimales de moneda ref
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata['pairsrefcurrency'];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
        $pairrefdata = $rs->fetch_assoc();
    
        
        //Obtenemos la ultima transaccion realizada
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS lastprice ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$pair->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        $row = $res->fetch_assoc();
        */
            
        $pair->last = new stdClass();
        $pair->last->number = (float)number_format($row["lastprice"],$row["currencydecimals"],".","");
        $pair->last->formatted = number_format($pair->last->number,$row["currencydecimals"],",",".");
    
        //Obtenemos la cantidad total que se ha hecho
        /*
        $sql = "SELECT SUM(transactions.amount) AS transactionamount FROM orders, transactions, accounts".
        "       WHERE orders.pairid = ".$pair->id.
        "       AND accounts.id = IF(orders.side = 2, orders.paymentid, orders.accountid) ".
        "       AND accounts.currencyid = ".$pairdata["pairsrefcurrency"].
        "       AND accounts.id = transactions.accountid ".
        "       AND transactions.amount > 0".
        "       AND transactions.orderid = orders.id".
        "       AND transactions.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $res->fetch_assoc();*/
    
        $pair->volume = new stdClass();
        $pair->volume->number = (float)number_format($row['transactionamount'],$row["refcurrencydecimals"],'.','');
        $pair->volume->formatted = number_format($pair->volume->number,$row["refcurrencydecimals"],",",".");
    
        //Consultamos la ultima transaccion hace 24horas
        /*
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS transactionamount ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$pair->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       AND t.datecreated <= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $res->fetch_assoc();*/
        $pair->change = new stdClass();
        $pair->nmalchange = new stdClass();
        
        if($pair->last->number == 0){
            $pair->change->number = 0;
            $pair->change->formatted = number_format($pair->change->number,2,",",".")."%";
            $pair->nmalchange->number =  0;
            $pair->nmalchange->formatted = number_format($pair->nmalchange->number, $row["currencydecimals"],',','.');;
        }else{
            if($row['lastprice24'] > 0){
                $pair->change->number = (($pair->last->number - $row['lastprice24'])*100)/$row['lastprice24'] ;
                $pair->change->formatted = number_format($pair->change->number,2,",",".")."%";
                $pair->nmalchange->number =  abs($row['lastprice24'] - $pair->last->number);
                $pair->nmalchange->formatted = number_format($pair->nmalchange->number, $row["currencydecimals"],',','.');
            }else{
                $pair->change->number = 0;
                $pair->change->formatted = number_format($pair->change->number,2,",",".")."%";
                $pair->nmalchange->number =  0;
                $pair->nmalchange->formatted = number_format($pair->nmalchange->number, $row["currencydecimals"],',','.');
            }
        }
        /*
        //Consultamos la ultima venta
        $sql = "SELECT o.quantity AS qty, o.id AS grouptx, ".
        "       o.price, o.side, o.id, o.total".
        "       FROM orders o".
        "       WHERE o.side = 1 AND o.canceled IS NULL AND o.pairid = ".$pair->id.
        "       AND (CASE ".
        "           WHEN o.canceled IS NOT NULL THEN -1 ".
        "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "               AND o.canceled IS NULL THEN 1 ".
        "           ELSE 0 ".
        "       END) = 0 ".
        "       ORDER BY o.price ASC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $res->fetch_assoc();
    */
        $pair->ask = new stdClass();
        $pair->ask->number = (float)number_format($row['askprice'], $row["currencydecimals"], '.','');
        $pair->ask->formatted = number_format($pair->ask->number,$row["currencydecimals"],",",".");
    
        //Consultamos los datos de la ultima compra
        /*
        $sql = "SELECT o.quantity AS qty, o.id AS grouptx, ".
        "       o.price, o.side, o.id, o.total".
        "       FROM orders o".
        "       WHERE o.side = 2 AND o.canceled IS NULL AND o.pairid = ".$pair->id.
        "       AND (CASE ".
        "           WHEN o.canceled IS NOT NULL THEN -1 ".
        "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "               AND o.canceled IS NULL THEN 1 ".
        "           ELSE 0 ".
        "       END) = 0 ".
        "       ORDER BY o.price DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $res->fetch_assoc();
    */
        $pair->bid = new stdClass();
        $pair->bid->number = (float)number_format($row['bidprice'],$row["currencydecimals"],'.','');
        $pair->bid->formatted = number_format($pair->bid->number,$row["currencydecimals"],",",".");
        
        //Consultamos la orden mas barata durante todo 1 dia
        /*
        $sql = "SELECT MIN((SELECT ord.price FROM orders ord 
               WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid))) AS lastprice 
               FROM orders, accounts, transactions t  
                   LEFT JOIN transactions txother 
                       ON t.orderid != txother.orderid 
                       AND t.txid = txother.txid  
                       AND txother.amount > 0 
                       AND txother.dsc NOT LIKE 'Comisi%' 
               WHERE t.orderid IS NOT NULL 
               AND orders.id = txother.orderid 
               AND orders.pairid = ".$pair->id."
               AND t.id = t.txid 
               AND t.dsc NOT LIKE 'Comisi%' 
               AND accounts.id = orders.accountid 
               AND t.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY)
               ORDER BY t.datecreated DESC, t.id DESC";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $res->fetch_assoc();
        */
        $pair->low = new stdClass();
        $pair->low->number = (float)number_format($row['lowprice24'],$row["currencydecimals"],'.','');
        $pair->low->formatted = number_format($pair->low->number,$row["currencydecimals"],",",".");
        
        //Consultamos la orden mas barata durante todo 1 dia
        /*
        $sql = "SELECT MAX((SELECT ord.price FROM orders ord 
               WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid))) AS lastprice 
               FROM orders, accounts, transactions t  
                   LEFT JOIN transactions txother 
                       ON t.orderid != txother.orderid 
                       AND t.txid = txother.txid  
                       AND txother.amount > 0 
                       AND txother.dsc NOT LIKE 'Comisi%' 
               WHERE t.orderid IS NOT NULL 
               AND orders.id = txother.orderid 
               AND orders.pairid = ".$pair->id."
               AND t.id = t.txid 
               AND t.dsc NOT LIKE 'Comisi%' 
               AND accounts.id = orders.accountid 
               AND t.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY)
               ORDER BY t.datecreated DESC, t.id DESC";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $res->fetch_assoc();
        */
        $pair->high = new stdClass();
        $pair->high->number = (float)number_format($row['highprice24'], $row["currencydecimals"],'.','');
        $pair->high->formatted = number_format($pair->high->number,$row["currencydecimals"],",",".");
        
        //Datos de moneda refcurrency
        $pair->currency = new stdClass();
        $pair->currency->id = (int)$row["currencyid"];
        $pair->currency->dsc = $row["currencyname"];
        $pair->currency->icon = $row["currencyicon"];
        $pair->currency->symbol = $row["currencysymbol"];
        $pair->currency->decimals = $row['currencydecimals'];
            
        //Datos de currency
        /*
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata["pairsrefcurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $res->fetch_assoc();
          */  
        $pair->refcurrency = new stdClass();
        $pair->refcurrency->id = (int)$row["pairsrefcurrency"];
        $pair->refcurrency->dsc = $row["refcurrencyname"];
        $pair->refcurrency->symbol = $row["refcurrencysymbol"];
        $pair->refcurrency->icon = $row["refcurrencyicon"];
        $pair->refcurrency->decimals = (int)$row["refcurrencydecimals"];
        
        //Consultamos los datos del usuario para encontrar su fee
        /*
        $sql = "SELECT id, usr, type, level ".
        "       FROM users WHERE id = ".$userid;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $userdata = $res->fetch_assoc();
    
        $level = 1;
    
        if($userdata["level"] == 0){
            $level = 1;
        }else{
            $level = $userdata["level"];
        }
    
        // Consultamos las comisiones del par
        $sql = "SELECT * FROM cmspreffees ".
        "       WHERE levelid = ".$level.
        "       AND pairid = ".$pairid.
        "       AND usertype = ".$userdata["type"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $feedata = $res->fetch_assoc();*/
        $pair->fees = new stdClass();
        $pair->fees->orders = new stdClass();
    
        //Comisiones para market
        $pair->fees->orders->market = new stdClass();
    
        if($row["pctmktfee"] == 0){
            $pair->fees->orders->market->pctfee = null;
        }else{
            /*
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userxchgprefs ".
            "       WHERE pairid = ".$pairid.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'pctmktfee'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            */
            $pair->fees->orders->market->pctfee = new stdClass();
            $pair->fees->orders->market->pctfee ->number = $row["pctmktfee"] - ($row["pctmktfee"]/100 * $row['exoneratedmkt']);
            $pair->fees->orders->market->pctfee->formatted = number_format($pair->fees->orders->market->pctfee ->number,2,",",".");
        }
        
        
        //Comisiones para limit
        $pair->fees->orders->limit = new stdClass();
        
        if($row["pctlimitfee"] == 0){
            $pair->fees->orders->limit->pctfee = null;
        }else{
            /*
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userxchgprefs ".
            "       WHERE pairid = ".$pairid.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'pctlimitfee'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            */
            $pair->fees->orders->limit->pctfee = new stdClass();
            $pair->fees->orders->limit->pctfee ->number = $row["pctlimitfee"] - ($row["pctlimitfee"]/100 * $row['exoneratedlmt']);
            $pair->fees->orders->limit->pctfee->formatted = number_format($pair->fees->orders->limit->pctfee ->number,2,",",".");
        }
        
        
        // Consultamos el minimo en la moneda base
        /*
        $sql = "SELECT minexchange ".
        "       FROM cmspreffees ".
        "       WHERE currencyid = ".$pair->refcurrency->id.
        "       AND usertype = 1 ".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
        $min = $res->fetch_assoc();
        */
        // Retornamos el valor
        $pair->fees->min = new stdClass();
        $pair->fees->min->number = (float)$row['minexchange'];
        $pair->fees->min->formatted = numberFormatt($pair->fees->min->number, $pair->refcurrency->decimals);
        
        return $pair;
    }
?>