<?php
// app/api/deposits/accounts

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","currencyid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $currencyid = $_GET["currencyid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValid($db, $sessionid);
    
    //Consultamos la cantidad de cuentas de DEPOSITO = -3   
    $sql = "SELECT COUNT(id) AS qty FROM accounts ".
    "       WHERE currencyid = ".$currencyid.
    "       AND userid = -1 ".
    "       AND paymentmethodid > 0".
    //"       AND paymentmethodid = -3".
    "       AND status = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los datos de las cuentas de DEPOSITO = -3
    $sql = "SELECT * FROM accounts ".
    "       WHERE currencyid = ".$currencyid.
    "       AND userid = -1 ".
    "       AND paymentmethodid > 0".
    //"       AND paymentmethodid = -3".
    "       AND status = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    //Ordenamos los resultados
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        
        //Consultamos el metodo de pago
        $sql = "SELECT id, dsc, countryid, details1, ".
        "       details2, details3, details4 ".
        "       FROM paymentmethods ".
        "       WHERE id = ".$row["paymentmethodid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $rowsecundary = $res->fetch_assoc();
        
        $record->paymentmethod = new stdClass();
        $record->paymentmethod->id = (int)$rowsecundary["id"];
        $record->paymentmethod->dsc = $rowsecundary["dsc"];
        $record->paymentmethod->details1 = $rowsecundary["details1"];
        $record->paymentmethod->details2 = $rowsecundary["details2"];
        $record->paymentmethod->details3 = $rowsecundary["details3"];
        $record->paymentmethod->details4 = $rowsecundary["details4"];
        
        //Consultamos el pais del metodo
        $sql = "SELECT id, name ".
        "       FROM countries ".
        "       WHERE id = ".$rowsecundary["countryid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $rowsecundary = $res->fetch_assoc();
        $record->country = new stdClass();
        $record->country->id = (int)$rowsecundary["id"];
        $record->country->dsc = $rowsecundary["name"];
        
        //Consultamos los datos de la moneda
        $sql = "SELECT id, name, symbol".
        "       FROM currencies".
        "       WHERE id = ".$row["currencyid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $rowsecundary = $res->fetch_assoc();
        $record->currency = new stdClass();
        $record->currency->id = (int)$rowsecundary["id"];
        $record->currency->dsc = $rowsecundary["name"];
        $record->currency->symbol = $rowsecundary["symbol"];
        
        $record->details1 = $row["details1"];
        $record->details2 = $row["details2"];
        $record->details3 = $row["details3"];
        $record->details4 = $row["details4"];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>