<?php
// app/api/fees/transactionscheck

    //$mt = microtime(true);
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $out = new stdClass();
    
    //Este servicio es para validar las operaciones dentro de 24 horas que no hayan sido validadas, para subir su fee
    
    // Consultamos los retiros dentro de 24 horas que no hayan sido confirmados o rechazados
    $sql = "SELECT withdrawals.ref AS idapi, ".
    "       accounts.currencyid AS currencyid, ".
    "       currencies.interface AS interface, ".
    "       withdrawals.fee AS txfee".
    "       FROM withdrawals, accounts, transactions, currencies ".
    "       WHERE transactions.id = withdrawals.transactionid ".
    "       AND accounts.currencyid = currencies.id ".
    "       AND transactions.accountid = accounts.id ".
    "       AND accounts.entityusrid = -1 ".
    "       AND withdrawals.rejected IS NULL ".
    "       AND withdrawals.valid IS NULL ".
    "       AND DATE(withdrawals.createddate) >= DATE( DATE_ADD(NOW(), INTERVAL -1 DAY))";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
    while($row = $rs->fetch_assoc()){
        $feetmp = 0;
        switch($row['interface']){
            case 7:
                // Consultamos los detalles en la blockchain
                $parms = array('txid'=>$row['idapi'],'verbose'=>true);
                $request = array('method'=>'getrawtransaction','parms' => $parms);
                $rest = json_decode(queryServicesDash($DASH_URL, $request),true);
                
                // Validamos que no tenga confirmaciones
                if($rest['result']['confirmations'] == 0){
                    // OBTENEMOS EL SMARTFEE
                    $parms = array("conf_target"=>5);
                    $request = array('method'=>'estimatesmartfee','parms' => $parms);
                    $rspfee = json_decode(queryServicesDash($DASH_URL, $request),true);
                    
                    //Obtenemos el fee con todos los datos
                    $feetmp = (($rest['result']['size'] * $rspfee['result']['feerate']) / 1024);
                    
                    //Validamos que el fee temportal sea mayor a el fee de la operacion
                    if($feetmp > $row['txfee']){
                        $parms = array("amount"=>$row['txfee']);
                        $request = array('method'=>'settxfee','parms' => $parms);
                        $rspsettingfee = json_decode(queryServicesDash($DASH_URL, $request),true);
                        
                        if($rspsettingfee['result'] == false){
                            badEnd('500',array("msg"=>determinateMsgFail(array(
                                "esp"=>"Error API no se pudo calcular la comisión DASH ".$rsp['error']['message'],
                                "eng"=>"API error could not calculate the DASH commission ".$rsp['error']['message']), $lang, "Error API no se pudo calcular la comisión DASH ".$rsp['error']['message'])));
                        }
            
                    }else{
                        $parms = array("amount"=>$feetmp);
                        $request = array('method'=>'settxfee','parms' => $parms);
                        $rspsettingfee = json_decode(queryServicesDash($DASH_URL, $request),true);
                        
                        if($rspsettingfee['result'] == false){
                            badEnd('500',array("msg"=>determinateMsgFail(array(
                                "esp"=>"Error API no se pudo calcular la comisión DASH ".$rsp['error']['message'],
                                "eng"=>"API error could not calculate the DASH commission ".$rsp['error']['message']), $lang, "Error API no se pudo calcular la comisión DASH ".$rsp['error']['message'])));
                        }
                    }
                    
                    $parms = array("txid"=>$row['idapi']);
                    $request = array('method'=>'bumpfee','parms' => $parms);
                    $rspbump = json_decode(queryServicesBTC($BTC_URL, $request), true); 
                }
                
                $out->records [] = $rest['result'];
                
                break;
            case 4:
                // BTC
                // Consultamos los detalles en la blockchain
                $parms = array('txid'=>$row['idapi'],'verbose'=>true);
                $request = array('method'=>'getrawtransaction','parms' => $parms);
                $rest = json_decode(queryServicesBTC($BTC_URL, $request), true);
                
                // Validamos que no tenga confirmaciones
                if($rest['result']['confirmations'] == 0){
                    // OBTENEMOS EL SMARTFEE
                    $parms = array("conf_target"=>3);
                    $request = array('method'=>'estimatesmartfee','parms' => $parms);
                    $rspfee = json_decode(queryServicesBTC($BTC_URL, $request), true);
                    
                    //Obtenemos el fee con todos los datos
                    $feetmp = (($rest['result']['size'] * $rspfee['result']['feerate']) / 1024);
                    
                    //Validamos que el fee temportal sea mayor a el fee de la operacion
                    if($feetmp > $row['txfee']){
                        $parms = array("amount"=>$row['txfee']);
                        $request = array('method'=>'settxfee','parms' => $parms);
                        $rspsettingfee = json_decode(queryServicesBTC($BTC_URL, $request), true); 
                        
                        if($rspsettingfee['result'] == false){
                            badEnd('500',array("msg"=>determinateMsgFail(array(
                                "esp"=>"Error API no se pudo calcular la comisión BTC ".$rsp['error']['message'],
                                "eng"=>"API error could not calculate the BTC commission ".$rsp['error']['message']), $lang, "Error API no se pudo calcular la comisión BTC ".$rsp['error']['message'])));
                        }
            
                    }else{
                        $parms = array("amount"=>$feetmp);
                        $request = array('method'=>'settxfee','parms' => $parms);
                        $rspsettingfee = json_decode(queryServicesBTC($BTC_URL, $request), true); 
                        
                        if($rspsettingfee['result'] == false){
                            badEnd('500',array("msg"=>determinateMsgFail(array(
                                "esp"=>"Error API no se pudo calcular la comisión BTC ".$rsp['error']['message'],
                                "eng"=>"API error could not calculate the BTC commission ".$rsp['error']['message']), $lang, "Error API no se pudo calcular la comisión BTC ".$rsp['error']['message'])));
                        }
                    }
                    
                    $parms = array("txid"=>$row['idapi']);
                    $request = array('method'=>'bumpfee','parms' => $parms);
                    $rspbump = json_decode(queryServicesBTC($BTC_URL, $request), true); 
                }
                
                $out->records [] = $rest['result'];
                
                break;
        }
    }
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>