<?php
// app/api/notifications/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    // Consultamos la categoria de notificaciones
    $sql = "SELECT DISTINCT category FROM cmsmessages".
    "       ORDER BY category";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $out->numofrecords = 0;
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        switch($row['category']){
            case 0:
                continue 2;
                break;
            case 1:
                $record->dsc = $lang == 'esp' ? "Registro" : 'Register';
                break;
            case 2:
                $record->dsc = $lang == 'esp' ? "Cambio de nivel" : 'Level change';
                break;
            case 3:
                $record->dsc = $lang == 'esp' ? "Depósitos" : 'Deposits';
                break;
            case 4:
                $record->dsc = $lang == 'esp' ? "Retiros" : 'Withdrawals';
                break;
            case 5:
                $record->dsc = $lang == 'esp' ? "Intercambios límite completados" : 'Limit exchanges completed';
                break;
            case 6:
                $record->dsc = $lang == 'esp' ? "Cambio de clave" : 'Password change';
                break;
            case 7:
                $record->dsc = $lang == 'esp' ? "2FA" : '2FA';
                break;
            default:
                $record->dsc = $lang == 'esp' ? "Categoría no definida" : 'Category not defined';
        }
        
        // Obtenemos la preferencia del usuario
        $sql = "SELECT * FROM usermessages WHERE usrid = ".$userid.
        "       AND categoryid = ".$row['category'];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $userPref = $res->fetch_assoc();
        
        $record->id = (int)$row['category'];
        $record->email = $userPref['email'] == null ? 1 : (int)$userPref['email'];
        $record->sms = $userPref['sms'] == null ? 1 : (int)$userPref['sms'];
        
        $out->numofrecords++;
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>