<?php
// app/api/session/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    // Validamos que existe la sesion
    $sql = "SELECT COUNT(id) AS qty FROM users ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $row = $rs->fetch_assoc();
    
    if($row['qty'] == 0){
        badEnd("401", array("msg"=>determinateMsgFail(array(
            "esp"=>"Sesión inválida",
            "eng"=>"Invalid Session"), $lang, "Sesión inválida")));
    }
    
    // Validamos que no lleve mas de 3 minutos que expiró
    $sql = "SELECT COUNT(*) AS qty FROM users ".
    "       WHERE sessionid = '".$sessionid."'".
    "       AND sessionexpires < DATE_SUB(NOW(), INTERVAL 3 MINUTE)";

    if (!$rs = $db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $row = $rs->fetch_assoc();
    
    if($row['qty'] > 0){
        badEnd("401", array("msg"=>determinateMsgFail(array(
            "esp"=>"Sesión expirada",
            "eng"=>"Expired Session"), $lang, "Sesión expirada")));
    }
    
    //Actualizamos la sesion
    $sql = "UPDATE users SET ".
    "       sessionexpires = DATE_ADD(NOW(), INTERVAL 15 MINUTE) ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $sql = "SELECT  id, sessionid,  DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt ".
    "       FROM users ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>determinateDBError($db)));
    }
    
    $row = $rs->fetch_assoc();
    
    $out->id =(int)$row["id"];
    $out->sessionid = $row["sessionid"];
    $out->validthru = $row["vt"];
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>