//Funciones globales en el main.js
/**
 * error() * drawSelectN() * esconderHTML() * formatAmount()
 **/
const xample = {
    "id": 1,
    "status": {
        "id": 3,    // 1=Por Enviar, 2=Enviado, 3=Rechazado
        "name": "Enviado",
        "ref": "43243423123123" // si status=3 > mensaje de error si status=2 código de referencia
    },
    "sendat": {     // fecha de hora programada de envío
        "date": "2023-01-26 13:45:34",
        "formatted": "26/01/2023 - 01:45 PM"
    },
    "sentat": {     // fecha efectiva del envío o del error
        "date": "2023-01-26 13:45:34",
        "formatted": "26/01/2023 - 01:45 PM"
    },
    "destination": {
        "recipient": {
            "name": "Maria Eugenia Giménez",
            "rif": "V1234567",
            "phone": "0412 1234567"
        },
        "bank": {
            "code": "0102",
            "name": "Banco de Venezuela"
        }
    },
    "origin": {
        "autor": {
            "name": "Maria Eugenia Giménez",
            "rif": "V1234567",
            "phone": "0412 1234567"
        },
        "bank": {
            "code": "0102",
            "name": "Banco de Venezuela"
        }
    },
    "description": "Motivo del envío",
    "main": {
        "currency": {
            "id": 1,
            "symbol": "VES",
            "name": "Bolívares"
        },
        "amount": {
            "number": 8.5,
            "formatted": "8,50"
        }
    },
    "wallet": {
        "id": 0,
        "dsc": "das8d90asd9a8sdasdm90fasmcas98cmas09d8a0s9d8",
        "currency": {
            "id": 1,
            "symbol": "USTD",
            "name": "USDT"
        },
        "amount": {
            "number": 0,
            "formatted": "0,00"
        },
        "fee": {
            "number": 0,
            "formatted": "0"
        },
        "total": {
            "number": 0,
            "formatted": "0"
        }
    },
};

//Desarrollado por javier 31/01/2023
const Popup = class {
    container;
    constructor(container) {
        this.container = container;
    }
    open(id) {
        var padre = document.getElementById("popsCriptoPays");
        var cards = document.getElementsByClassName("cardPopup");
        for (var i = 0; i < cards.length; i++) {
            cards[i].style.display = "";
        }
        if (document.getElementById(id) != null) document.getElementById(id).style.display = "block";
        padre.style.display = "table";
        setTimeout(function () {
            padre.style.opacity = "1";
        }, 200);
    }
    close() {
        var padre = this.container;
        padre.style.display = "";
        var cards = document.getElementsByClassName("cardPopup");
        for (var i = 0; i < cards.length; i++) {
            cards[i].style.display = "";
        }
        setTimeout(function () {
            padre.style.opacity = "";
        }, 200);
    }
}
const Form = class {
    setValues(values = {}) {
        for (let i in values) {
            if (document.getElementById(i) != undefined) {
                var ele = document.getElementById(i);
                if (ele.tagName == 'INPUT' || ele.tagName == 'SELECT') { //Si es input o select se setea el valor con .value
                    if (typeof values[i] == 'string' || typeof values[i] == 'number') {//Si se recibe un valor de texto o númerio se inserta
                        document.getElementById(i).value = values[i];
                    } else if (typeof values[i] == 'object') {
                        //Si se detecta un objeto se busca el valor "value" y se inserta si existe
                        document.getElementById(i).value = (values[i].value != undefined) ? values[i].value : "";
                        if (values[i].attributes != undefined) { //Si existe el valor "attributes" en el objeto se recorre y se crean los atributos en el elemento
                            for (let x in values[i].attributes) {
                                document.getElementById(i).setAttribute(x, values[i].attributes[x])
                            }
                        }
                    }
                } else { //Si no se inserta cómo innerText asumiendo que es un div o elemento html de texto
                    if (typeof values[i] == 'string' || typeof values[i] == 'number') {
                        document.getElementById(i).innerHTML = values[i];
                    } else if (typeof values[i] == 'object') {
                        //Si se detecta un objeto se busca el valor "value" y se inserta si existe
                        document.getElementById(i).innerHTML = (values[i].value != undefined) ? values[i].value : "";
                        if (values[i].attributes != undefined) { //Si existe el valor "attributes" en el objeto se recorre y se crean los atributos en el elemento
                            for (let x in values[i].attributes) {
                                document.getElementById(i).setAttribute(x, values[i].attributes[x])
                            }
                        }
                    }

                }
            }
        }
    }
    showError = error //Reutilizamos la función global para mostrar un error asociado a un id
    hideError(inputId, messageId) { //Reutilizamos el modelo de la función global
        document.getElementById(inputId).style.border = "";
        if (messageId != "") document.getElementById(messageId).innerHTML = "";
    }
    isEmpty(fields) {//Recibe el id de los campos y retorna un arreglo nuevo con los que están vacios
        let errFields = [];
        for (var i = 0; i < fields.length; i++) {
            var field = document.getElementById(fields[i]);
            if (field.value == "") errFields.push(fields[i]);
        }
        return errFields;
    }
}

//Creamos el objeto popup para poder acceder a el
const popup = new Popup(document.getElementById("popsCriptoPays"));
const form = new Form;


/*************El uso de elementos es solo para tener un mayor orden*********************/

//Functionalidades asociadas a los procesos asociados al código de validación
const validationcode = {
    validate(code, todook) {
        var parms = {
            'code': code,
            'sessionid': sessionStorage.getItem("sessionid")
        }

        callWS("POST", "payments/pagomovil/validatecode", parms, todook);
    },
    resend(id, todook) {
        var parms = {
            'paymentid': id,
            'sessionid': sessionStorage.getItem("sessionid")
        }

        callWS("POST", "payments/pagomovil/getvalidationcode", parms, todook);
    }
}
//Funcionalidades asociadas al manejo de cuentas del usuario
const accounts = {
    async load(selectid) {
        return new Promise((resolve, reject) => {
            var parms = {
                'sessionid': sessionStorage.getItem('sessionid'),
                'currencyid': 1,
                'numofrec': 999,
            };
            let success = (status, rsp) => {
                if (rsp != "") rsp = JSON.parse(rsp);
                switch (status) {
                    case 200:
                        let select = document.getElementById(selectid);
                        let interfaces = [1];
                        let accounts = (rsp.accounts).filter(x => interfaces.indexOf(x.currency.interface) == -1);

                        let read = "currency.symbol+ ( +balance.formatted+ )";
                        drawSelectN(select, 'id', read, accounts, '', getLangById("chooseAcc")[sessionStorage.getItem("lang")]);
                        resolve(rsp);
                        break;
                    default:
                        reject(selectid, rsp.msg);
                        break;
                }
            }
            callWS("GET", "balance/accounts", parms, success);

        });
    },
    error(selectid, msg) {
        if (selectid == 'payFrmInptAcc') {
            form.showError(selectid, "", "");
            if (msg == undefined) payform.msgError.show(getLangById("errAcc")[sessionStorage.getItem("lang")]);
            else payform.msgError.show(msg);
        } else if (selectid == 'cardUpInptAcc') {
            if (msg == undefined) form.showError(selectid, "cardUpInptAccErr", getLangById("errAcc")[sessionStorage.getItem("lang")]);
            else form.showError(selectid, "cardUpInptAccErr", msg);

        }
    }
}
//Funciones asociadas al manejo de filtros del listado
const filters = {
    fmtInptDate(date) {
        return date.getFullYear() + "-" + ((date.getMonth() + 1).toString()).padStart(2, "0") + "-" + (date.getDate().toString()).padStart(2, "0");
    },
    getRange(id) {
        let dateRange = { from: '', to: '' };
        var fNow = new Date();
        switch (id) {
            case '1'://Última semana
                var fFrom = new Date();
                fFrom.setDate(fFrom.getDate() - fNow.getDay());
                dateRange = { from: this.fmtInptDate(fFrom), to: this.fmtInptDate(fNow) }
                break;
            case '2'://Última mes
                var fFrom = new Date();
                fFrom.setDate(1);
                dateRange = { from: this.fmtInptDate(fFrom), to: this.fmtInptDate(fNow) }
                break;
            case '3'://Últimos 3 meses
                var fFrom = new Date();
                fFrom.setMonth((fNow.getMonth() - 2), 1);
                dateRange = { from: this.fmtInptDate(fFrom), to: this.fmtInptDate(fNow) }
                break;
        }
        return dateRange;
    },
    setEvents() {
        /***Eventos para los filtros del listado****/
        document.getElementById("filtRange").addEventListener("change", function () {
            let { from, to } = filters.getRange(this.value);
            document.getElementById("filtFrom").value = from;
            document.getElementById("filtTo").value = to;
            pagos.firstPag();
            pagos.load();
        });
        document.getElementById("filtStatusid").addEventListener("change", function () {
            pagos.firstPag();
            pagos.load();
        });
        document.getElementById("filtFrom").addEventListener("change", function () {
            document.getElementById("filtRange").value = "";
            pagos.firstPag();
            pagos.load();
        });
        document.getElementById("filtTo").addEventListener("change", function () {
            document.getElementById("filtRange").value = "";
            pagos.firstPag();
            pagos.load();
        });
        document.getElementById("filtSrch").addEventListener("change", function () {
            pagos.firstPag();
            pagos.load();
        });
        document.getElementById("filtSrch").addEventListener("keyup", function (e) {
            if (e.keyCode == 13 && document.getElementsByClassName("waitScreen").length == 0) {
                pagos.firstPag(); pagos.load();
            }
        });
        /****/
    }
}
//Formulario de pago a tercero manual
const payform = {
    update(id) {
        var parms = {
            'paymentid': id,
            'recipient': cleanRequest(document.getElementById("payFrmInptDest").value),
            'rif': cleanRequest(document.getElementById("payFrmInptDocTp").value + document.getElementById("payFrmInptDocId").value),
            'phone': cleanRequest(document.getElementById("payFrmInptPhnCd").value + document.getElementById("payFrmInptPhnNm").value),
            'bankcode': document.getElementById("payFrmInptBank").value,
            'VESamount': document.getElementById("payFrmInptAmo").getAttribute("datanumber"),
            'sendat': document.getElementById("payFrmInptDate").value.replace("T", " "),
            'note': document.getElementById("payFrmInptNote").value,
            'accountid': document.getElementById("payFrmInptAcc").value,
            'sessionid': sessionStorage.getItem("sessionid")
        }
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            switch (status) {
                case 200:
                    this.setConfirm(rsp.transaction);
                    console.log(rsp);
                    popup.open("cardPayConfirm");
                    break;
                case 400:
                    payform.msgError.show(rsp.msg);
                    break;
                case 402://Saldo insuficiente                    
                    form.showError("payFrmInptAcc", "", "");//Marcamos los field con error
                    payform.msgError.show(rsp.msg);
                    break;
                case 403://Monto maximo superado  
                    form.showError("payFrmInptAmo", "", "");//Marcamos los field con error
                    payform.msgError.show(rsp.msg);
                    break;
                default:
                    break;
            }
        }
        callWS("POST", "payments/pagomovil/update", parms, success);
    },
    blank() {
        //Validamos los parametros del formulario
        var fields = ["payFrmInptDest", { "id": "payFrmInptDocTp", "default": "V" }, "payFrmInptDocId", { "id": "payFrmInptPhnCd", "default": "412" },
            "payFrmInptPhnNm", "payFrmInptBank", "payFrmInptAmo", "payFrmInptAcc", "payFrmInptDate", "payFrmInptNote", "payCnfCode"];

        document.getElementById("payFrmInptAmo").removeAttribute("dataNumber");

        //Recorremos el arreglo de id's y lo marcamos cómo vacío
        var setvals = {};
        for (f of fields) {
            if (typeof f == 'object') {
                setvals[f.id] = (f.default != undefined) ? f.default : "";
            } else {
                setvals[f] = "";
            }
        }

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);
        //Seteamos el id en el continue a 0 que significa que es uno nuevo
        document.getElementById("continuePayFrm").setAttribute("payid", 0);
        //Quitamos todos los errores al formulario si existen
        payform.removeErrors();
    },
    removeErrors() {
        //Validamos los parametros del formulario
        var fields = ["payFrmInptDest", "payFrmInptDocTp", "payFrmInptDocId", "payFrmInptPhnCd",
            "payFrmInptPhnNm", "payFrmInptBank", "payFrmInptAmo", "payFrmInptAcc", "payFrmInptDate", "payFrmInptNote"];

        //Recorremos primero 1 a 1 desmarcando los "errores previos"
        for (f of fields) {
            //Cuando se valida para los doc y phn se desmarca el padre
            f = (f == 'payFrmInptDocTp' || f == 'payFrmInptDocId') ? "payFrmDoc" :
                ((f == 'payFrmInptPhnCd' || f == 'payFrmInptPhnNm') ? "payFrmPhn" : f);

            form.hideError(f, "");
        }
        //Agregamos el mensaje a la parte inferior del formulario
        payform.msgError.hide();
    },
    async preload(pay) {
        payform.blank();

        await payform.banks.load().then(console.log).catch(payform.banks.error); //Cargamos los bancos de pago movil
        await accounts.load("payFrmInptAcc").then(console.log).catch(accounts.error); //Cargamos las cuentas

        //Cuando obtenemos el pago armamos un nuevo objeto para el seteo
        //id => value
        var setvals = {};
        setvals.payFrmInptDest = pay.destination.recipient.name;
        setvals.payFrmInptDocTp = pay.destination.recipient.rif[0];
        setvals.payFrmInptDocId = pay.destination.recipient.rif.substring(1);
        setvals.payFrmInptPhnCd = pay.destination.recipient.phone.substring(0, 3);
        setvals.payFrmInptPhnNm = pay.destination.recipient.phone.substring(3);
        setvals.payFrmInptBank = pay.destination.bank.code;
        setvals.payFrmInptAcc = pay.wallet.id;
        setvals.payFrmInptAmo = {
            'value': pay.main.amount.formatted,
            'attributes': {
                'dataNumber': pay.main.amount.number,
                'decimCoin': 2
            }
        }
        //Seteamos la fecha por default a now.
        var date = new Date();
        var fdate = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T" + pad(date.getHours()) + ":" + pad(date.getMinutes());
        var limit = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T00:00:00";
        setvals.payFrmInptDate = {
            'value': fdate,
            'attributes': {
                'min': limit,
            }
        }
        setvals.payFrmInptNote = pay.description;

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);

        popup.open("cardPayFrm");
    },
    detailsPen(pay) {
        //Cuando obtenemos el pago armamos un nuevo objeto para el seteo
        //id => value
        var setvals = {};
        setvals.payfrmDetPDest = pay.destination.recipient.name + "<br>" + pay.destination.recipient.rif + "<br>" + pay.destination.recipient.phone + "<br>" + pay.destination.bank.name;
        setvals.payfrmDetPAmo = pay.main.amount.formatted + " <span class='poppins-regular'> " + pay.main.currency.symbol + " </span> ";
        setvals.payfrmDetPEqui = number_format((pay.main.amount.number * pay.rate.number), pay.wallet.currency.decimals);
        setvals.payfrmDetPEquiSym = pay.wallet.currency.symbol;
        setvals.payfrmDepPRate = calcrate(pay);
        setvals.payfrmDetPFee = number_format(calcfees(pay), pay.wallet.currency.decimals);
        setvals.payfrmDetPDate = pay.sendat.formatted;
        setvals.payfrmDetPFeeSym = pay.wallet.currency.symbol;
        setvals.payfrmDetPNote = pay.description;
        document.getElementById("stopPayFrmPen").setAttribute("payid", pay.id);

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);

        popup.open("cardPayDetPen");
    },
    detailsOk(pay) {

        //Cuando obtenemos el pago armamos un nuevo objeto para el seteo
        //id => value
        var setvals = {};
        setvals.payEntryOrg = pay.origin.autor.rif + "<br>" + pay.origin.autor.phone + "<br>" + pay.origin.bank.name;
        setvals.payEntryDest = pay.destination.recipient.name + "<br>" + pay.destination.recipient.rif + "<br>" + pay.destination.recipient.phone + "<br>" + pay.destination.bank.name;
        setvals.payEntryRef = pay.status.ref
        setvals.payEntryVes = pay.main.amount.formatted + " <span class='poppins-regular'> " + pay.main.currency.symbol + " </span> ";
        setvals.payEntryNote = pay.description;
        setvals.payEntryEqui = pay.wallet.amount.formatted;
        document.getElementById("payEntryEqui").nextElementSibling.innerHTML = " " + pay.wallet.currency.symbol;

        document.getElementById("payEntryOrgCnt").style.display = "";
        document.getElementById("payEntryRefCnt").style.display = "";

        document.getElementById("msgDetPayEntry").innerHTML = "Pago enviado con éxito";

        document.getElementById("msgDetPayEntry").parentElement.classList.remove("msgPayDetBad");
        document.getElementById("msgDetPayEntry").parentElement.classList.add("msgPayDetGood");

        //document.getElementById("payEntryEqui").innerHTML = pay.main.amount.formatted;

        setvals.msgDetPayIcon = '<i class="fas fa-check-circle" style="color: #85BB4F"></i>';

        document.getElementById("copyInf").style.display = "";

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);

        popup.open("cardPayEntry");
    },
    detailsBad(pay) {
        //Cuando obtenemos el pago armamos un nuevo objeto para el seteo
        //id => value
        var setvals = {};
        setvals.payEntryDest = pay.destination.recipient.name + "<br>" + pay.destination.recipient.rif + "<br>" + pay.destination.recipient.phone + "<br>" + pay.destination.bank.name;
        setvals.payEntryVes = pay.main.amount.formatted + " <span class='poppins-regular'> " + pay.main.currency.symbol + " </span> ";
        setvals.payEntryNote = pay.description;

        document.getElementById("payEntryOrgCnt").style.display = "none";
        document.getElementById("payEntryRefCnt").style.display = "none";


        document.getElementById("copyInf").style.display = "none";

        setvals.msgDetPayEntry = pay.status.ref;
        document.getElementById("msgDetPayEntry").parentElement.classList.add("msgPayDetBad");
        document.getElementById("msgDetPayEntry").parentElement.classList.remove("msgPayDetGood");

        setvals.payEntryEqui = number_format((pay.main.amount.number * pay.rate.number), pay.wallet.currency.decimals);//pay.wallet.amount.formatted;
        document.getElementById("payEntryEqui").nextElementSibling.innerHTML = " " + pay.wallet.currency.symbol;

        setvals.msgDetPayIcon = '<i class="fas fa-times-circle" style="color: #C04F5D"></i>';

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);


        popup.open("cardPayEntry");
    },
    setConfirm(pay) {
        //Cuando obtenemos el pago armamos un nuevo objeto para el seteo
        //id => value
        var setvals = {};
        setvals.payfrmCnfDest = pay.destination.recipient.name + "<br>" + pay.destination.recipient.rif + "<br>" + pay.destination.recipient.phone + "<br>" + pay.destination.bank.name;

        setvals.payfrmCnfAmo = pay.main.amount.formatted + " <span class='poppins-bold'> " + pay.main.currency.symbol + " </span> ";
        setvals.payfrmCnfRate = calcrate(pay);

        setvals.payfrmCnfFee = pay.wallet.fee.formatted;
        setvals.payfrmCnfFeeSym = pay.wallet.currency.symbol;

        setvals.payfrmCnfEqui = pay.wallet.amount.formatted;
        setvals.payfrmCnfEquiSym = pay.wallet.currency.symbol;

        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);


        popup.open("cardPayEntry");
    },
    banks: {
        async load() {
            return new Promise((resolve, reject) => {
                let parms = { 'sessionid': sessionStorage.getItem('sessionid') }
                let success = (status, rsp) => {
                    if (rsp != "") rsp = JSON.parse(rsp);
                    switch (status) {
                        case 200:
                            let select = document.getElementById("payFrmInptBank");
                            let banks = rsp.bancos;
                            drawSelectN(select, 'codigo', 'nombre', banks, '', getLangById("chooseBank")[sessionStorage.getItem("lang")]);
                            resolve(rsp);
                            break;
                        case 401:
                            expiredSession();
                            reject();
                            break;
                        default:
                            reject();
                            break;
                    }
                }
                callWS('GET', 'p2p/banks', parms, success);
            })
        },
        error(msg) {
            form.showError("payFrmInptBank", "", "");
            if (msg == undefined) payform.msgError.show(getLangById("errBanks")[sessionStorage.getItem("lang")]);
            else payform.msgError.show(msg);
        }
    },
    msgError: {
        show(msg) {
            document.getElementById("msgDetPay").innerHTML = msg;
            document.getElementById("msgDetPay").parentElement.classList.add("msgPayDetBad");
        },
        hide() {
            document.getElementById("msgDetPay").innerHTML = "";
            document.getElementById("msgDetPay").parentElement.classList.remove("msgPayDetBad");
        }
    }
}
//Formulario de pago a tercero carga masiva
const upfileform = {
    upload() {
        let file = (document.getElementById("fileUpPay").files.length > 0) ? document.getElementById("fileUpPay").files[0] : "";
        this.status.loading(file);
        setTimeout(function () {
            var parms = {
                'FILE': file,
                'accountid': document.getElementById("cardUpInptAcc").value,
                'sendat': document.getElementById("cardUpInptDate").value,
                'sessionid': sessionStorage.getItem("sessionid")
            }
            let success = (status, rsp) => {
                if (rsp != "") rsp = JSON.parse(rsp);
                switch (status) {
                    case 200:
                        //Seteamos si fue exitoso o si dió error
                        upfileform.status.completed(rsp.records);
                        break;
                    case 403:
                        document.getElementById("upendBtn").innerHTML = "Reintentar";
                        document.getElementById("upendBtn").setAttribute("status", "retry");
                        document.getElementById("upendStatus").classList.remove("imgCheckCnt");
                        document.getElementById("upendStatus").classList.add("imgCancelCnt");
                        document.getElementById("upendMsg").innerHTML = rsp.msg;
                        popup.open("cardUploadEnd");
                        break;
                    case 406:
                        //Seteamos si fue exitoso o si dió error
                        upfileform.status.failed(rsp);
                        break;
                    case 201:
                        document.getElementById("upendBtn").innerHTML = "Reintentar";
                        document.getElementById("upendBtn").setAttribute("status", "retry");
                        document.getElementById("upendStatus").classList.remove("imgCheckCnt");
                        document.getElementById("upendStatus").classList.add("imgCancelCnt");
                        document.getElementById("upendMsg").innerHTML = getLangById("errUpPayBal")[sessionStorage.getItem("lang")];
                        popup.open("cardUploadEnd");
                        break;
                    default:
                        //Seteamos si fue exitoso o si dió error
                        upfileform.status.failed(rsp);
                        break;
                }
            }
            callWS("POST", "payments/pagomovil/loadfile", parms, success);
        }, 500, file);
    },
    status: {
        progres: 0,
        loading(file) {
            upfileform.status.progres = 0;
            document.getElementById("buttonsUpFail").classList.add("buttonsUpProg");
            document.getElementById("buttonsUpOk").classList.add("buttonsUpProg");
            document.getElementById("cntErrSect").style.display = "";
            document.getElementById("progBarBotMsg").innerHTML = getLangById("upFileLoading")[sessionStorage.getItem("lang")] + "...";
            //Calculamos el prgoreso dianmicamente basado en el peso del archivo, manipulando la velocidad de internet podría ser más exacta
            let time = (file.size / 20);//5s por mb
            document.getElementById("progBar").classList.remove("redProg");
            document.getElementById("progBar").classList.remove("greenProg");
            document.getElementById("progBar").style.transition = 'width ' + Math.round(time) + 's';
            setTimeout(function () {
                document.getElementById("progBar").classList.add("greenProg");
            }, 100);
            document.getElementById("progBarFileName").innerHTML = file.name;
            let countprog = setInterval(function () {
                if (upfileform.status.progres >= 99) {
                    clearInterval(countprog);
                } else {
                    upfileform.status.progres = upfileform.status.progres + 1;
                }
                document.getElementById("progBarPct").innerHTML = upfileform.status.progres + "%";
            }, ((time * 1000) / 100));

        },
        completed(pays) {
            upfileform.status.progres = 100;
            document.getElementById("progBar").style.transition = '';
            document.getElementById("progBarBotMsg").innerHTML = getLangById("succesLoadPaysPre")[sessionStorage.getItem("lang")] + pays + getLangById("succesLoadPaysPos")[sessionStorage.getItem("lang")];
            document.getElementById("progBarBotMsg").classList.add("poppins-bold");
            document.getElementById("progBarBotMsg").classList.remove("poppins-regular");
            document.getElementById("buttonsUpFail").classList.add("buttonsUpProg");
            document.getElementById("buttonsUpOk").classList.remove("buttonsUpProg");
            document.getElementById("progBarPct").innerHTML = upfileform.status.progres + "%";
        },
        failed(rsp) {
            document.getElementById("cntErrSect").style.display = "block";
            upfileform.status.progres = 100;
            document.getElementById("progBarBotMsg").innerHTML = getLangById("errLoadPays")[sessionStorage.getItem("lang")];
            if (rsp.msg != null && rsp.msg != undefined) upfileform.status.error.draw(rsp);

            document.getElementById("progBarBotMsg").classList.remove("poppins-bold");
            document.getElementById("progBarBotMsg").classList.add("poppins-regular");
            document.getElementById("buttonsUpFail").classList.remove("buttonsUpProg");
            document.getElementById("buttonsUpOk").classList.add("buttonsUpProg");
            document.getElementById("progBar").style.transition = '';
            document.getElementById("progBar").classList.remove("greenProg");
            document.getElementById("progBar").classList.add("redProg");
            document.getElementById("progBarPct").innerHTML = upfileform.status.progres + "%";
        },
        error: {
            draw(rsp) {
                var tbl = document.getElementById("upprogErrorBox");
                var ele = tbl.children[0].cloneNode(true);
                var pays = rsp.msg;
                console.log(rsp);
                if (pays.length > 0) {
                    tbl.innerHTML = "";
                    var lastline = "";//Usamos esto para pintar solo la primera linea, detectamos el cambio y actualiamos
                    for (var i = 0; i < pays.length; i++) {
                        var clone = ele.cloneNode(true);
                        clone.style.display = "";
                        clone.firstElementChild.innerHTML = (lastline != pays[i].line) ? getLangById("lineLbl")[sessionStorage.getItem("lang")] + pays[i].line : "";
                        clone.lastElementChild.innerHTML = pays[i].msg;
                        lastline = pays[i].line;

                        tbl.appendChild(clone);
                    }

                } else {
                    var clone = ele.cloneNode(true);
                    clone.style.display = "none";
                    tbl.innerHTML = "";
                    tbl.appendChild(clone);
                }

            },
        }
    },
    blank() {
        //Validamos los parametros del formulario
        var fields = ["cardUpInptDate", "cardUpInptAcc", "fileUpPay", "upCnfCode"];
        //Añadimos el label original al tipo file
        document.getElementById("fileLblNm").innerText = getLangById("choseFileLbl")[sessionStorage.getItem("lang")];
        //Recorremos el arreglo de id's y armamos el elemento con los valores vacíos
        var setvals = {};
        for (f of fields) {
            if (typeof f == 'object') {
                setvals[f.id] = (f.default != undefined) ? f.default : "";
            } else {
                setvals[f] = "";
            }
        }
        //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
        form.setValues(setvals);
        //Quitamos todos los errores al formulario si existen
        upfileform.removeErrors();
    },
    removeErrors() {
        //Validamos los parametros del formulario
        var fields = ["cardUpInptDate", "cardUpInptAcc", "fileFmtCnt"];
        //Recorremos primero 1 a 1 desmarcando los "errores previos"
        for (f of fields) {
            if (f == "fileFmtCnt") form.hideError(f, "fileUpPayErr");
            else form.hideError(f, f + "Err");
        }
    },
}
//Functionalidad asociada a la lista
const pagos = {
    list: {},
    offset: 0,
    load(scroll) {
        //Si está vacío debemos retornar 0
        var statusid = (document.getElementById("filtStatusid").value == "") ? 0 : document.getElementById("filtStatusid").value;
        var offset = 0;
        if (scroll != undefined) {
            offset = pagos.offset;
        } else if (document.getElementById("numbersPaginator").getElementsByClassName("pSelect").length > 0) {//Si hay pagina marcada, si no, es 0
            offset = (document.getElementById("numbersPaginator").getElementsByClassName("pSelect")[0].getAttribute("data-page") - 1) * 10;
        }
        var parms = {
            'search': cleanRequest(document.getElementById("filtSrch").value),
            'statusid': statusid,
            'datefrom': document.getElementById("filtFrom").value,
            'dateto': document.getElementById("filtTo").value,
            'offset': offset,
            'numofrec': 10,
            'order': -1,
            'sessionid': sessionStorage.getItem("sessionid")
        }
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            switch (status) {
                case 200:
                    pagos.draw(rsp);
                    let blank = (offset == 0) ? true : false;
                    if ((pagos.offset + 10) > rsp.numofrecords) document.getElementById("responsiveTbl").setAttribute("loadend", true);
                    else document.getElementById("responsiveTbl").removeAttribute("loadend");

                    if (blank || scroll == undefined) this.list = rsp;
                    else {
                        rsp.records.forEach(function (i) {
                            if (i != undefined) pagos.list.records.push(i);
                        })
                    }
                    pagos.drawResponsive(rsp, blank);
                    break;
                case 304:
                    gotoPage('kyc', 'regC', "");
                    break;
                default:
                    break;
            }
        }
        callWS("GET", "payments/pagomovil/list", parms, success);
    },
    draw(rsp) {
        var tbl = document.getElementById("rowsCnt");
        pagos.cancel.hide();
        var ele = tbl.children[0].cloneNode(true);
        var pays = rsp.records;

        if (pays.length > 0) {
            tbl.innerHTML = "";
            for (var i = 0; i < pays.length; i++) {
                var clone = ele.cloneNode(true);
                clone.style.display = "";
                ((i % 2) == 0) ? clone.classList.add("rowBg2") : clone.classList.remove("rowBg2");

                clone.style.cursor = "pointer";
                clone.setAttribute("posid", pays[i].id);
                clone.setAttribute("statusid", pays[i].status.id);
                clone.addEventListener("click", function (e) {
                    var pay = pagos.getPay(pagos.list, this.getAttribute("posid"));//Obtenemos la info del pago que clickea el usuario
                    if (this.getAttribute("statusid") == 2) {
                        payform.detailsPen(pay);
                    } else if (this.getAttribute("statusid") == 3) {
                        document.getElementById("validPayInfo").setAttribute("paypos", this.getAttribute("posid"));
                        payform.detailsOk(pay);
                    } else if (this.getAttribute("statusid") == 4) {
                        document.getElementById("validPayInfo").setAttribute("paypos", this.getAttribute("posid"));
                        payform.detailsBad(pay);
                    }
                });

                //Si está pendiente dejamos el cuadrito activo para que se puedan cancelar
                var cell1 = clone.getElementsByClassName("cellR")[0];
                cell1.lastElementChild.checked = false;
                if (pays[i].status.id == 1 || pays[i].status.id == 2) {
                    cell1.lastElementChild.removeAttribute("disabled");
                    cell1.addEventListener("click", function (e) { e.stopPropagation(); });//Prevenimos el evento del click del editar en la celda del chec                    
                    cell1.lastElementChild.setAttribute("payid", pays[i].id);
                    cell1.lastElementChild.addEventListener("click", function (e) {
                        let checks = document.getElementsByClassName("checkPay");
                        var selected = [];

                        for (var x = 0; x < checks.length; x++) {
                            if (checks[x].checked) selected.push(checks[x].getAttribute("payid"));
                        }
                        if (selected.length > 0) {
                            pagos.cancel.show();
                        } else {
                            pagos.cancel.hide();
                        }
                        document.getElementById("paysSelected").innerHTML = selected.length;
                        document.getElementById("delcnfPays").innerHTML = selected.length + getLangById("pays")[sessionStorage.getItem("lang")]; //Aprovechamos de setear el valor para la confirmación
                        document.getElementById("delPayAccept").setAttribute("pays", selected.toString());
                    });
                } else {
                    cell1.lastElementChild.setAttribute("disabled", "");
                }

                var cell2 = clone.getElementsByClassName("cellR")[1];

                cell2.innerHTML = getStatusIcon(pays[i].status.id);
                cell2.lastElementChild.setAttribute("title", pays[i].status.name);

                var cell3 = clone.getElementsByClassName("cellR")[2];
                cell3.innerHTML = pays[i].sendat.formatted;

                var cell4 = clone.getElementsByClassName("cellR")[3];
                cell4.innerHTML = pays[i].destination.recipient.name;

                var cell5 = clone.getElementsByClassName("cellR")[4];
                cell5.innerHTML = pays[i].destination.bank.name;

                var cell6 = clone.getElementsByClassName("cellR")[5];
                cell6.innerHTML = pays[i].description;

                var cell7 = clone.getElementsByClassName("cellR")[6];
                cell7.innerHTML = pays[i].main.amount.formatted;

                tbl.appendChild(clone);
            }

        } else {
            var clone = ele.cloneNode(true);
            clone.style.display = "none";
            tbl.innerHTML = "";
            tbl.appendChild(clone);
        }
        this.drawPags(rsp.numofrecords, "numbersPaginator", 10);

    },
    drawResponsive(rsp, blank = true) {
        var tbl = document.getElementById("tableContainerR");
        pagos.cancel.hide();
        var ele = tbl.children[0].cloneNode(true);
        var pays = rsp.records;
        console.log(blank);
        console.log(rsp.records);

        if (pays.length > 0) {
            if (blank) tbl.innerHTML = "";
            for (var i = 0; i < pays.length; i++) {
                var clone = ele.cloneNode(true);
                clone.style.display = "";
                ((i % 2) == 0) ? clone.classList.add("rowBg2") : clone.classList.remove("rowBg2");

                clone.style.cursor = "pointer";
                clone.setAttribute("posid", pays[i].id);
                clone.setAttribute("statusid", pays[i].status.id);
                clone.addEventListener("click", function (e) {
                    var pay = pagos.getPay(pagos.list, this.getAttribute("posid"));//Obtenemos la info del pago que clickea el usuario
                    if (this.getAttribute("statusid") == 2) {
                        payform.detailsPen(pay);
                    } else if (this.getAttribute("statusid") == 3) {
                        document.getElementById("validPayInfo").setAttribute("paypos", this.getAttribute("posid"));
                        payform.detailsOk(pay);
                    } else if (this.getAttribute("statusid") == 4) {
                        document.getElementById("validPayInfo").setAttribute("paypos", this.getAttribute("posid"));
                        payform.detailsBad(pay);
                    }
                });

                var lblscol = clone.children[0];

                //Labels se repintan por el doble idioma
                var cell2 = lblscol.getElementsByClassName("divCellCnt")[0];
                cell2.innerHTML = getLangById("hdStatus")[sessionStorage.getItem("lang")];

                var cell3 = lblscol.getElementsByClassName("divCellCnt")[1];
                cell3.innerHTML = getLangById("hdLastop")[sessionStorage.getItem("lang")];

                var cell4 = lblscol.getElementsByClassName("divCellCnt")[2];
                cell4.innerHTML = getLangById("hdDest")[sessionStorage.getItem("lang")];

                var cell5 = lblscol.getElementsByClassName("divCellCnt")[3];
                cell5.innerHTML = getLangById("hdBank")[sessionStorage.getItem("lang")];

                var cell6 = lblscol.getElementsByClassName("divCellCnt")[4];
                cell6.innerHTML = getLangById("hdDsc")[sessionStorage.getItem("lang")];

                var cell7 = lblscol.getElementsByClassName("divCellCnt")[5];
                cell7.innerHTML = getLangById("hdAmo")[sessionStorage.getItem("lang")];

                var valcol = clone.children[1];

                //Si está pendiente dejamos el cuadrito activo para que se puedan cancelar
                var cell1 = clone.lastElementChild.getElementsByClassName("centerP")[0];
                cell1.lastElementChild.checked = false;
                if (pays[i].status.id == 1 || pays[i].status.id == 2) {
                    cell1.lastElementChild.removeAttribute("disabled");
                    cell1.addEventListener("click", function (e) { e.stopPropagation(); });//Prevenimos el evento del click del editar en la celda del chec                    
                    cell1.lastElementChild.setAttribute("payid", pays[i].id);
                    cell1.lastElementChild.addEventListener("click", function (e) {
                        let checks = document.getElementsByClassName("checkPayR");
                        var selected = [];

                        for (var x = 0; x < checks.length; x++) {
                            if (checks[x].checked) selected.push(checks[x].getAttribute("payid"));
                        }
                        if (selected.length > 0) {
                            pagos.cancel.show();
                        } else {
                            pagos.cancel.hide();
                        }
                        document.getElementById("paysSelected").innerHTML = selected.length;
                        document.getElementById("delcnfPays").innerHTML = selected.length + getLangById("pays")[sessionStorage.getItem("lang")]; //Aprovechamos de setear el valor para la confirmación
                        document.getElementById("delPayAccept").setAttribute("pays", selected.toString());
                    });
                } else {
                    cell1.lastElementChild.setAttribute("disabled", "");
                }

                var cell2 = valcol.getElementsByClassName("divCellCnt")[0];
                cell2.innerHTML = getStatusIcon(pays[i].status.id);
                cell2.lastElementChild.setAttribute("title", pays[i].status.name);

                var cell3 = valcol.getElementsByClassName("divCellCnt")[1];
                cell3.innerHTML = pays[i].sendat.formatted;

                var cell4 = valcol.getElementsByClassName("divCellCnt")[2];
                cell4.innerHTML = pays[i].destination.recipient.name;

                var cell5 = valcol.getElementsByClassName("divCellCnt")[3];
                cell5.innerHTML = pays[i].destination.bank.name;

                var cell6 = valcol.getElementsByClassName("divCellCnt")[4];
                cell6.innerHTML = pays[i].description;

                var cell7 = valcol.getElementsByClassName("divCellCnt")[5];
                cell7.innerHTML = pays[i].main.amount.formatted;
                tbl.appendChild(clone);
            }

        } else if (blank) {
            var clone = ele.cloneNode(true);
            clone.style.display = "none";
            tbl.innerHTML = "";
            tbl.appendChild(clone);
        }
    },
    getPay(rsp = {}, id) {
        var pays = rsp.records;
        let pay = (pays.length > 0) ? pays.filter((pay) => pay.id == id)[0] : {};
        return pay;
    },
    drawPags(numofrecords, tbl, limit) {
        var pages = Math.ceil(numofrecords / limit);
        var numbersPaginator = document.getElementById(tbl);
        var n = 6; //Número de paginas visibles

        //Obtenemos la pagina anterior antes de borrarlas y montar la nueva
        var lastPag = 0;
        if (numbersPaginator.getElementsByClassName("pSelect").length > 0) {
            lastPag = numbersPaginator.getElementsByClassName("pSelect")[0].getAttribute("data-page");
        }
        numbersPaginator.innerHTML = "";
        var initialPage = 0;
        if (pages > n) {  // cambio de formato en caso de mas de n paginas
            initialPage = Math.max((lastPag - Math.ceil(n / 2) + 2), 1) - 1;
        }

        // puntitos iniciales cuando son más de 10 página y no se empieza por la primera
        if (pages > n && initialPage !== 0 && initialPage !== 1) {
            spanF = document.createElement("div");
            spanF.classList.add("pages");
            spanF.innerHTML = "1 ...";
            spanF.dataset.page = 1;
            spanF.style.cursor = "pointer";
            spanF.addEventListener("click", function () {
                //Se desmarca la pagina anterior
                var pSel = document.getElementsByClassName("pSelect");
                if (pSel.length > 0) pSel[0].classList.remove("pSelect");

                //Se actualiza la pagina seleccionada
                this.classList.add("pSelect");

                pagos.load();
            });
            numbersPaginator.appendChild(spanF);
        }

        //Pintar paginas de table (numeros)
        for (var k = initialPage; k < pages && !(k - initialPage > n - 1); k++) {
            var p = document.createElement("div");
            p.classList.add("pages");
            p.innerHTML = k + 1;
            p.dataset.page = k + 1;
            if (lastPag == 0 && k == 0) p.classList.add("pSelect");//Se selecciona la página 1
            else if (lastPag !== 0 && (lastPag - 1) == k) p.classList.add("pSelect");

            p.addEventListener("click", function () {
                //Se desmarca la pagina anterior
                var pSel = document.getElementsByClassName("pSelect");
                if (pSel.length > 0) pSel[0].classList.remove("pSelect");

                //Se actualiza la pagina seleccionada
                this.classList.add("pSelect");

                pagos.load();
            });
            p.style.cursor = "pointer";

            numbersPaginator.appendChild(p);

        }

        // puntitos si no se ven las útlimas páginas
        if (pages > n && initialPage + n < pages) {
            spanL = document.createElement("div");
            spanL.classList.add("pages");
            spanL.innerHTML = "... " + pages;
            spanL.dataset.page = pages;
            spanL.style.cursor = "pointer";
            spanL.addEventListener("click", function () {
                //Se desmarca la pagina anterior
                var pSel = document.getElementsByClassName("pSelect");
                if (pSel.length > 0) pSel[0].classList.remove("pSelect");

                //Se actualiza la pagina seleccionada
                this.classList.add("pSelect");

                pagos.load();
            });
            numbersPaginator.appendChild(spanL);
        }
    },
    firstPag() {
        if (document.getElementsByClassName("pSelect").length > 0) document.getElementsByClassName("pSelect")[0].classList.remove("pSelect");
    },
    arrowsPagsEvent(tbl) {//Esta es una función de asignación de eventos, solo se debe llamar una vez por tbl
        var numbersPaginator = document.getElementById(tbl);
        const leftArrow = numbersPaginator.previousElementSibling;
        //Previous arrow
        leftArrow.addEventListener("click", function () {
            var pSel = document.getElementsByClassName("pSelect");
            if (pSel.length > 0) {
                //Si el elemento anterior al seleccionado es una pagina
                if (pSel[0].previousElementSibling != null && pSel[0].previousElementSibling.classList.contains("pages")) {
                    let toRemove = pSel[0];
                    pSel[0].previousElementSibling.classList.add("pSelect");//asignamos la clase al nuevo
                    toRemove.classList.remove("pSelect");

                    pagos.load();
                }
            }
        });

        const rightArrow = numbersPaginator.nextElementSibling;
        //Next arrow
        rightArrow.addEventListener("click", function () {
            var pSel = document.getElementsByClassName("pSelect");
            if (pSel.length > 0) {
                //Si el elemento anterior al seleccionado es una pagina
                if (pSel[0].nextElementSibling != null && pSel[0].nextElementSibling.classList.contains("pages")) {
                    let toRemove = pSel[0];
                    pSel[0].nextElementSibling.classList.add("pSelect");//asignamos la clase al nuevo
                    toRemove.classList.remove("pSelect");

                    pagos.load();
                }
            }
        });
    },
    cancel: {
        show() {
            let footbar = document.getElementById("footSelectedCnt");
            footbar.style.bottom = "0";
        },
        hide() {
            let footbar = document.getElementById("footSelectedCnt");
            footbar.style.bottom = "";
        },
        execute(ids) {//Recibe los ids separados por guiones
            var parms = {
                'paymentid': ids,
                'sessionid': sessionStorage.getItem("sessionid")
            }
            let success = (status, rsp) => {
                if (rsp != "") rsp = JSON.parse(rsp);
                switch (status) {
                    case 200:
                        //Cerrar el popup de confirmación de está seguro que desea cancelar x pagos
                        pagos.load();
                        popup.close();

                        break;
                    case 304:
                        gotoPage('kyc', 'regC', "");
                        break;
                    default:
                        break;
                }
            }
            callWS("POST", "payments/pagomovil/delete", parms, success);

        }
    }
}
//Función de inicio, esta función se llama en el main.js que se carga siempre al completar el window.onload
function start() {
    if (window.innerWidth <= 800) {
        document.getElementById("responsiveTbl").addEventListener("scroll", function () {
            if ((this.getAttribute("loadend") !== "true")) {
                let scrollBottom = this.scrollHeight - (this.scrollTop + this.offsetHeight);
                if (scrollBottom <= 1 && document.getElementsByClassName("waitScreen").length <= 0) {
                    pagos.offset = pagos.offset + 10;
                    pagos.load(1);
                }
            }
        });
        document.getElementById("webviewTbl").style.display = "";
        document.getElementById("responsiveTbl").style.display = "block";
    } else {
        document.getElementById("webviewTbl").style.display = "block";
        document.getElementById("responsiveTbl").style.display = "";
    }

    /**LE damos formato amount a los campos del modulo que lo requieran */
    var fieldAmo = ["payFrmInptAmo"];
    formatAmount(fieldAmo);
    document.getElementById("payFrmInptAmo").addEventListener("keyup", function () {
        //Limitación de decimales replicada de procesos anteriores
        var noVal = formatCurrency(this.getAttribute("decimcoin"), this.value);
        if (noVal !== "") this.value = noVal;
    });
    /** CARGA MASIVA
    * Eventos para el proceso de carga de archivos para cripto pagos 
    **/

    //Abrir el popup para cargar
    document.getElementById("upBtn").addEventListener("click", async function () {
        upfileform.blank();

        await accounts.load("cardUpInptAcc").then(console.log).catch(accounts.error); //Cargamos las cuentas

        //Seteamos la fecha por default a now.
        var date = new Date();
        var fdate = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T" + pad(date.getHours()) + ":" + pad(date.getMinutes());
        var limit = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T00:00:00";
        document.getElementById("cardUpInptDate").value = fdate;
        document.getElementById("cardUpInptDate").min = limit;

        popup.open("cardUpload");
    });


    /**Formulario de carga del archivo **/

    //Descargar plantilla
    document.getElementById("xampleFileCnt").addEventListener("click", function () {
        var text = './hooks/public/plantilla.csv';
        var filename = "plantilla.csv";
        download(filename, text);
    });


    //Botón de cancelar carga archivo masivo
    document.getElementById("cancelBtnUp").addEventListener("click", function () {
        popup.close();
    });

    //Boton de continuar abrir el popup mostrar el progreso durante la carga o si encuentra algún error
    document.getElementById("submitBtnUp").addEventListener("click", function () {
        upfileform.removeErrors();
        var file = document.getElementById("fileUpPay");
        var vtype = (file.files.length > 0) ? (file.files[0].type == 'text/csv') : false;
        var accountid = document.getElementById("cardUpInptAcc");
        var date = document.getElementById("cardUpInptDate");
        let error = false;
        //Si no es valido el tipo da error
        if (!vtype) {
            form.showError("fileFmtCnt", "fileUpPayErr", getLangById("errUpFileFmt")[sessionStorage.getItem("lang")]);
            file.value = "";
            error = true;
        }
        //Si no es valido el tipo da error
        if (accountid.value == "") {
            form.showError("cardUpInptAcc", "cardUpInptAccErr", getLangById("chsValidAcc")[sessionStorage.getItem("lang")]);
            error = true;
        }
        //Si no es valido el tipo da error
        if (date.value == "") {
            form.showError("cardUpInptDate", "cardUpInptDateErr", getLangById("chsValidDate")[sessionStorage.getItem("lang")]);
            error = true;
        }
        if (error) return;//Si dió error no llegamos al final 

        popup.open("cardUploadProg");
        upfileform.upload();
    });
    //Si se detecta un cambio en el input file se valida el archivo y se inserta el nombre
    document.getElementById("fileUpPay").addEventListener("change", function () {
        var vtype = (this.files.length > 0) ? (this.files[0].type == 'text/csv') : false;
        //Si no es valido el tipo da error
        if (!vtype) {
            form.showError("fileFmtCnt", "fileUpPayErr", getLangById("errUpFileFmt")[sessionStorage.getItem("lang")]);
            this.value = "";
            return;
        }
        //Si hay archivo y el vfile es valido, llegó hasta acá insertamos el nombre y mantenemos el value
        var fname = (this.files.length > 0 && vtype) ? this.files[0].name : getLangById("choseFileLbl")[sessionStorage.getItem("lang")];
        document.getElementById("fileLblNm").innerText = fname;
    });

    //Si se pulsa el label de "examinar" se abre el input file
    document.getElementById("searchLblBtn").addEventListener("click", function () {
        document.getElementById("fileUpPay").click();
    });

    /**************************************/

    /** Formulario de carga de barra de progreso exitoso o errores listado **/

    //Botón de cancelar (fallido) pantalla progreso archivo masivo
    document.getElementById("cancelStatUpBtn").addEventListener("click", function () {
        popup.close();
    });

    //Botón de reintentar (fallido) Si falla y el usuario quiere reintentar mostramos el popup de carga y blanqueamos el archivo
    document.getElementById("tryagainStatUpBtn").addEventListener("click", function () {
        //Añadimos el label original al tipo file
        document.getElementById("fileLblNm").innerText = getLangById("choseFileLbl")[sessionStorage.getItem("lang")];
        document.getElementById("fileUpPay").value = "";
        //Abrir popup carga
        popup.open("cardUpload");
    });

    //Botón de enviar (exitoso) El usuario le da a confirmar y sale el popup de doble validación
    document.getElementById("confirmStatUpBtn").addEventListener("click", function () {
        //Abrir popup carga
        popup.open("cardUploadConfirm");
    });

    //Botón de cancelar (exitoso) pantalla progreso carga archivo masivo
    document.getElementById("exitStatUpBtn").addEventListener("click", function () {
        popup.close();
    });

    /*************************************/

    /** Formulario de doble confirmación para la carga masiva **/

    //Continuar y validar la carga luego de que el archivo fue cargado
    document.getElementById("validUpAccept").addEventListener("click", function () {
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            switch (status) {
                case 200:
                    document.getElementById("upendBtn").innerHTML = "Finalizar";
                    document.getElementById("upendBtn").setAttribute("status", "end");
                    document.getElementById("upendStatus").classList.add("imgCheckCnt");
                    document.getElementById("upendStatus").classList.remove("imgCancelCnt");
                    document.getElementById("upendMsg").innerHTML = getLangById("successUpPay")[sessionStorage.getItem("lang")];

                    pagos.load();//Refrescamos el listado

                    popup.open("cardUploadEnd");
                    break;
                case 400:
                    let msg = (rsp.msg !== undefined) ? rsp.msg : getLangById("errInvalidCode")[sessionStorage.getItem("lang")];
                    form.showError("upCnfCode", "upCnfCodeErr", msg);//Marcamos los field con error
                    break;
                case 402:
                    form.showError("upCnfCode", "upCnfCodeErr", getLangById("errInvalidCode")[sessionStorage.getItem("lang")]);//Marcamos los field con error
                    break;
                default:
                    /*
                    let msg = "Lo sentimos, por favor intente nuevamente más tarde";
                    if (rsp.msg != undefined) msg = rsp.msg;
                    form.showError("upCnfCode", "upCnfCodeErr", msg);//Marcamos los field con error*/
                    document.getElementById("upendBtn").innerHTML = "Reintentar";
                    document.getElementById("upendBtn").setAttribute("status", "retry");
                    document.getElementById("upendStatus").classList.remove("imgCheckCnt");
                    document.getElementById("upendStatus").classList.add("imgCancelCnt");
                    document.getElementById("upendMsg").innerHTML = getLangById("errUpPay")[sessionStorage.getItem("lang")];
                    popup.open("cardUploadEnd");
                    break;
            }
        }
        if (document.getElementById("upCnfCode").value == "")
            form.showError("upCnfCode", "upCnfCodeErr", getLangById("errInvalidCode")[sessionStorage.getItem("lang")]);
        else
            validationcode.validate(document.getElementById("upCnfCode").value, success);
    });

    //Botón de Anular el proceso durante la doble confirmación, acá se debe cancelar la operación de una
    document.getElementById("cancelUpAccept").addEventListener("click", function () {
        popup.close();
    });

    //Reenviar código de validación
    document.getElementById("upfrmResend").addEventListener("click", function () {
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            switch (status) {
                case 200:
                    break;
                default:
                    let msg = (rsp.msg != undefined) ? rsp.msg : getLangById("errResend")[sessionStorage.getItem("lang")];
                    form.showError("upCnfCode", "upCnfCodeErr", msg);//Marcamos los field con error
                    break;
            }
        }
        validationcode.resend(this.getAttribute("payid"), success);
    });

    /*************************************/

    /** Popup final del proceso de carga masiva, permite reintentar si falló o finalizar si concluyó con éxito **/
    document.getElementById("upendBtn").addEventListener("click", function () {
        if (this.getAttribute("status") == 'end') {
            popup.close();
        } else if (this.getAttribute("status") == 'retry') {
            upfileform.blank();
            popup.open("cardUpload");
        }
    });

    /*************************************/

    /******* HASTA AQUÍ LA CARGA MASIVA ********/

    /** CARGA MANUAL
    * Eventos para el proceso de registro manual de cripto pagos 
    **/

    //Abrir el popup para añadir un registro manual
    document.getElementById("addBtn").addEventListener("click", async function () {
        payform.blank(); //Blanqueamos errores y datos

        await payform.banks.load().then(console.log).catch(payform.banks.error); //Cargamos los bancos de pago movil
        await accounts.load("payFrmInptAcc").then(console.log).catch(accounts.error); //Cargamos las cuentas

        //Seteamos la fecha por default a now.
        var date = new Date();
        var fdate = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T" + pad(date.getHours()) + ":" + pad(date.getMinutes());
        var limit = date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + "T00:00:00";
        document.getElementById("payFrmInptDate").value = fdate;
        document.getElementById("payFrmInptDate").min = limit;

        popup.open("cardPayFrm");
    });

    /*** Formulario de regisro manual del pago ***/
    //Cancelar la carga del registro manual
    document.getElementById("cancelPayFrm").addEventListener("click", function () {
        popup.close();
    });

    //Continuar del formualrio de pago manual a la doble validación
    document.getElementById("continuePayFrm").addEventListener("click", function () {
        payform.removeErrors();//Se blanquean los errores y 
        var required = ["payFrmInptDest", "payFrmInptDocTp", "payFrmInptDocId", "payFrmInptPhnCd",
            "payFrmInptPhnNm", "payFrmInptBank", "payFrmInptAmo", "payFrmInptAcc", "payFrmInptDate", "payFrmInptNote"];

        var isValid = form.isEmpty(required);//Validan los campos y se retornan los que están vacíos
        if ((isValid).length > 0) {//Si hay algun campo en blanco mostramos error
            for (var i = 0; i < isValid.length; i++) {
                var field = isValid[i];//Retorna el campo a marcar 

                //Cuando se valida para los doc y phn se marca el padre
                field = (field == 'payFrmInptDocTp' || field == 'payFrmInptDocId') ? "payFrmDoc" :
                    ((field == 'payFrmInptPhnCd' || field == 'payFrmInptPhnNm') ? "payFrmPhn" : field);

                form.showError(field, "", "");//Marcamos los field vacios

                //Mostramos el error
                payform.msgError.show(getLangById("errEmptyParms")[sessionStorage.getItem("lang")]);
            }
        } else {//Si está todo ok llamamos el update
            //popup.open("cardPayConfirm");
            payform.update(this.getAttribute("payid"));
        }
    });

    //Limitar telefono
    document.getElementById("payFrmInptPhnNm").addEventListener("keyup", function () {
        this.value = limitNumberTo(7, this.value);
    });
    //Limitar C.I
    document.getElementById("payFrmInptDocId").addEventListener("keyup", function () {
        this.value = limitNumberTo((document.getElementById("payFrmInptDocTp").value == "J" ? 11 : 10), this.value);
    });

    /*************************************/

    /***** Eventos pantalla de confirmación de pago ******/
    //Abrir el popup para añadir un registro manual
    document.getElementById("validPayAccept").addEventListener("click", function () {
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            var msg = "";
            switch (status) {
                case 200:
                    var setvals = {};
                    setvals.payfrmDetDest = document.getElementById("payfrmCnfDest").innerHTML;
                    setvals.payfrmDetAmo = document.getElementById("payfrmCnfAmo").innerHTML;
                    setvals.payfrmDetEqui = document.getElementById("payfrmCnfEqui").innerHTML;
                    setvals.payfrmDetEquiSym = document.getElementById("payfrmCnfEquiSym").innerHTML;
                    //Seteamos los inputs definidos arriba pertenecientes al formulario de pago manual
                    form.setValues(setvals);

                    pagos.load();//Refrescamos el listados

                    popup.open("cardPayDet");
                    break;
                case 400:
                    msg = (rsp.msg !== undefined) ? rsp.msg : getLangById("errInvalidCode")[sessionStorage.getItem("lang")];
                    form.showError("payCnfCode", "payCnfCodeErr", msg);//Marcamos los field con error
                    break;
                case 402:
                    form.showError("payCnfCode", "payCnfCodeErr", getLangById("errInvalidCode")[sessionStorage.getItem("lang")]);//Marcamos los field con error
                    break;
                default:
                    msg = getLangById("errNotDetected")[sessionStorage.getItem("lang")];
                    if (rsp.msg != undefined) msg = rsp.msg;
                    form.showError("payCnfCode", "payCnfCodeErr", msg);//Marcamos los field con error
                    break;
            }
        }
        if (document.getElementById("payCnfCode").value == "")
            form.showError("payCnfCode", "payCnfCodeErr", getLangById("errInvalidCode")[sessionStorage.getItem("lang")]);
        else
            validationcode.validate(document.getElementById("payCnfCode").value, success);
    });

    //Cancelar la carga del registro manual
    document.getElementById("cancelPayAccept").addEventListener("click", function () {
        popup.close();
    });

    //Reenviar código de validación
    document.getElementById("payfrmResend").addEventListener("click", function () {
        let success = (status, rsp) => {
            if (rsp != "") rsp = JSON.parse(rsp);
            switch (status) {
                case 200:
                    break;
                default:
                    let msg = (rsp.msg != undefined) ? rsp.msg : getLangById("errResend")[sessionStorage.getItem("lang")];
                    form.showError("payCnfCode", "payCnfCodeErr", msg);//Marcamos los field con error
                    break;
            }
        }
        validationcode.resend(this.getAttribute("payid"), success);
    });

    /************************************/

    /****** Detalle en la confirmación *******/
    //Salir del proceso al final
    document.getElementById("acceptClosePay").addEventListener("click", function () {
        popup.close();
    });

    /************************************/

    /** Detalle de una operación concluida cómo exitosa o rechazada **/
    //Salir del detalle
    document.getElementById("cancelPayInf").addEventListener("click", function () {
        popup.close();
    });
    //Reenviar la operación desde el detalle
    document.getElementById("validPayInfo").addEventListener("click", function () {
        var pay = pagos.getPay(pagos.list, this.getAttribute("paypos"));//Obtenemos la info del pago que clickea el usuario
        document.getElementById("continuePayFrm").setAttribute("payid", 0);
        payform.preload(pay);
    });

    /** Detalle de operación pendiente **/
    document.getElementById("cancelPayFrmPen").addEventListener("click", function () {
        popup.close();
    });
    /** Detener una operación pendiente **/
    document.getElementById("stopPayFrmPen").addEventListener("click", function () {
        document.getElementById("delPayAccept").setAttribute("pays", this.getAttribute("payid"));
        document.getElementById("delcnfPays").innerHTML = getLangById("payPenLbl")[sessionStorage.getItem("lang")];
        popup.open("cardDelPayCnf");
    });
    /** Detener una operación pendiente **/
    document.getElementById("copyInf").addEventListener("click", function () {
        this.style.textDecoration = "underline";
        this.style.paddingLeft = "1px";
        setTimeout(function (ele) {
            ele.removeAttribute("style");
        }, 200, this);
        var txtcopy = "";

        txtcopy += "Ref:" + document.getElementById("payEntryRef").innerText + "; ";
        txtcopy += capitalize(getLangById("mainAmo")[sessionStorage.getItem("lang")], true) + ": " + document.getElementById("payEntryVes").innerText + "; ";
        txtcopy += getLangById("payEntryOrgLbl")[sessionStorage.getItem("lang")] + ": " + (document.getElementById("payEntryOrg").innerHTML).replace(/<br>/g, ", ") + "; ";
        txtcopy += getLangById("hdDsc")[sessionStorage.getItem("lang")] + ": " + document.getElementById("payEntryNote").innerText;
        copyToClipboard(txtcopy);
    });


    /************************************/
    /******* HASTA AQUÍ LA CARGA MANUAL ********/

    //Check all, asignamos el evento de marcar todos al header
    document.getElementById("checkHead").addEventListener("click", function (e) {
        let checks = document.getElementsByClassName("checkPay");
        var selected = [];
        for (var x = 0; x < checks.length; x++) {
            if (this.checked) {
                if (!checks[x].disabled) {
                    checks[x].checked = true;
                    selected.push(checks[x].getAttribute("payid"));
                }
            } else {
                checks[x].checked = false;
            }
        }
        if (selected.length > 0) pagos.cancel.show();
        else pagos.cancel.hide();

        document.getElementById("paysSelected").innerHTML = selected.length;
        let lbl = getLangById("paysPenLbl")[sessionStorage.getItem("lang")];
        let onelbl = getLangById("payPenLbl")[sessionStorage.getItem("lang")];
        document.getElementById("delcnfPays").innerHTML = (selected.length > 1) ? selected.length + lbl : ((selected.length == 1) ? onelbl : ""); //Aprovechamos de setear el valor para la confirmación
        document.getElementById("delPayAccept").setAttribute("pays", selected.toString());
    });
    //Boton de la barra inferior emergente para detener los pagos que despliega la confirmación
    document.getElementById("stopPaysBtn").addEventListener("click", function () {
        popup.open("cardDelPayCnf");
    });

    //Poup de confirmar el eliminar botón cancelar
    document.getElementById("delPayCancel").addEventListener("click", function () {
        popup.close();
    });

    //Poup de confirmar el eliminar botón aceptar
    document.getElementById("delPayAccept").addEventListener("click", function () {
        pagos.cancel.execute(this.getAttribute("pays").replace(/\,/g, "-"));
    });

    //Añadimos los eventos de los filtros del listado
    filters.setEvents();

    //Asignar eventos a las flechas del listado de pagos a terceros
    pagos.arrowsPagsEvent("numbersPaginator");

    esconderHTML(false);
    getEntry();
    pagos.load();


    setLang();
}
//Se cargan todos los procesos relacionados a insertar el texto en el idioma correspondiente
function setLang() {
    addFooter();//Se valida el texto sengun el doble idioma del footer

    lang = sessionStorage.getItem('lang');

    //Select filtro rango fechas en doble idioma
    var filtrange = {};
    filtrange.esp = [{ "id": "1", "dsc": "Última Semana" }, { "id": "2", "dsc": "Último Mes" }, { "id": "3", "dsc": "Últimos 3 Mes" }];
    filtrange.eng = [{ "id": "1", "dsc": "Last Week" }, { "id": "2", "dsc": "Last Month" }, { "id": "3", "dsc": "Last 3 Months" }];
    var first = sessionStorage.getItem('lang') == 'esp' ? "Seleccionar Periodo" : 'Select Period';
    drawSelectN(document.getElementById("filtRange"), 'id', 'dsc', filtrange[sessionStorage.getItem('lang')], "", first);

    //Select filtro status en doble idioma
    var filtrange = {};
    filtrange.esp = [{ "id": "2", "dsc": "Por Enviar" }, { "id": "3", "dsc": "Enviado" }, { "id": "4", "dsc": "Rechazado" }];
    filtrange.eng = [{ "id": "2", "dsc": "To Send" }, { "id": "3", "dsc": "Sent" }, { "id": "4", "dsc": "Rejected" }];
    var first = sessionStorage.getItem('lang') == 'esp' ? "Ver Todos" : 'See Alls';
    drawSelectN(document.getElementById("filtStatusid"), 'id', 'dsc', filtrange[sessionStorage.getItem('lang')], "", first);

    langs = [
        "expired1", "expired2", "expSessionButton", //Popup sesión inválida (esto debería ser global)
        { "balance": ["balance", "balanceR"] }, { "home": ["home", "homeR"] }, { "preferences": ["preferences", "preferencesR"] }, //Headers (esto debería ser glob)
        { "cryptopayments": ["cryptopayments", "titleBalance"] },//Cripto Pagos
        "labelSearch", "copyInf",//Buscar
        "hdStatus", "hdLastop", //Estatus, Última Operación
        { "hdDest": ["hdDest", "payFrmInptDestLbl", "payfrmCnfDestLbl", "payfrmDetDestLbl", "payfrmDetPDestLbl", "payEntryDestLbl"] },//Destinatario
        { "hdBank": ["hdBank", "payFrmInptBankLbl"] },//Bank
        { "hdDsc": ["hdDsc", "payFrmInptNoteLbl", "payfrmDetPNoteLbl", "payEntryNoteLbl"] },//Motivo
        { "hdAmo": ["hdAmo", "payFrmInptAmoLbl"] },//Monto
        { "equiAmo": ["payfrmDetEquiLbl", "payfrmCnfEquiLbl", "payfrmDetPEquiLbl", "payEntryEquiLbl"] },//Monto Equivalente
        { "aproxFee": ["payfrmDetPFeeLbl", "payfrmCnfFeeLbl"] },//Comisión Aproximada
        { "mainAmo": ["payfrmDetPAmoLbl", "payfrmDetAmoLbl", "payEntryVesLbl"] },
        "payEntryOrgLbl",//Origen
        { "orgAccount": ["cardUpInptAccLbl", "payFrmInptAccLbl"] },
        {
            "cancel": ["delPayCancel", "cancelPayInf", "cancelPayFrmPen", "cancelPayAccept", "cancelPayFrm",
                "cancelBtnUpLbl", "cancelUpAccept", "exitStatUpBtn", "cancelStatUpBtn"]//Cancelar
        },
        "continuePayFrm", "submitBtnUpLbl", "payfrmCnfAmoLbl", "payFrmPhnLbl",//Enviar, Subir, Monto a Enviar, Teléfono (mayus)
        { "resendCode": ["payfrmResend", "upfrmResend"] },//Reenviar código
        { "cnfMailMsgLbl": ["upCnfMailmsgLbl", "payfrmCnfMailmsgLbl"] },//Mensaje envío de correo en doble confirmación
        { "validAccept": ["validPayAccept", "validUpAccept"] },//Validar (mayus)
        "carPayFrmTit", "payFrmDocLbl", "acceptClosePay", "cardPayDetPenTit", "cadPayEntryTit",//Enviar Pago, Cédula/Rif, Finalizar (mayus), Cripto Pago Pendiente, Detalles Cripto Pago
        "paydetTit", "cardUpProgTit", "cardUpTit", "xampleFileLbl", "fileFmtCntLbl", "searchLblBtn",//Transacción Exitosa, Confirmación, Subir Archivo, Plantilla, Archivo, Explorar
        "confirmStatUpBtn", "tryagainStatUpBtn", "pagosSelStopLbl", "stopPaysBtn", //Confirmar (mayus), Reintentar (mayus), pagos seleccionados (bottom lbl), detenner pagos 
        { "cardPayConfirmTit": ["cardPayConfirmTit", "cardUpConfirmTit"] }, //Enviar Cripto Pago VES
        { "msgPen": ["msgSuccessEnd", "msgPenDet"] },//Mensaje de 24hs en procesar pago
        { "delPayAccept": ["delPayAccept", "stopPayFrmPen"] },
        "validPayInfo", "delcnfPaysPremsg", "delcnfPaysPostmsg", //Enviar de nuevo (mayus), Msg conf delete PRE y post,
        { "cardUpInptDateLbl": ["cardUpInptDateLbl", "payFrmInptDateLbl"] },//Fecha y hora de envío 
        { "rateLbl": ["payfrmDepPRateLbl", "payfrmCnfRateLbl"] }, //Tasa de Cambio AFX
        { "rateWarn": ["rateWarn", "rateWarnDetP"] }, //Advertencia de cambios en la tasa
    ];
    let langob = {};
    //El label es el id del campo y el valor es el id del lang (para rehuso)
    for (oneid of langs) {
        if ((typeof oneid) == "object") {
            for (id in oneid) {//Aca obtenemos el id del lang
                for (ids of oneid[id]) {//Acá todos los id's a los que se les asigna
                    langob[ids] = getLangById(id)[lang];
                }
            }
        } else langob[oneid] = getLangById(oneid)[lang];
    }

    //Place holders en input's
    document.getElementById("payFrmInptDest").setAttribute("placeholder", getLangById("payfrmDestPh")[sessionStorage.getItem("lang")]);
    form.setValues(langob);

}
//Funciones de utilidad genericas
function cleanRequest(val) {
    //Esta función quita cosas de query o mal formaciones en los request
    return val;
}
//Consultamos la información del usuario
function getEntry() {
    let success = (status, rsp) => {
        if (rsp != "") rsp = JSON.parse(rsp);
        switch (status) {
            case 200:
                entrydata = rsp.entry;
                document.getElementById("payfrmCnfMailmsg").lastElementChild.innerHTML = hiddenText(rsp.entry.usr);
                document.getElementById("upCnfMailmsg").lastElementChild.innerHTML = hiddenText(rsp.entry.usr);
                if (rsp.notifications > 0) {
                    document.getElementById('messageNotification').style.display = "table";
                    document.getElementById('messageNotification').children[0].innerHTML = rsp.notifications;
                } else {
                    document.getElementById('messageNotification').style.display = "none";
                    document.getElementById('messageNotification').children[0].innerHTML = "";
                }
                view = rsp.entry.view;
                if (entrydata.level.id == 4) entrydata.level.id = 0.5;
                break;
            case 204:
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }
    callWS("GET", "users/entry", { 'sessionid': sessionStorage.getItem('sessionid') }, success);
}
//Oculta parcialmente el texto con asteriscos
function hiddenText(mail) {
    var mitad = mail.length / 2;
    var placetoremove = mail.substring(Math.floor(mitad) - 3, (mail.length - (mitad / 4)));
    var dif = (mail.length - (mitad / 4)) - (Math.floor(mitad) - 3);
    var replacefor = ("*").padStart(dif, "*");
    return mail.replace(placetoremove, replacefor);

}
//Calcular la tasa
function calcrate(pay) {
    //Determinar entero mayor en tasas                                        
    var rateA = parseFloat(pay.rate.number).noExponents();
    var rateB = (1 / rateA).noExponents();
    var realRate = rateA;
    var currA = pay.main.currency.symbol;
    var currB = pay.wallet.currency.symbol;
    var decimRate = pay.wallet.currency.decimals;

    if (rateB > rateA) {
        realRate = rateB;
        currB = pay.main.currency.symbol;
        currA = pay.wallet.currency.symbol;
        decimRate = pay.main.currency.decimals;

    }
    //Tasa
    return (currA + " = " + currB + " " + number_format(parseFloat(realRate).noExponents(), (decimRate)));
}
//Calcular comisiones
function calcfees(pay) {
    if (pay != undefined) {
        let aproxamo = pay.main.amount.number * pay.rate.number;
        //CALCULO DE COMISIÓN PARA EL SERVICIO PAGO MÓVIL
        var withdfee = (pay.fees.withdrawals.percent > 0) ? parseFloat(((pay.fees.withdrawals.percent / 100) * aproxamo).noExponents()) : (pay.fees.withdrawals.nominal * pay.rate.number); //FEE DEL RETIRO FIAT     
        withdfee = (withdfee).toFixed(pay.wallet.currency.decimals);
        var pagomovilfee = parseFloat((((pay.fees.pagomovil.percent) / 100) * aproxamo).noExponents()); //FEE PAGO MOVIL NEW
        pagomovilfee = (pagomovilfee).toFixed(pay.wallet.currency.decimals);

        return ((parseFloat(withdfee) + parseFloat(pagomovilfee))).noExponents();


    } else return "";
}
//Descargar la plantilla open request
function download(filename, textInput) {
    var element = document.createElement('a');
    element.setAttribute('href', textInput);
    element.setAttribute('download', filename);
    document.body.appendChild(element);
    element.click();
    //document.body.removeChild(element);
}
//Devuelve el icono para el status en barra de lista y mensajes de formulario
function getStatusIcon(id) {
    var icon = "";
    switch (id) {
        case 1:
        case 2:
            icon = '<i class="fas fa-pause-circle" style="color: #f2c542"></i>';
            break;
        case 3:
            icon = '<i class="fas fa-check-circle" style="color: #85BB4F"></i>';
            break;
        case 4:
            icon = '<i class="fas fa-times-circle" style="color: #C04F5D"></i>';
            break;
    }
    return icon;
}
//Copiar al portapapeles el contenido de un elemento o el elemento pasado en sí
function copyToClipboard(id_elemento) {
    var aux = document.createElement("input");
    var value = id_elemento;//Usamos cómo valor el texto que se recibe, si no lo encontramos como un id
    if (document.getElementById(id_elemento) != null && document.getElementById(id_elemento) != undefined)
        value = document.getElementById(id_elemento).innerHTML;
    aux.setAttribute("value", value);
    document.body.appendChild(aux);
    aux.select();
    document.execCommand("copy");
    document.body.removeChild(aux);
}
//Agregar ceros a la izquierda
function pad(n) {
    var s = ('0' + n);
    return s.substr(s.length - 2);
}
//Limitar números
function limitNumberTo(limit, number) {
    let nStrig = number.toString();
    return (nStrig.length > limit) ? nStrig.substring(0, limit) : nStrig;
}



