/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll(); getAge(dateString)
verifyData(files); clearErrors()

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){    
    //Select tipo de compañoa
    var ctype = {};
    ctype.esp = [{"id":1,"dsc":"Privada"},{"id":2,"dsc":"Gubernamental"},
                {"id":3,"dsc":"Mixta"}];
    ctype.eng = [{"id":1,"dsc":"Private"},{"id":2,"dsc":"Governmental"},
                {"id":3,"dsc":"Mixed"}];
    var first = sessionStorage.getItem('lang') == 'esp' ? "Selecciona" : 'Select'
    drawSelectN(document.getElementById("ctype"),'id','dsc',ctype[sessionStorage.getItem('lang')],"",first); 
    //Cargar idiomas en textos de la pagina
    htmlLang(texts);
    formLang(filesLang);

    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }

    
    //Cargar paises de telefono
    drawSelCod(document.getElementById("phoneCode"),'phone_code',countriesJSON,"58",undefined);
    countriesJSON = "";//Vaciar variable luego de cargar
    
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","jurInitReg");
    });
    // Complete later salir sin guardar
    document.getElementById('later-button').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
    // Complete later salir sin guardar
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage("kyc","regC",{});
    });
    
    formatFields2(["phone"],["tel"]);
    getEntry();

}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                hideNotNew(rsp);  

                //Nivel criptos
                var lvlcripto = {};
                lvlcripto.esp = [{"id":1,"dsc":"Básico"},
                                {"id":0,"dsc":"Avanzado"}];
                lvlcripto.eng = [{"id":1,"dsc":"Basic"},
                                {"id":0,"dsc":"Advanced"}]; 
                drawSelectN(document.getElementById("lvlcripto"),'id','dsc',lvlcripto[sessionStorage.getItem('lang')],rsp.entry.view,""); 

                drawEntry(rsp);//Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales

                entry = rsp.entry;
                getCountries();  
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}
//Se carga el listado de paises y se arma el select correspondiente si la respuesta es exitosa
function getCountries(){        
    //Funcion si tiene exito el request  
    var cntryRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                //Pais de residencia
                var first = sessionStorage.getItem('lang') == 'esp' ? "País de registro" : "Registration Country"  
                var sel = "";
                if(entry){                    
                    sel = entry.company.country.id;
                    entry = "";
                }
                drawSelectN(document.getElementById("countryid"),'id','dsc',rsp.records,sel,first);
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    countriesLoad(cntryRsp);
}
//Pintar select opciones de códigos de país
function drawSelCod(select, read, rsp, selected, first = ""){
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no está vacío crea un opcion sin value
    //selected - selecciona una opción especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if(first !== ""){
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for(var i=0; i<rsp.length; i++){
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][read]);
        opt.innerHTML = "+"+rsp[i][read];
        if(selected !== null && selected !== "" && selected !== undefined){
            if(rsp[i][read] == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}
//Save update
function updateSave(id,sid){    
    //Nombre de los campos para validación y valores
    var files = ["ctype","name","doc","phone","countryid"];
    //Nombre de los parametros para enviar difieren de los de arriba en algunos casos
    var parmsList = ["companytype","name","doc","phone","countryid","website","comercialname","venezuelan"];
    if(verifyData(files)){  
        //Agrego los files que no llevan validación        
        files.push("website","comercialname","venezuelan");  
        //Función llamada exitosa
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    var doc = document.getElementById("doc");
                    if(doc){
                        var lang = sessionStorage.getItem('lang');
                        var err = doc.nextElementSibling;
                        if(err.classList.contains("errorReg")){
                            err.innerHTML = getLangById("erruserexist")[lang];
                            err.style.display = "block";
                        }
                    } 
                    
                    break;
                case 401:
                    expiredSession();
                    break;
                case 415:
                    
                    errFile(document.getElementById("file"+JSON.parse(rsp).invalid),JSON.parse(rsp).msg);
                break;
                case 500:
                    // Error
                    break;
                default:
                
                    break;
            }
        } 
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(files[i] == "phone"){
                parms.append(parmsList[i],(document.getElementById("phoneCode").value+" "+document.getElementById(files[i]).value));
            }else if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                parms.append(parmsList[i],val);
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        
        parms.append("view",document.getElementById("lvlcripto").value);
        //Paso Seguiente
        parms.append("step",1);
        updateCompany(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    }
}


