/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll(); getAge(dateString)
verifyData(files); clearErrors()

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){    
    //Inicializas el doble idioma
    htmlLang(texts);
    formLang(filesLang);
    
    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }

    //Se cargan los uploads correspondientes
    getUploads();

    //Ciclo que se repite hasta que se completan todas las cargas dando prioridad a las que son previas al entry
    wait = setInterval(function(){
        if(upLoad){               
            clearInterval(wait);        
            getEntry();
        }
    },1000);

    //Asignar evento "mostrar statment"
    document.getElementById("viewStatment").addEventListener("click",function(){
        viewStatment();
    });
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","jurInitEnd");
    });
    // Complete later salir sin guardar
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage("kyc","jurInitEconom",{});
    });
    // Complete later salir sin guardar
    document.getElementById('later-button').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                drawEntry(rsp);//Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                entry = rsp.entry;  
                //Se marca cómo seleccionada la declaración si existe
                /*if(entry.declaration!==null&&entry.declaration!==""){
                    if(drawStatment(entry)){
                        document.getElementById("declaration").checked = true;
                        document.getElementById("declarationTxt").setAttribute("loaded",true);
                    }else{
                        document.getElementById("declaration").checked = false;
                        document.getElementById("declarationTxt").setAttribute("loaded",false);
                    };
                } */ 
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}
//Se carga el listado de uploads y se pintan donde corresponda
function getUploads(){    
    //Cargar listado de uploads    
    var parms = {
        "type":2,
        "sessionid": sessionStorage.getItem('sessionid')
    }
    //Funcion si tiene exito el request
    var uplsRsp = function(status, rsp){        
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                upLoad = true;
                uploadsDraw(rsp.records,1);
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
    uploadsLoad(parms,uplsRsp);
}
//Mostrar declaración
function viewStatment(){
    //Validar que la declaración se armó completa, osea los datos se cargaron antes
    var stat = document.getElementsByClassName("statment")[0];
    var nwHeight = stat.offsetHeight;
    var cntStat = document.getElementsByClassName("txtLngCnt")[0];
    if(cntStat.offsetHeight == 0){
        if(document.getElementById("declarationTxt").getAttribute("loaded") == 'false'){
            if(!drawStatment(entry)){
                var lang = sessionStorage.getItem('lang');
                var errm = getLangById("err1declaration")[lang];
                var file = document.getElementById("declaration");            
                var err = file.parentElement.parentElement.parentElement.parentElement.nextElementSibling;
                if(err){                    
                    if(err.classList.contains("errorReg")){
                        err.innerHTML = errm;
                        err.style.display = "block";
                    }
                }
                setTimeout(function(){
                    clearErrors(); // Se blanquean todos los errores
                },5000);
                return;
            }
        }
        stat = document.getElementsByClassName("statment")[0];
        nwHeight = stat.offsetHeight;
        cntStat.classList.add("txtLngAct");
        cntStat.style.height = nwHeight+"px";    
        document.getElementById("viewStatment").innerText = getLangById("hideStatment")[sessionStorage.getItem('lang')];
    }else{
        document.getElementById("viewStatment").innerText = getLangById("viewStatment")[sessionStorage.getItem('lang')];
        cntStat.style.height = "";
        cntStat.classList.remove("txtLngAct");
    }
}
//Save update
function updateSave(id,sid){    
    //Nombre de los campos para validación y valores
    var files = ["declaration"];
    var parmsList = ["declaration"];
    //Se agregan los uploads a validar
    var uplsCnt = document.getElementsByClassName("upldsCnt");
    var recaudos = uplsCnt[0].getElementsByTagName("input");
    for(var i=0; i<recaudos.length; i++){
        files.push(recaudos[i].getAttribute("id"));
    }  
    if(verifyData(files)){    
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    break;
                case 401:
                    expiredSession();
                    break;
                case 415:
                    
                    errFile(document.getElementById("file"+JSON.parse(rsp).invalid),JSON.parse(rsp).msg);
                break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                if(files[i]=='declaration' && document.getElementById(files[i]).getAttribute("validated")==0){
                    parms.append(parmsList[i],val);
                }else if(files[i]!=='declaration'){
                    parms.append(parmsList[i],val);
                }
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Uploads
        var uplsCnt = document.getElementsByClassName("upldsCnt");
        var recaudos = uplsCnt[0].getElementsByTagName("input");
        var docids = idsloaded;
        for(var i=0; i<recaudos.length; i++){
            if(recaudos[i].getAttribute("loaded") == 1){
                if(docids.indexOf(recaudos[i].getAttribute("label"))<0)
                    docids  += recaudos[i].getAttribute("label")+"-"; 
            }
            if(recaudos[i].value !== ""){    
                parms.append(recaudos[i].getAttribute("label"), recaudos[i].files[0]);
            }
        }
        docids = docids.slice(0,-1); //Se elimina el ultimo "-" 
        parms.append("uploadids",docids);
        //Paso Seguiente
        parms.append("step",5);
        updateCompany(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    }
}
//Se arma la declaración jurada o del entry o con los valores si se altera alguno
function drawStatment(entry){
    var repname,repdoc,companyname,rif;
    
    if(entry){
        //Necesarios datos del representante legal, recorremos los socios hasta encontrarlo
        for(var i=0;i<entry.company.partners.length;i++){
            if(entry.company.partners[i].legalrep.value == 1){     
                if(entry.company.partners[i].name.value){        
                    repname = entry.company.partners[i].name.value;
                }
                if(entry.company.partners[i].document.value){        
                    repdoc = entry.company.partners[i].document.value;
                } 
            }
        }       
        if(entry.company.name.value){
            companyname = entry.company.name.value;            
        }    
        if(entry.company.document.dsc.value){
            rif = entry.company.document.dsc.value;
        }
    }
    if(repname == "" || repname == null || repdoc == "" || repdoc == null ||
        companyname == "" || companyname == null || rif == "" || rif == null){
            return false;
    }
    var lang = sessionStorage.getItem('lang');
    if(lang == 'esp'){
        var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        var html = "";
        html += 'Yo '+repname+' ';
        html += ', titular de la Cédula de Identidad Nro.'+repdoc; 
        html += '. En mi condición de Representante Legal de la empresa ' + companyname + 
                ' identificada con el número de registro de información fiscal RIF '+ rif + '. <br/><br/>';
        html += `Declaro bajo fe de juramento que todos los datos y documentos suministrados son ciertos y fehacientes. 
                Igualmente autorizo suficientemente a la empresa `+companynm+`, a efectos de verificar la veracidad de lo aquí declarado, en cumplimiento 
                con la providencia 044-2021 sobre normas relativas a la administración y fiscalización de los riesgos relacionados con
                la Legitimación de Capitales, el Financiamiento del Terrorismo y el Financiamiento de la Proliferación de Armas de
                Destrucción Masiva, aplicables a los Proveedores de Servicios de Activos Virtuales y a las personas y entidades que
                proporcionen productos y servicios a través de actividades que involucren Activos Virtuales, en el sistema integral de
                criptoactivos, emanada por la Superintendencia Nacional de Criptoactivos y Actividades Conexas (SUNACRIP) y
                publicado en la Gaceta Oficial número 42.110, en fecha 21 de abril del año 2021.<br/><br/>
                De esta misma forma declaro bajo fe de juramento, que los capitales, bienes, fondos, haberes, beneficios o
                criptoactivos, que sean depositados en la plataforma, durante todo el período que permanezca vigente la relación
                con la empresa `+companynm+`, son provenientes de actividades legítimas. Por lo tanto, declaro que
                tienen una procedencia lícita, la cual puede ser corroborada por los organismos competentes y no tienen relación
                alguna con dinero, capitales, bienes, fondos, haberes, beneficios o criptoactivos que se consideren producto de
                actividades ilícitas o hechos típicos antijurídicos contemplados en la Ley Orgánica contra la Delincuencia Organizada
                y Financiamiento al Terrorismo publicada en Gaceta Oficial No 39.912 el 30 de abril de 2012, así como en lo
                establecido en la Ley Orgánica de Drogas publicada en Gaceta Oficial No 39.546 el 05 de noviembre de 2010.`;
        html += '<br/><br/>'+ getDateD(entry,meses);
        document.getElementById("declarationTxt").innerHTML = html;        
    }else{
        var meses = new Array ("January","February","March","April","May","June","July","August","September","October","November","December");
        var html = "";
        html += 'I, ' +repname+' ';
        html += 'holder of the Identity Card No. '+ repdoc;
        html += '. In my capacity as Legal Representative of the ' + companyname + " company " +
                ' identified with the tax information registration number RIF '+ rif + '. <br/><br/>';
        html += `I declare under Oath: that all the data and documents provided are true and reliable, 
                I also sufficiently authorize the company `+companynm+`, in order to verify the veracity of what is stated here,' 
                in compliance with Order 044-2021 on regulations relating to the administration and control of risks related to Money Laundering, 
                the Financing of Terrorism and the Financing of the Proliferation of Weapons of Mass Destruction, applicable to Asset Service Providers 
                Virtual Assets and to people and entities that provide products and services through activities that involve Virtual Assets, in the comprehensive 
                crypto assets system, issued by the National Superintendency of Crypto Assets and Related Activities (SUNACRIP) and published in Official Gazette number 
                42,110, in dated April 21, 2021. <br/><br/>
                In this same way, I declare under oath, that the capital, goods, funds, assets, benefits or crypto assets, 
                that are deposited in the platform, during the entire period that the relationship with the Financial Advisory 
                company remains in force. IO, C.A., are from legitimate activities. Therefore, I declare that they have a legal origin, which can be corroborated 
                by the competent bodies and they have no relationship whatsoever with money, capital, goods, funds, assets, benefits or crypto assets that are 
                considered the product of illegal activities or typical unlawful events. contemplated in the Organic Law against Organized Crime and Terrorism 
                Financing published in Official Gazette No. 39,912 on April 30, 2012, as well as in the provisions of the Organic Law on Drugs published in Official 
                Gazette No. 39,546 on November 5, 2010. `
        html += '<br/><br/>'+ getDateD(entry,meses);
        document.getElementById("declarationTxt").innerHTML = html;   
    }
    return true;         
}
//Obtener formato de fecha para la declaración jurada
function getDateD(entry,meses){
    var lang = localStorage.getItem("lang");
    var msg = "";
    if(entry!=null){
        if(entry.declaration!==null)var dF = new Date(entry.declaration);
        else var dF= new Date();
        msg =  'A los '+dF.getDate()+' días del mes de '+meses[dF.getMonth()]+' de '+dF.getFullYear()+'.';
        if(lang=='eng') msg = 'On the '+dF.getDate()+'th day of the month of '+meses[dF.getMonth()]+' '+dF.getFullYear()+'.';        
    }else{
        var f=new Date();
        msg = 'A los '+f.getDate()+' días del mes de '+meses[f.getMonth()]+' de '+f.getFullYear()+'.';
        if(lang=='eng') msg = 'On the '+f.getDate()+'th day of the month of '+meses[f.getMonth()]+' '+f.getFullYear()+'.';
    }
    return msg;
}





