/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll(); getAge(dateString)
verifyData(files); clearErrors()

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){    
    
    //Cargar idiomas en textos de la pagina
    htmlLang(texts);
    formLang(filesLang);

    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }
    
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","jurInitPrtnrs");
    });
    // Complete later salir sin guardar
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage("kyc","jurInitBasic",{});
    });
    // Complete later salir sin guardar
    document.getElementById('later-button').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
    //Actualizar ciudades al modificar la region (estado)
    document.getElementById("docregionid").addEventListener("change",function(){
        getCities(this.value);   
    });
    //Actualizar ciudades al modificar la region (estado)
    document.getElementById("doccountryid").addEventListener("change",function(){
        getRegions(this.value);   
    });
    
    getEntry();

}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                drawEntry(rsp);//Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                entry = rsp.entry;                
                getCountries();   
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}

//Se carga el listado de paises y se arma el select correspondiente si la respuesta es exitosa
function getCountries(){        
    //Funcion si tiene exito el request  
    var cntryRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "País de registro" : 'Country of registration'
                //Pais de residencia
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.company.document.country.id){
                        sel = entry.company.document.country.id;
                    }
                }
                drawSelectN(document.getElementById("doccountryid"),'id','dsc',rsp.records,sel,first);
                //Se cargan las regiones
                getRegions(sel);     
            break;
            case 204:
            break;
            case 401:
                expiredSession();
            break;
            default:
            break;
        }
    } 
    countriesLoad(cntryRsp);
}
//Se carga el listado de estados y se arma el select correspondiente si la respuesta es exitosa
function getRegions(val=""){ 
    //Funcion si tiene exito el request  
    var regionRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "Estado de registro" : 'State of registration'
                //estado de registro
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.company.document.region.id){
                        sel = entry.company.document.region.id;
                    }
                }
                drawSelectN(document.getElementById("docregionid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa del estado cargamos la ciudades  
                getCities(sel);              
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    if(entry){
        if(entry.company.document.country.id!=null && entry.company.document.country.id!="")
            regionsLoad(entry.company.document.country.id,regionRsp);
        else{        
            if(val!=null && val!="")
                regionsLoad(val,regionRsp);
            else{
                document.getElementById("docregionid").value = "";
            }    
        }
    }else{
        if(val!=null && val!="")
            regionsLoad(val,regionRsp);
        else{
            document.getElementById("docregionid").value = "";
        } 
    }
}
//Se carga el listado de ciudades y se arma el select correspondiente si la respuesta es exitosa
function getCities(val=""){ 
    //Funcion si tiene exito el request  
    var citiesRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:                
                //Ciudad de registro
                var first = sessionStorage.getItem('lang') == 'esp' ? "Ciudad de registro" : 'City of registration'
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.company.document.city.id){
                        sel = entry.company.document.city.id;
                        entry = undefined;
                    }
                }
                drawSelectN(document.getElementById("doccityid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa de las ciudades blanqueamos la variable global entry   
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    if(entry){
        if(entry.company.document.region.id!=null && entry.company.document.region.id!="")
            citiesLoad(entry.company.document.region.id,citiesRsp);
        else{        
            if(val!=null && val!="")
                citiesLoad(val,citiesRsp);
            else{
                document.getElementById("doccityid").value = "";
            }    
        }
    }else{
        if(val!=null && val!="")
            citiesLoad(val,citiesRsp);
        else{
            document.getElementById("doccityid").value = "";
        } 
    }
}

//Save update
function updateSave(id,sid){    
    //Nombre de los campos para validación y valores
    var files = ["doccountryid","docregionid","doccityid","postalcode","creationdate"];
    //Nombre de los parametros para enviar difieren de los de arriba en algunos casos
    var parmsList = ["doccountryid","docregionid","doccityid","postalcode","creationdate"];
    if(verifyData(files)){  
        //Función llamada exitosa
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    break;
                case 401:
                    expiredSession();
                    break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                parms.append(parmsList[i],val);
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Paso Seguiente
        parms.append("step",2);
        updateCompany(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    }
}

