/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll();

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){    
    //Cargar idiomas en textos de la pagina
    htmlLang(texts);
    formLang(filesLang);
    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }

    //Se cargan los uploads correspondientes
    getUploads();

    //Ciclo que se repite hasta que se completan todas las cargas dando prioridad a las que son previas al entry
    wait = setInterval(function(){
        if(upLoad){               
            clearInterval(wait);        
            getEntry();
        }
    },1000);

    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("save-button").addEventListener("click",function(){
        var id,sid;
        if(this.getAttribute("view") == 0){
            id = "dashboard";
            sid = "home";
        }else{
            id = "step";
            sid = "main";
        }
        updateSave(id,sid);
    });
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","jurAdvancedLvl");
    });
    //Guardar y Salir al dashboard
    document.getElementById("later-button").addEventListener("click",function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
    // Ir a pagina anterior
    document.getElementById('previous-button').addEventListener("click", function(){ 
        gotoPage('kyc','jurInitImgs',"");
    });
     //Actualizar ciudades al modificar la region (estado)
     document.getElementById("regionid").addEventListener("change",function(){
        getCities(this.value);   
    });
    //Actualizar regiones al modificar el país (estado)
    document.getElementById("countryid").addEventListener("change",function(){
        getRegions(this.value);   
    });
}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                drawEntry(rsp);
                //Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                entry = rsp.entry;
                getCountries();  
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}

//Pintar select opciones de códigos de país
function drawSelCod(select, read, rsp, selected, first = ""){
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no está vacío crea un opcion sin value
    //selected - selecciona una opción especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if(first !== ""){
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for(var i=0; i<rsp.length; i++){
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][read]);
        opt.innerHTML = "+"+rsp[i][read];
        if(selected !== null && selected !== "" && selected !== undefined){
            if(rsp[i].id == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}
//Se carga el listado de uploads y se pintan donde corresponda
function getUploads(){    
    //Cargar listado de uploads    
    var parms = {
        "type":2,
        "sessionid": sessionStorage.getItem('sessionid')
    }
    //Funcion si tiene exito el request
    var uplsRsp = function(status, rsp){        
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                uploadsDraw(rsp.records,2); //Nivel intermedio 3
                upLoad = true;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
    uploadsLoad(parms,uplsRsp);
}
//Se carga el listado de paises y se arma el select correspondiente si la respuesta es exitosa
function getCountries(){        
    //Funcion si tiene exito el request  
    var cntryRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                //Pais de residencia
                var first = sessionStorage.getItem('lang') == 'esp' ? "País de registro" : "Registration Country"  
                var sel = "";
                if(entry){                    
                    sel = entry.company.country.id;
                }
                drawSelectN(document.getElementById("countryid"),'id','dsc',rsp.records,sel,first);
                //Se cargan las regiones
                getRegions();     
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    countriesLoad(cntryRsp);
}
//Se carga el listado de estados y se arma el select correspondiente si la respuesta es exitosa
function getRegions(val = ""){ 
    //Funcion si tiene exito el request  
    var regionRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                //Pais de residencia
                var first = sessionStorage.getItem('lang') == 'esp' ? "Estado de registro" : "Registration State"  
                var sel = "";
                if(entry){                    
                    sel = entry.company.region.id;
                }
                drawSelectN(document.getElementById("regionid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa del estado cargamos la ciudades  
                getCities();              
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    if(entry){
        if(entry.company.country.id!=null && entry.company.country.id!="")
        regionsLoad(entry.company.country.id,regionRsp);
        else{        
            if(val!=null && val!="")
                regionsLoad(val,regionRsp);
            else{
                document.getElementById("regionid").value = "";
                document.getElementById("regionid").dispatchEvent(new Event("change"));
            }
        }
    }else{
        if(val!=null && val!="")
            regionsLoad(val,regionRsp);
        else{
            document.getElementById("regionid").value = "";
            document.getElementById("regionid").dispatchEvent(new Event("change"));
        }
         
    }  
    
}
//Se carga el listado de ciudades y se arma el select correspondiente si la respuesta es exitosa
function getCities(val = ""){ 
    //Funcion si tiene exito el request  
    var citiesRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                //Pais de residencia
                var first = sessionStorage.getItem('lang') == 'esp' ? "Ciudad de registro" : "Registration city"  
                var sel = "";
                if(entry){                    
                    sel = entry.company.city.id;
                }
                drawSelectN(document.getElementById("cityid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa de las ciudades blanqueamos la variable global entry         
                entry = undefined;    
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    if(entry){
        if(entry.company.region.id!=null && entry.company.region.id!="")
            citiesLoad(entry.company.region.id,citiesRsp);
        else{        
            if(val!=null && val!="")
                citiesLoad(val,citiesRsp);
            else
                document.getElementById("cityid").value = "";
        }
    }else{
        if(val!=null && val!="")
                citiesLoad(val,citiesRsp);
        else
            document.getElementById("cityid").value = "";
         
    }  
}
//Save update
function updateSave(id,sid){  
    //Files  
    var files = ["regionid","cityid","street","domicile","branchoffices"];    
    //Nombre de los parametros
    var parmsList = ["stateid","cityid","street","domicile","branchoffices"];
    //Se agregan los uploads a validar
    var uplsCnt = document.getElementsByClassName("upldsCnt");
    var recaudos = uplsCnt[0].getElementsByTagName("input");
    for(var i=0; i<recaudos.length; i++){
        files.push(recaudos[i].getAttribute("id"));
    } 
    if(verifyData(files)){    
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    break;
                case 401:
                    expiredSession();
                    break;
                case 415:
                    
                    errFile(document.getElementById("file"+JSON.parse(rsp).invalid),JSON.parse(rsp).msg);
                break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                parms.append(parmsList[i],val);
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Uploads
        var uplsCnt = document.getElementsByClassName("upldsCnt");
        var recaudos = uplsCnt[0].getElementsByTagName("input");
        var docids = idsloaded;
        for(var i=0; i<recaudos.length; i++){
            if(recaudos[i].getAttribute("loaded") == 1){
                docids  += recaudos[i].getAttribute("label")+"-"; 
            }
            if(recaudos[i].value !== ""){    
                parms.append(recaudos[i].getAttribute("label"), recaudos[i].files[0]);
            }
        }
        docids = docids.slice(0,-1); // Controla si estoy editando, guardando o eliminando algun archivo
        parms.append("uploadids",docids);
        //Paso actual
        parms.append("step",6);
        updateCompany(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    } 
}
