function start(){
    
    // Entry
    //getEntry(sessionStorage.getItem('sessionid'))
    
    // Go to Register Person
    document.getElementById('person').addEventListener("click", function(){
        var req = {
            "sessionid" : sessionStorage.getItem('sessionid'),
            "step" : 0,
        }
        updatePerson(req);
    });
    
    // Go to Register Company
    document.getElementById('company').addEventListener("click", function(){
        var req = {
            "sessionid" : sessionStorage.getItem('sessionid'),
            "step" : 0,
        }
        updateCompany(req);
    });
    
    setLang();
    
    //Mostrar HTML cargado
    //esconderHTML(false);
    document.getElementById("cellTypeUsr").style.visibility="";
    esconderHTML(false);
}

function gotoStep(rsp){
    var lastpag = document.referrer;
    if(lastpag !== ""){
        //Pagina anterior detetcto si viene de un boton anterior
        var lastid="";
        var sid = lastpag.indexOf("&sid=", 0);
        var sess = lastpag.indexOf("&ses", 0);
        if(sid>0 && sess>0){
            lastid = lastpag.substr((sid+5), ((sess)-(sid+5)));
            
            document.getElementById("cellTypeUsr").style.visibility="";//Muestro el form
            esconderHTML(false);
    }else{
            //Valido que tegna un tipo seleccionado
            if(rsp.entry.type.id !== 0 ){
                //Redirecciono a paginas de persona natural dependiendo del paso
                if(rsp.entry.type.id == 1){
                    switch(rsp.entry.person.step){
                        case 0:
                        case 1:
                            gotoPage('kyc','natInitialLvl',"");                            
                        break;
                        case 2:
                            gotoPage('kyc','natBasicLvl',"");
                            break;
                        case 3:
                            gotoPage('kyc','natMiddleLvl',"");
                            break;
                        case 4:
                            gotoPage('kyc','natAdvancedLvl',"");
                            break;
                        case 5:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                        break;
                    }
                }else{
                    switch(rsp.entry.company.step){
                        case 0:
                        case 1:
                            gotoPage('kyc','jurInitBasic',"");
                            break;
                        case 2:
                            gotoPage('kyc','jurInitReg',"");
                            break;
                        case 3:
                            gotoPage('kyc','jurInitPrtnrs',"");
                            break;
                        case 4:
                            gotoPage('kyc','jurInitEconom',"");
                            break;
                        case 5:
                            gotoPage('kyc','jurInitBasic',"");
                            break;
                        case 6:
                            gotoPage('kyc','jurInitImgs',"");
                            break;
                        case 7:
                            gotoPage('kyc','jurMiddleLvl',"");
                            break;
                        case 7:
                            gotoPage('kyc','jurAdvancedLvl',"");
                            break;
                        case 8:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                            break;
                }
            }
            }else{
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
            }
        }
    }
}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoStep(JSON.parse(rsp));
                break;
            case 304:
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
                break;
            default:
                break;
        }
    }    
}


// Update step with updateperson
function updatePerson(req){
    callWS("POST", "users/updateperson", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoPage('kyc','natInitialLvl',"");
                break;
            default:
                break;
        }
    }  
}

// Update step with updatecompany
function updateCompany(req){
    callWS("POST", "users/updatecompany", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoPage('kyc','jurInitBasic',"");
                break;
            default:
                break;
        }
    }  
}

function setLang(){
    
    addFooter()
    
    lang = sessionStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('title','title');
    setWordLanginnerHTML('information','information');
    setWordLanginnerHTML('person','natural');
    setWordLanginnerHTML('company','legal');
    setWordLanginnerHTML('ts','ts');

}

function changeLang(){
    
    lang = sessionStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('title','title');
    setWordLanginnerHTML('information','information');
    setWordLanginnerHTML('person','natural');
    setWordLanginnerHTML('company','legal');
    setWordLanginnerHTML('ts','ts');
    
}

