function start() {
    // Go back
    document.getElementById('previous-button').addEventListener("click", function () {
        gotoPage('step', 'depositFunds', "")
    });

    // Go step 4
    document.getElementById('next-button').addEventListener("click", function () {
        gotoPage('step', 'depositFundsFinal', { 'cid': getParameterByName('cid'), 'idr': getParameterByName('idr'), 'd': getParameterByName('d') })
    });



    // Go back R
    document.getElementById('previous-buttonR').addEventListener("click", function () {
        gotoPage('step', 'depositFunds', "")
    });

    // Go step 4 R
    document.getElementById('next-buttonR').addEventListener("click", function () {
        gotoPage('step', 'depositFundsFinal', { 'cid': getParameterByName('cid'), 'idr': getParameterByName('idr'), 'd': getParameterByName('d') })
    });

    // Step
    document.getElementById('floatButton').addEventListener("click", function () {
        var popup = document.getElementById("floatButton").children[0].children[0];
        if (popup.classList.contains('show')) {
            gotoPage('dashboard', 'home', "")
        } else {
            popup.classList.toggle("show");
        }
    })

    document.getElementById('floatClose').addEventListener("click", function (event) {
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })

    // Session Update


    // copyBtc
    document.getElementById('copyIconBtc').addEventListener("click", function () {
        document.getElementById('copyDepBTC').select();
        document.execCommand('copy');
    });

    init()

    //Mostrar HTML cargado
    esconderHTML(false);




}



function sessionUpdate(req) {
    callWS('GET', 'session/update', req, response);
    function response(status, rsp) {
        switch (status) {
            case 200:
                document.getElementsByClassName('expired')[0].style.display = "none";
                init()
                break;
            case 400:
                break;
            case 401:
                gotoPage('login', 'main', '');
                break;
            case 402:
                break;
            case 403:
                break;
            case 500:
                break;
            default:
                break;
        }
    }
}

function init() {
    setLang()
}

function getEntry(sessionid) {
    callWS("GET", "users/entry", { 'sessionid': sessionid }, response);

    function response(status, rsp) {
        switch (status) {
            case 200:
                if (JSON.parse(rsp).notifications > 0) {
                    document.getElementById('messageNotification').style.display = "table"
                    document.getElementById('messageNotification').children[0].innerHTML = JSON.parse(rsp).notifications
                } else {
                    document.getElementById('messageNotification').style.display = "none"
                    document.getElementById('messageNotification').children[0].innerHTML = ""
                }
                entrydata = (JSON.parse(rsp).entry)
                putName(entrydata);
                putInformationWalletBTC(getParameterByName('idr'))
                break;
            case 204:
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }
}

function putName(entrydata) {
    var name;
    if (entrydata.company) {
        if (entrydata.company.name.value == "" || entrydata.company.name.value == null) {
            name = entrydata.usr
        } else {
            name = entrydata.company.name.value
        }
    }
    else if (entrydata.person) {
        if (entrydata.person.firstname.value == "" || entrydata.person.firstname.value == null) {
            name = entrydata.usr
        } else {
            name = entrydata.person.firstname.value + ' ' + entrydata.person.firstlastname.value
        }
    }
    document.getElementById('headname').innerHTML = name
    document.getElementById('name2').innerHTML = name
}

function logout() {
    var sessionid = sessionStorage.getItem('sessionid')
    var req = {
        'sessionid': sessionid,
    }
    callWS('GET', 'login/logout', req, response);

    function response(status, rsp) {


        switch (status) {
            case 200:
                sessionStorage.removeItem('sessionid')
                gotoPage('login', 'main', '')
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }
}

function putInformationWalletBTC(id) {
    document.getElementById('copyDepBTC').value = ''
    accountsEntry(id)
}

// Service accounts/entry
function accountsEntry(id) {

    var req = {
        'sessionid': sessionStorage.getItem('sessionid'),
        'id': id
    }

    callWS('GET', 'accounts/entry', req, response);

    function response(status, rsp) {
        switch (status) {
            case 200:
                document.getElementsByClassName('name-currency')[0].innerHTML = JSON.parse(rsp).entry.currency.symbol
                document.getElementById('copyInfAFX').innerHTML = JSON.parse(rsp).entry.wallet.dsc;
                document.getElementById('addressBTCInfDate').innerHTML = JSON.parse(rsp).entry.wallet.expiry.formatted;
                document.getElementById("qrcode").innerHTML = ''
                var qrcode = new QRCode(document.getElementById("qrcode"), {
                    text: document.getElementById('copyInfAFX').innerHTML,
                    width: 110,
                    height: 110,
                    colorDark: "#000000",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                });
                document.getElementById('copyDepBTC').value = document.getElementById('copyInfAFX').innerHTML
                req = {
                    'sessionid': sessionStorage.getItem('sessionid'),
                    'currencyid': getParameterByName('cid'),
                }
                if (JSON.parse(rsp).entry.currency.interface == 6) {
                    document.getElementById('USDTInfo1').innerHTML = getLangById('usdtInfo1')[lang];
                    document.getElementById('USDTInfo2').innerHTML = getLangById('usdtInfo2')[lang]
                }
                feesEntry(req);
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }
}

// fees/entry
var decimCoin = 0;
function feesEntry(req) {

    callWS('GET', 'fees/entry', req, response);
    function response(status, rsp) {
        switch (status) {
            case 200:
                if (JSON.parse(rsp).entry.deposits.nmalfee) {
                    document.getElementById("depositCriptoFee").innerHTML = number_format(JSON.parse(rsp).entry.deposits.nmalfee.number, getParameterByName('d'));
                }
                else if (JSON.parse(rsp).entry.deposits.pctfee) {
                    document.getElementById('depositCriptoFee').innerHTML = (JSON.parse(rsp).entry.deposits.pctfee.formatted) + '%';
                } else {
                    document.getElementById('depositCriptoFee').innerHTML = 'N/A';
                }
                break;
            case 400:
                document.getElementsByClassName('failure')[0].style.display = "table"
                break;
            case 401:
                expiredSession();
                break;
            default:
                document.getElementsByClassName('failure')[0].style.display = "table"
                break;
        }
    }
}

function setLang() {

    addFooter()

    lang = sessionStorage.getItem('lang');

    /* inner HTML */
    setWordLanginnerHTML('home', 'home');
    setWordLanginnerHTML('balance', 'balance');
    setWordLanginnerHTML('preferences', 'preferences');
    setWordLanginnerHTML('homeR', 'home');
    setWordLanginnerHTML('balanceR', 'balance');
    setWordLanginnerHTML('preferencesR', 'preferences');
    setWordLanginnerHTML('langIcon', 'langIcon');

    setWordLanginnerHTML('titlePage', 'titlePage');
    setWordLanginnerHTML('step1', 'step1');
    setWordLanginnerHTML('step2', 'step2');
    setWordLanginnerHTML('step3', 'step3');
    setWordLanginnerHTML('step4', 'step4');
    setWordLanginnerHTML('step5', 'step5');

    setWordLanginnerHTML('t1', 't1');
    setWordLanginnerHTML('t2', 't2');


    setWordLanginnerHTML('expirationLabel', 'expiration');
    setWordLanginnerHTML('feesLabel', 'FEES');
    setWordLanginnerHTML('t3', 't3');



    setWordLanginnerHTML('previous-button', 'RETURN');
    setWordLanginnerHTML('next-button', 'continue');
    setWordLanginnerHTML('previous-buttonR', 'RETURN');
    setWordLanginnerHTML('next-buttonR', 'continue');


    setWordLanginnerHTML('buttonAdv', 'ADVANCEDMODE');
    setWordLanginnerHTML('question', 'question');
    setWordLanginnerHTML('expired1', 'expired1');
    setWordLanginnerHTML('expired2', 'expired2');
    setWordLanginnerHTML('expSessionButton', 'continue');
    setWordLanginnerHTML('ts', 'ts');


    document.getElementById('floatClose').addEventListener("click", function (event) {
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })

    getEntry(sessionStorage.getItem('sessionid'));

}