<?php
// cms/api/alerts/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'alertid',/* 'date',*/ 'comment', 'status');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $alertid = $_GET['alertid'];
    $date = $_GET['date'];
    $dsc = $_GET['comment'];
    $status = $_GET['status'];
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 88))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos el tipo de status
    if(!validateStatus($status)){
        badEnd(500, array("msg"=>"Status debe ser 0, 1, -1 o -2"));
    }
    
    // Validamos que exista la alerta
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM alerts ".
    "       WHERE id = ".$alertid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    if($row['qty'] == 0){
        badEnd(404, array("msg"=>"Alerta no encontrada"));
    }
    
    // Insertamos un nuevo registro para la alerta
    $sql = "INSERT INTO alertsupdates(".
    "       alertid, ".
    "       status, ".
    "       comment, ".
    "       userid, ".
    "       createddate, ".
    "       date ".
    "       ) VALUES(".
    "       ".$alertid.", ".
    "       ".$status.", ".
    "       '".$dsc."', ".
    "       ".$userid.", ".
    "       NOW(), ".
    /*"       '".date('Y-m-d H:i:s', strtotime($date))."' ".*/
    "       NOW()".
    "       )";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    // Retornamos el id que fue insertado
    $out->id = (int)$db->insert_id;
    
    $sql = "SELECT users.usr AS usr ".
    "       FROM alerts, users ".
    "       WHERE alerts.id = ".$alertid.
    "       AND alerts.userid = users.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    $alertuser = $row['usr'];
    
    // Obtenemos los datos del usuario
    $sql = "SELECT usr FROM cmsusers WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    //auditoria
    setAudit($db, "ALERTAS", $sessionid, "CMS", "El usuario ".$row['usr']." Modificó la alerta #".$alertid." del usuario ".$alertuser);
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function validateStatus($status){
        if($status == 0 || $status == 1 || $status == -1 || $status == -2){
            return true;
        }
        return false;
    }
?>