<?php
// cms/api/appusers/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","level","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $level = $_GET["level"];
    $status = $_GET["status"];
    $tags = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid); 
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 28))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamos para validar que exista el usuario
    $sql = "SELECT id, usr, level FROM users WHERE id = ".mysqli_real_escape_string($db, $id);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    // Guardamos el nivel
    $lastlevel = $row['level'];
    
    // Obtenemos el nivel que tenia el usuario
    $sql = "SELECT * FROM levels WHERE id = ".$lastlevel;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $lastlevelRow = $rs->fetch_assoc();
    
    //Si los tags son enviados, armamos el string
    if(isset($_GET["tags"]) && $_GET["tags"] != ""){
        $tagsarr = explode("-", $_GET["tags"]);
        $count = 0;
        //Por cada tag vamos creando la cadena, al primero no se le coloca el guion(-)
        foreach($tagsarr as $tag){
            if($count == 0){
                $tags .= "".$tag;
            }else{
                $tags .= "-".$tag;
            }
            $count++;
        }
    }
        
    //Actualizamos al usuario
    $sql = "UPDATE users SET ".
    "       level = ".mysqli_real_escape_string($db, $level).", ".
    "       status = ".mysqli_real_escape_string($db, $status).", ".
    "       fails = 0, ".
    "       ".(mysqli_real_escape_string($db, $status) == 1 ? " blockedthru = NULL " : " blockedthru = NOW() ").", ".
    "       risklevel = ".(mysqli_real_escape_string($db, $_GET["risklevel"]) == "" ? "NULL" : mysqli_real_escape_string($db, $_GET["risklevel"])).", ".
    "       tag = ".($tags != "" ? "'".$tags."'" : "NULL" )." ".
    "       WHERE id = ".$id;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
            
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT users.usr AS email, IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name, ".
    "       IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone, " .
    "       users.level AS level, users.lang AS lang ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE id = ".mysqli_real_escape_string($db, $id);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userdata = $rs->fetch_assoc();
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se modificó el usuario ".$userdata['name']);
    
    // Obtenemos el nivel como tal que se actualizo
    $sql = "SELECT * FROM levels WHERE id = ".$level;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $levelRow = $rs->fetch_assoc();
    
    // Validamos si se cambio el nivel
    if($lastlevelRow['orden'] < $levelRow['orden'] && $levelRow['orden'] > 0){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
        
        // Consultamos los datos del mensaje
        $sql = "SELECT * FROM cmsmessages WHERE id = 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $data = $rs->fetch_assoc();
        
        // Validamos que el usuario tenga las notificaciones activas
        $sql = "SELECT * FROM usermessages ".
        "       WHERE categoryid = ".$data['category'].
        "       AND usrid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $userPref = $rs->fetch_assoc();
        
        if($userPref['email'] == null || $userPref['email'] == 1){
            $subject = $userdata['lang'] == 'esp' ? $data['name_esp'] : $data['name_eng'];
            $body = "<div class='emailBox'>".
            "           <img class='afxLogo' src='".$homeurlCMS."./settings/img/logo-email.png'/>".
            "           <div class='mainBox'>".
            "               <h1 class='titleEmail'>".
            "                   ".($userdata['lang'] == "esp" ? "Hola" : "Hello")." ".$userdata['name'].
            "               </h1>".
            "               <p class='msgEmail'>".
            "                   ".($userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']).
            "               </p>".
            "           </div>".
            "           <p class='copy'>".$footerEmails."</p>".
            "       </div>";
            
            $body = templateEmail($body, $STANDAR_STYLE_EMAIL);
            $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
                    
            enviarCorreo2($fromeMail, strtolower($userdata['email']), $subject, $body);
        }
        // Se valida la preferenca del mensaje y se env��a seg��n el idioma
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $msg = $userdata['lang'] == 'esp' ? $data['sms_esp'] : $data['sms_eng'];
            enviarSMS($userdata['phone'], $msg);
        }
        if($userPref['system'] == null || $userPref['system'] == 1){
            
            $email = '';
            $sms = '';
            
            // Si se envia por correo obtenemos el correo del usuario
            if($userPref['email'] == null || $userPref['email'] == 1){
                $sql = "SELECT usr ".
                "       FROM users ".
                "       WHERE id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                        
                $rowPrefCom = $resPref->fetch_assoc();
                
                $email = $rowPrefCom['usr'];
            }
            
            // SI se envia por sms, obtenemos el numero del usuario
            if($userPref['sms'] == null || $userPref['sms'] == 1){
                $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                "       FROM users ".
                "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                "       WHERE users.id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $rowPrefCom = $resPref->fetch_assoc();
                
                $sms = $rowPrefCom['phone'];
                
            }
            
            // Enviamos el mensaje por la mensajeria interna
            $msg =( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']);
            saveInternalMsg($db, $msg, $id, $email, $sms);
        }
    }else if($lastlevel < $level && $level == 1){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
        
        // Consultamos los datos del mensaje
        $sql = "SELECT * FROM cmsmessages WHERE id = 14";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $data = $rs->fetch_assoc();
        
        // Validamos que el usuario tenga las notificaciones activas
        $sql = "SELECT * FROM usermessages ".
        "       WHERE categoryid = ".$data['category'].
        "       AND usrid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $userPref = $rs->fetch_assoc();
        
        if($userPref['email'] == null || $userPref['email'] == 1){
            $subject = $userdata['lang'] == 'esp' ? $data['name_esp'] : $data['name_eng'];
            $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
            $body = "<div class='emailBox'>".
            "           <img class='afxLogo' src='".$homeurlCMS."./settings/img/logo-email.png'/>".
            "           <div class='mainBox'>".
            "               <h1 class='titleEmail'>".
            "                   ".($userdata['lang'] == "esp" ? "Hola" : "Hello")." ".$userdata['name'].
            "               </h1>".
            "               <p class='msgEmail'>".
            "                   ".($userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']).
            "               </p>".
            "           </div>".
            "           <p class='copy'>".$footerEmails."</p>".
            "       </div>";
            
            $body = templateEmail($body, $STANDAR_STYLE_EMAIL);
            
            enviarCorreo2($fromeMail, strtolower($userdata['email']), $subject, $body);
        }
        
        // Se valida la preferenca del mensaje y se env��a seg��n el idioma
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $msg = $userdata['lang'] == 'esp' ? $data['sms_esp'] : $data['sms_eng'];
            enviarSMS($userdata['phone'], $msg);
        }
        
        if($userPref['system'] == null || $userPref['system'] == 1){
            
            $email = '';
            $sms = '';
            
            // Si se envia por correo obtenemos el correo del usuario
            if($userPref['email'] == null || $userPref['email'] == 1){
                $sql = "SELECT usr ".
                "       FROM users ".
                "       WHERE id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                        
                $rowPrefCom = $resPref->fetch_assoc();
                
                $email = $rowPrefCom['usr'];
            }
            
            // SI se envia por sms, obtenemos el numero del usuario
            if($userPref['sms'] == null || $userPref['sms'] == 1){
                $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                "       FROM users ".
                "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                "       WHERE users.id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $rowPrefCom = $resPref->fetch_assoc();
                
                $sms = $rowPrefCom['phone'];
                
            }
                            
            // Enviamos el mensaje por la mensajeria interna
            $msg = ( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']);
            saveInternalMsg($db, $msg, $id, $email, $sms);
        }
    }else if($lastlevel < $level){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>