<?php
// cms/api/blacklist/delete
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 54))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Validamos que exista el registro
    $sql = "SELECT id,userid FROM blacklist WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM blacklist ".
    "       WHERE id = ".$id.
    "       AND userid IS NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["qty"] == 0){
        badEnd("402", array("msg"=>"No se puede borrar registro"));
    }
    
    $sql = "DELETE FROM blacklist WHERE id = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este registro"));
        else
            badEnd("500",array("msg"=>'Error interno'));
    }
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "LISTA NEGATIVA", $sessionid, "CMS", "Se eliminó el registro #".$row["id"]." de lista negativa");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>