<?php
// cms/api/blacklist/entry
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $out->entry = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 89))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Obtenemos los registros
    $sql = "SELECT blacklist.id AS id, ".
    "       blacklist.doctype AS doctype, ".
    "       blacklist.doc AS doc, ".
    "       blacklist.name AS name, ".
    "       blacklist.account AS account, ".
    "       blacklist.email AS email, ".
    "       blacklist.organism AS organism,".
    "       blacklist.date AS date, ".
    "       blacklist.link AS link, ".
    "       IF(users.id IS NOT NULL, users.id, 0) AS usrid, ".
    "       IF(users.id IS NOT NULL, users.level, '') AS level, ".
    "       IF(users.id IS NOT NULL, users.usr, '') AS usr ".
    "       FROM blacklist".
    "       LEFT JOIN users ON users.id = blacklist.userid".
    "       WHERE blacklist.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
   $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    $out->entry->id = (int)$row['id'];
        
    $out->entry->doc = new stdClass();
    $out->entry->doc->type = $row['doctype'];
    $out->entry->doc->typedsc = validateDoc($row['doctype']);
    $out->entry->doc->dsc = $row['doc'];
    
    $out->entry->name = $row['name'];
    $out->entry->account = $row['account'];
    $out->entry->email = $row['email'];
    $out->entry->organism = $row['organism'];
    $out->entry->date = date('d/m/Y', strtotime($row['date']));
    $out->entry->link = $row['link'];
    
    $out->entry->user = new stdClass();
    $out->entry->user->id = (int)$row['usrid'];
    $out->entry->user->email = $row['usr'];
        
    if ($row['level'] != '') {
        $level = getLevelById($db, $row['level']);
            
        $out->entry->user->level = (int)$level['orden'];
    } else {
        $out->entry->user->level = '';
    }
    
    $out->privileges = new stdClass();
    $out->privileges->read = tienePrivilegio($db, $sessionid, 89);
    $out->privileges->update = tienePrivilegio($db, $sessionid, 90);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para validar el tipo de documento que fue ingresado, donde:
    * 1 = CI
    * 2 = Passport
    * 3 = Driver license
    * el parametro typeid es el id del tipo de documento
    */
    function validateDoc($typeid){
        $type = '';
        
        if($typeid == 1){
            $type = "C.I";
        }else if($typeid == 4){
            $type = "RIF";
        }else if($typeid == 2){
            $type = "Pasaporte";
        }else if($typeid == 3){
            $type = "Licencia de conducir";
        }else if($typeid == 0){
            $type = null;
        }
        
        return $type;
    }
?>