<?php
// cms/api/blacklist/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    $doctype = 0;
    if(isset($_GET['doctype']) && trim($_GET['doctype'])!="")
        $doctype = $_GET['doctype'];
    $doc = $_GET['doc'];
    $name = $_GET['name'];
    $email = $_GET['email'];
    $account = $_GET['account'];
    $organism = $_GET['organism'];
    $date = $_GET['date'];
    $link = $_GET['link'];
    
    // Validamos que exista almenos 1 dato requerido
    if(($doctype == '' || $doc == '') && $name == '' && $email == '' && $account == ''){
        badEnd("400", array("msg"=>"Debe enviar almenos 1: Nombre, Documento, cuenta o correo"));
    }
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
        
    //Si el id es igual a 0, se crea, si no se actualiza la region
    if($id == 0){
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 91))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        // Insertamos
        $sql = "INSERT INTO blacklist(".
        "           doctype, doc, name, email, account, organism, date, link, createddate, lastupload".
        "       ) ".
        "       VALUES(".
        "       ".$doctype.", ".
        "       '".$doc."', ".
        "       '".$name."', ".
        "       '".$email."', ".
        "       '".$account."', ".
        "       '".$organism."', ".
        "       '".($date == '' ? '' : date('Y-m-d', strtotime($date)))."', ".
        "       '".$link."', ".
        "       NOW(), ".
        "       NOW() ".
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "LISTA NEGATIVA", $sessionid, "CMS", "Se agregó el registro #".$out->id);
    }else{
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 90))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT COUNT(id) AS qty FROM blacklist WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        // Actualizamos el registro
        $sql = "UPDATE blacklist SET".
        "       doctype = ".$doctype.", ".
        "       doc = '".$doc."', ".
        "       name = '".$name."', ".
        "       email = '".$email."', ".
        "       account = '".$account."', ".
        "       organism = '".$organism."', ".
        "       date = '".($date == '' ? '' : date('Y-m-d', strtotime($date)))."', ".
        "       link = '".$link."', ".
        "       lastupload = NOW() ".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "LISTA NEGATIVA", $sessionid, "CMS", "Se actualizó el registro #".$out->id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>