<?php
// cms/api/currencies/update

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","name","symbol","status","decimals","interface", "xfer");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $name = $_GET["name"];
    $symbol = $_GET["symbol"];
    $status = $_GET["status"];
    $decimals = $_GET["decimals"];
    $interface = (int)$_GET['interface'];
    $xfer = (int)$_GET['xfer'];
    $icon = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos el tamano del decimal
    if($decimals < 2 || $decimals > 10){
        badEnd("400", array("msg"=>"Cantidad de decimales minimo 2 y maximo 10"));
    }
    
    //Si el id es igual a 0, se crea, si no se actualiza la moneda
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 11))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para verificar que no existe una moneda igual
        $sql = "SELECT count(id) AS qty FROM currencies ".
        "       WHERE name = '".$name."' ".
        "       AND symbol = '".$symbol."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        if($row["qty"] > 0){
            badEnd("402", array("msg"=>"Registro duplicado"));
        }
        
        $labelIcon = "";
        
        //En caso de que el icon sea enviado, se construye el query
        if(isset($_GET["icon"]) && $_GET["icon"] != ""){
            $icon = ", '".$_GET["icon"]."'";
            $labelIcon = ", icon";
        }
        
        $sql = "INSERT INTO currencies(xfer, name, symbol, status, interface, decimals".$labelIcon.")".
        "       VALUES (".$xfer.", '".$name."', '".$symbol."', ".$status.", ".$interface.",".$decimals."".$icon.")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        // Agregamos la moneda en los metodos de pago
        $db->autocommit(FALSE);
        
        //Insertamos la nueva cuenta
        $sql = " UPDATE paymentmethods ".
        "       SET currencies = CONCAT(currencies,',".$out->id."') ".
        "       WHERE id < 0";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>'Error interno'));
        }
        
        
        //Creamos las cuentas para generar cuentas y comisiones
        $sql = "INSERT INTO accounts( ".
        "       paymentmethodid, userid, currencyid, status ".
        "       ) ".
        "       VALUES ".
        "       (-2, -1, ".$out->id.", 1), ".
        "       (-3, -1, ".$out->id.", 1), ".
        "       (-4, -1, ".$out->id.", 1), ".
        "       (-5, -1, ".$out->id.", 1), ".
        "       (-6, -1, ".$out->id.", 1), ".
        "       (-7, -1, ".$out->id.", 1)";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>'Error interno'));
        }
        
        // Guardamos la moneda en la tabla de rates
        $sql = "INSERT INTO cmsprefrates(currencyid, rate) ".
        "       VALUES (".$out->id.", 0)";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>'Error interno'));
        }
        
        //Insertamos los datos en el cmspreffees para las comisiones y todo eso
        $sql = "INSERT INTO cmspreffees(".
        "       levelid, currencyid, ".
        "       pairid, usertype, ".
        "       pctfeedeposits, nmlfeedeposits, ".
        "       pctfeewithdrawals, nmlfeewithdrawals, ".
        "       pctfeexfer, nmlfeesxfer, ".
        "       mindeposit, minexchange, ".
        "       minwithdraw, minxfer, ".
        "       maxqtymonthlyopdeposits, ".
        "       maxamountmonthlyopdeposits, ".
        "   	maxqtymonthlyopwithdrawals, ".
        "       maxamountmonthlyopwithdrawals, ".
        "       maxamountmonthlyopxfer, ".
        "       nmlmktfee, pctmktfee, ".
        "       nmllimitfee, pctlimitfee ".
        "       )".
        "       VALUES";
        // Recorremos los tipos de usuario(2)
        for($i = 0; $i < 2; $i++){
            //#new
            $sqllvls = "SELECT id FROM levels";
            if (!$rsLvls=$db->query($sqllvls))
                badEnd("500", array("msg"=>determinateDBError($db)));

            //Recorremos los niveles (3)
            while($rowLvls = $rsLvls->fetch_assoc()){
                if($rowLvls['id']>0){
                    $sql .= " (".
                    "       ".$rowLvls['id'].", ".$out->id.", ".
                    "       NULL, ".($i+1).", ".
                    "       0, 0, ".
                    "       0, 0, ".
                    "       0, 0, ".
                    "       0, 0, ".
                    "       0, 0, ".
                    "       0, ".
                    "       0, ".
                    "   	0, ".
                    "       0, ".
                    "       0, ".
                    "       0, 0, ".
                    "       0, 0 ".
                    "       ),";
                }
            }
        }
        // Eliminamos la ultima coma jeje
        $sql = substr($sql, 0, -1);
        
        // Guardamos las preferencias
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>'Error interno'));
        }
        
        //auditoria
        setAudit($db, "MONEDAS", $sessionid, "CMS", "Se agregó la moneda ".$name);
        
        $db->commit();
        $db->close();
        
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 12))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT name, status FROM currencies WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        //Consultamos para verificar que no existe una moneda igual
        $sql = "SELECT count(id) AS qty FROM currencies ".
        "       WHERE name = '".$name."' ".
        "       AND symbol = '".$symbol."'".
        "       AND id != ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        if($row["qty"] > 0){
            badEnd("402", array("msg"=>"Registro duplicado"));
        }
        
        // Validamos que no tenga pares activos si se quiere desactivar
        if ($status == 0) {
            $sql = "SELECT COUNT(id) AS qty FROM pairs WHERE (currencyid = ".$id.
            "       OR refcurrencyid = ".$id.") ".
            "       AND status = 1";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                
            $row = $rs->fetch_assoc();
            
            if ($row['qty'] > 0) {
                badEnd("405", array("msg"=>"Moneda no puede desactivarse por que tiene pares activos"));
            }
        }
        
        //En caso de que el icon sea enviado, se construye el query
        if(isset($_GET["icon"]) && $_GET["icon"] != ""){
            $icon = "icon = '".$_GET["icon"]."',";
        }
        
        $sql = "UPDATE currencies SET".
        "       name = '".$name."', ".
        "       symbol = '".$symbol."', ".
        "       decimals = ".$decimals.", ".
        "       xfer = ".$xfer.", ".
        "       interface = ".$interface.", ".
        "       ".$icon.
        "       status = ".$status.
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "MONEDAS", $sessionid, "CMS", "Se actualizó la moneda ".$name);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
