<?php
// cms/api/departments/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Definimos las variables que usaremos y las inicializamos
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET['id']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 77))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Obtenemos los detalles de los mensajes
    $sql = "SELECT * ".
    "       FROM departments".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    $out->entry= new stdClass();
    
    $out->entry->id = (int)$row['id'];
    $out->entry->dsc = $row['dsc'];
    $out->entry->email = $row['email'];
    $out->entry->phone1 = $row['phone1'];
    $out->entry->phone2 = $row['phone2'];
    $out->entry->phone3 = $row['phone3'];
    
    $out->entry->helpdesk = $row['helpdesk'];
    
    $privileges = new stdClass();
    $privileges->read = tienePrivilegio($db, $sessionid, 77);
    $privileges->create = tienePrivilegio($db, $sessionid, 74);
    $privileges->delete = tienePrivilegio($db, $sessionid, 76);
    $privileges->update = tienePrivilegio($db, $sessionid, 75);
    
    $out->privileges = $privileges;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>