<?php
// cms/api/economicact/entry
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET['id']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 69))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Consultamos la cantidad registros
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM economicactivities ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    // Si es 0, no se encontro registro
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Consultamos los detalles de los registros
    $sql = "SELECT * FROM economicactivities ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
        
    $out->entry->id = (int)$row['id'];
    $out->entry->dsc = $row['dsc'];
    $out->entry->dsc_eng = $row['dsc_eng'] == null ? '' : $row['dsc_eng'];
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 66);
    $access->read =   tienePrivilegio($db, $sessionid, 69);
    $access->update = tienePrivilegio($db, $sessionid, 67);
    $access->delete = tienePrivilegio($db, $sessionid, 68);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>