<?php
// cms/api/login/forgot
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    // parametros obligatorios
    $parmsob = array("email");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del GET
    $email = $_GET["email"];
    $out = new stdClass();
    $hash = randomString(128);
    
    // se genera el hash que servirá para la validar la recuperación
    $sql =  "UPDATE cmsusers " .
            "SET    sessionid = '".mysqli_real_escape_string($db, $hash)."' ".
            "WHERE  UPPER(usr)=UPPER('".mysqli_real_escape_string($db, $email)."')";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    //revisamos la respuesta del query y verificamos si fue ejecutada correctamente 
    if ($db->affected_rows == 0){
        badEnd("401", array("msg"=>"No tenemos ningún usuario registrado con ese email"));
    }
    
    // Obtener el nombre del usuario || USERS NO CONTIENE COLUMNA name
    $sql = "SELECT name FROM cmsusers WHERE UPPER(usr)=UPPER('".mysqli_real_escape_string($db, $email)."')";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    if (!$row = $rs->fetch_assoc())        
        badEnd("500", array("msg"=>"El usuario no es valido"));
        
    $usrname = $row["name"];
    
    $subject = "Recuperación de clave ".$shortname." - CMS";
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $styleTag = 
        "<style rel='stylesheet' type='text/css'>".
        "           .emailBox {".
        "               background-color: #F8F8FA;".
        "               padding: 20px;".
        "           }".
        "           .code {".
        "               font-family: Helvetica, sans-serif;".
        "               margin: auto;".
        "               display: block;".
        "               color: #FFF;".
        "               font-size: 16px;".
        "               text-align:center;".
        "               line-height: 58px;".
        "               font-weight:bold;".
        "           }".
        "           .copy {".
        "               font-family: 'Roboto', sans-serif;".
        "               font-weight: 400;".
        "               font-size: 12px;".
        "               margin-top:40px;".
        "               color: #767E93;".
        "               text-align:center;".
        "           }".
        "           .mainBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #FFF;".
        "               border-radius: 22px;".
        "               width: 60%;".
        "               padding:30px;".
        "           }".
        "           .msg { ".
        "               font-size: 18px;".
        "               color: #474C58;".
        "               text-align:center;".
        "               margin-bottom:30px;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .titleEmail {".
        "               color:#474C58;".
        "               text-align:center;".
        "               font-size: 20px;".
        "               font-weight: bold;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .urlNavigateBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #4287CE;".
        "               border-radius: 8px;".
        "               width: 200px;".
        "               height: 57px;".
        "               text-align:center;".
        "               text-decoration: none;".
        "           }".
        "           @media (max-width: 450px) {".
        "               .mainBox {".
        "                   width: 95% !important;".
        "                   padding: 25px 0px;".
        "               }".
        "               .emailBox {".
        "                   padding: 0px;".
        "               }".
        "               .titleEmail {".
        "                   font-size: 18px;".
        "               }".
        "               .msg {".
        "                   font-size: 14px;".
        "               }".
        "           }".
        "</style>";
    $msg_esp = "Para recuperar su clave dir&iacute;jase a la direcci&oacute;n indicada a continuaci&oacute;n:";
    $msg_eng = "To recover your password, go to the address indicated below:";
    $body = 
        "<div class='emailBox'>".
        "   <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurlCMS."./settings/img/logo-email.png'/>".
        "   <div class='mainBox'>".
        "       <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurlCMS."/img/img_password.png'/>".
        "       <h1 class='goodText titleEmail'>".
        "           Hola ".$usrname.
        "       </h1>".
        "       <p class='goodText msg'>".
        "           Para recuperar su clave dir&iacute;jase a la direcci&oacute;n indicada a continuaci&oacute;n:".
        "       </p>".
        "       <a class='urlNavigateBox' href=".$homeurlCMS . "?id=login&sid=forgotpass&usr=".urlencode(strtolower(mysqli_real_escape_string($db, $email)))."&hash=".$hash.">".
        "           <p class='code'>".
        "               Recuperar clave".
        "           </p>".
        "       </a>".
        "   </div>".
        "   <p class='copy'>".$footerEmails."</p>".
        "</div>";
        
    $body = templateEmail($body, $styleTag);
            
    enviarCorreo2($fromeMail, strtolower($email), $subject, $body);

    $out->email = strtolower($email);

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>

