<?php 
    //cms/api/ocupations/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id'); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET['id']);
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 64))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Consultamos que el registro exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM ocupations ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    //Si la cantidad es igual a 0, no existe
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'No se encuentra el registro'));
    }
    
    // Consultamos los datos de la ocupacion
    $sql = "SELECT * ".
    "       FROM ocupations ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    // Validamos que no exista en algun usuario natural
    $sql = "SELECT COUNT(*) AS qty FROM userpersons ".
    "       WHERE ocupation = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $valid = $rs->fetch_assoc();
    
    if($valid['qty'] > 0){
        badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Actividad econmica"));
    }
    
    // Eliminamos la ocupacion    
    $sql = "DELETE FROM ocupations WHERE id = ".$id;
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Ocupación"));
        else
            badEnd("500",array("msg"=>determinateDBError($db)));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "OCUPACIONES", $sessionid, "CMS", "Se eliminó la ocupación ".($row['dsc'] != "" ? $row['dsc'] : $row['dsc_eng']));
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>