<?php
// cms/api/paymentmethods/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","currencies","details1","status","countryid","dsc");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    $dsc = mysqli_real_escape_string($db, $_GET["dsc"]);
    $currencies = mysqli_real_escape_string($db, $_GET["currencies"]);
    $countryid = mysqli_real_escape_string($db, $_GET["countryid"]);
    $status = mysqli_real_escape_string($db, $_GET["status"]);
    $details1 = mysqli_real_escape_string($db, $_GET["details1"]);
    
    //USAR LA PRIMERA CURRENCY DE $CURRENCIES COMO PRINCIPAL SI CURRENCYID NO FUE ENVIADA
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es igual a 0, se crea, si no se actualiza el metodo
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 19))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Validamos que no exista este metodo por su pais,moneda y dsc
        $sql = "SELECT COUNT(id) as qty FROM paymentmethods".
        "       WHERE dsc = '".$dsc."' AND ".
        "       countryid = ".$countryid." AND ".
        "       currencyid = ".substr(validateCurrencyId("currencyid", $currencies), 0, -1);
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $res = $rs->fetch_assoc();
        //Si obtenemos almenos 1 resultado significa que ya existe un registro similar
        if($res["qty"] > 0){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }
        
        $sql = "INSERT INTO paymentmethods".
        "       (dsc, ".
        "       countryid, ".
        "       details1, ".
        "       ".validateInsertField("details2","details2").
        "       ".validateInsertField("details3","details3").
        "       ".validateInsertField("details4","details4").
        "       currencyid, ".
        "       currencies, ".
        "       status)".
        "       VALUES('".$dsc."', ".
        "       ".$countryid.", ".
        "       '".$details1."', ".
        "       ".validateInsertValue("details2","string")." ".
        "       ".validateInsertValue("details3","string")." ".
        "       ".validateInsertValue("details4","string")." ".
        "       ".validateCurrencyId("currencyid", $currencies)." ".
        "       ".validateCurrencies($currencies, $db)." ".
        "       ".$status.")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "F. DE PAGO", $sessionid, "CMS", "Se agregó la forma de pago ".$dsc);
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 20))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Validamos que no exista este metodo por su pais,moneda y dsc
        $sql = "SELECT COUNT(id) as qty FROM paymentmethods".
        "       WHERE dsc = '".$dsc."' AND ".
        "       countryid = ".$countryid." AND ".
        "       id != ".$id." AND ".
        "       currencyid = ".substr(validateCurrencyId("currencyid", $currencies), 0, -1);
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $res = $rs->fetch_assoc();
        
        //Si obtenemos almenos 1 resultado significa que ya existe un registro similar
        if($res["qty"] > 0){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT dsc FROM paymentmethods WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["dsc"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE paymentmethods SET".
        "       dsc = '".$dsc."', ".
        "       countryid = ".$countryid.", ".
        "       details1 = '".$details1."', ".
        "       details2 = ".($_GET["details2"] == "" ? "null" : "'".$_GET["details2"]."'").", ".
        "       details3 = ".($_GET["details3"] == "" ? "null" : "'".$_GET["details3"]."'").", ".
        "       details4 = ".($_GET["details4"] == "" ? "null" : "'".$_GET["details4"]."'").", ".
        "       currencyid = ".validateCurrencyId("currencyid", $currencies)." ".
        "       currencies = ".validateCurrencies($currencies, $db)." ".
        "       status = ".$status.
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "F. DE PAGO", $sessionid, "CMS", "Se actualizó la forma de pago ".$dsc);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para validar que el parametro fue enviado.
    * Si el parametro existe retorna true y si no retorna false
    */
    function validateUpdate($param){
        $bolValues = false;
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            $bolValues = true;
        }
        return $bolValues;
    }
    
    /*  Funcion para validar que el campo fue enviado, 
    *   y armar los campos a insertar
    *   Se reciben dos parametros:
    *   $param = Parametro a validar
    *   $field = nombre del campo
    */
    function validateInsertField($param, $field){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $str = $str." ".$field.",";
        }
        
        return $str;
    }
    
    /*  Funcion para validar que el valor fue enviado, 
    *   y armar el string para insertarlo
    *   Se recibe un parametro:
    *   $param = Parametro a validar
    *   $type = Tipo de valor
    */
    function validateInsertValue($param,$type){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            if($type == "string"){
                $str = $str." '".$_GET[$param]."',";
            }else if($type == "number"){
                $str = $str." ".$_GET[$param].",";
            }else{
                $str = $str." '".$_GET[$param]."',";
            }
        }
        
        return $str;
    }
    
    /*  Funcion para validar que se envio currencyid y si no,
    *   colocar la primera de currencies como currencyid.
    *   Recibe dos parametros:
    *   $currencyid = string con nombre del parametro de currencyid
    *   $currencies = Parametro de currencies
    */
    function validateCurrencyId($currencyid, $currencies){
        $str = "";
        $currenciesarr = explode("-", $currencies);
        
        if(isset($_GET[$currencyid]) && $_GET[$currencyid] != ""){
            $str = $str." ".$_GET[$currencyid].",";
        }else{
            $str = $str." ".$currenciesarr[0].",";
        }
        
        return $str;
    }
    
    /*  Funcion para validar cada una de las monedas y saber si de verdad existen 
    *   Tambien, ordenarlas para ser guardadas.
    *   Esta funcion recibe un parametro:
    *   $currencies = parametro de currencies
    *   $db = Bd para ejecutar querys
    */
    function validateCurrencies($currencies, $db){
        $str = "";
        
        $currenciesarr = explode("-", $currencies);
        foreach($currenciesarr as $currency){
            $sql = "SELECT * FROM currencies WHERE id = ".$currency;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                
            $row = $rs->fetch_assoc();
            if($row["name"] == null){
                badEnd("404", array("msg"=>"Registro de moneda no encontrado ".$currency));
            }
            
            $str = $str."".$currency.",";
        }
        
        return "'" . substr($str, 0, -1) . "',";
    }
?>