<?php
// cms/api/preferences/saveexchangefees

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'levelid','pairid','usertype');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $levelid = mysqli_real_escape_string($db, $_GET['levelid']);
    $pairid = mysqli_real_escape_string($db, $_GET['pairid']);
    $usertype = mysqli_real_escape_string($db, $_GET['usertype']);
    $updateString = '';
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que recibimos los datos MARKET
    if(isset($_GET['pctfeemkt']) && $_GET['pctfeemkt'] != '' && isset($_GET['nmlfeemkt']) && $_GET['nmlfeemkt'] != ''){
        badEnd('500',array('msg'=>'Debe ser enviado pctfeemkt o nmlfeemkt, no ambos'));
    }else if(isset($_GET['pctfeemkt']) && $_GET['pctfeemkt'] != ''){
        $updateString .= " pctmktfee = ".(validNumber($_GET['pctfeemkt']) ? floatval($_GET['pctfeemkt']) : (validNumberFormatted($_GET['pctfeemkt']) ? parseFormattedNumber($_GET['pctfeemkt'])  : 'NULL')).", ".
        "               nmlmktfee = NULL,";
    }else if(isset($_GET['nmlfeemkt']) && $_GET['nmlfeemkt'] != ''){
        $updateString .= " nmlmktfee = ".(validNumber($_GET['nmlfeemkt']) ? floatval($_GET['nmlfeemkt']) : (validNumberFormatted($_GET['nmlfeemkt']) ? parseFormattedNumber($_GET['nmlfeemkt'])  : 'NULL')).", ".
        "               pctmktfee = NULL,";
    }else{
        badEnd('500',array('msg'=>'Debe ser enviado pctfeemkt o nmlfeemkt'));
    }
    
    // Validamos que recibimos los datos LIMIT
    if(isset($_GET['pctfeelimit']) && $_GET['pctfeelimit'] != '' && isset($_GET['nmlfeelimit']) && $_GET['nmlfeelimit'] != ''){
        badEnd('500',array('msg'=>'Debe ser enviado pctfeelimit o nmlfeelimit, no ambos'));
    }else if(isset($_GET['pctfeelimit']) && $_GET['pctfeelimit'] != ''){
        $updateString .= " pctlimitfee = ".(validNumber($_GET['pctfeelimit']) ? floatval($_GET['pctfeelimit']) : (validNumberFormatted($_GET['pctfeelimit']) ? parseFormattedNumber($_GET['pctfeelimit'])  : 'NULL')).", ".
        "               nmllimitfee = NULL,";
    }else if(isset($_GET['nmlfeelimit']) && $_GET['nmlfeelimit'] != ''){
        $updateString .= " nmllimitfee = ".(validNumber($_GET['nmlfeelimit']) ? floatval($_GET['nmlfeelimit']) : (validNumberFormatted($_GET['nmlfeelimit']) ? parseFormattedNumber($_GET['nmlfeelimit'])  : 'NULL')).", ".
        "               pctlimitfee = NULL,";
    }else{
        badEnd('500',array('msg'=>'Debe ser enviado pctfeelimit o nmlfeelimit'));
    }
        
    // Consultamos el par a modificar
    $sql = "SELECT COUNT(levelid) AS qty FROM cmspreffees ".
    "       WHERE levelid = ".$levelid.
    "       AND pairid = ".$pairid.
    "       AND usertype = ".$usertype;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    
    //SI es igual a 0, no fue encontrado ningun registro
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Actualizamos los datos del par
    $sql = "UPDATE cmspreffees SET ".
    "       ".substr($updateString, 0, -1).
    "       WHERE levelid = ".$levelid.
    "       AND pairid = ".$pairid.
    "       AND currencyid IS NULL ".
    "       AND usertype = ".$usertype;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $out->quepasa = $sql;
    $out->levelid = (int)$levelid;
    $out->pairid = (int)$pairid;
    $out->usertype = (int)$usertype;
    
    // Obtenemos el nombre del par
    $sql = "SELECT CONCAT(currencies.symbol,'/',cursec.symbol) AS pairdsc ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies cursec ON cursec.id = par.currencyid ".
    "       WHERE par.refcurrencyid = currencies.id ".
    "       AND par.id = ".$pairid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $pairInfo = $res->fetch_assoc();
    
    // auditoria
    setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizaron las comisiones para el par ".$pairInfo['pairdsc'].", Persona ".($usertype == 1 ? 'Natural' : 'Jurídica').", Nivel ".$levelid); 
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
