<?php
// cms/api/preferences/savelimits
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'levelid','currencyid','usertype','maxmensualdeposit','opmensualdeposit','maxmensualwithdraw','opmensualwithdraw','maxmensualxfer');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $levelid = mysqli_real_escape_string($db, $_GET['levelid']);
    $currencyid = mysqli_real_escape_string($db, $_GET['currencyid']);
    $usertype = mysqli_real_escape_string($db, $_GET['usertype']);
    $maxmensualdeposit = mysqli_real_escape_string($db, $_GET['maxmensualdeposit']);
    $opmensualdeposit = mysqli_real_escape_string($db, $_GET['opmensualdeposit']);
    $maxmensualwithdraw = mysqli_real_escape_string($db, $_GET['maxmensualwithdraw']);
    $opmensualwithdraw = mysqli_real_escape_string($db, $_GET['opmensualwithdraw']);
    $maxmensualxfer = mysqli_real_escape_string($db, $_GET['maxmensualxfer']);
    $maxpagomovil = null;
    
    if ($currencyid == 1) {
        $parmsob = array("maxpagomovil");
        if (!parametrosValidos($_GET, $parmsob))
            badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
            
        $maxpagomovil = mysqli_real_escape_string($db, $_GET['maxpagomovil']);
    }
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        
    //Validamos que exista el registro a modificar
    $sql = "SELECT COUNT(levelid) AS qty ".
    "       FROM cmspreffees ".
    "       WHERE levelid = ".$levelid.
    "       AND currencyid = ".$currencyid.
    "       AND usertype = ".$usertype;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    
    //SI es igual a 0 no existe
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Actualizamos los limites
    $sql = "UPDATE cmspreffees SET ".
    "       maxqtymonthlyopdeposits = ".$opmensualdeposit.", ".
    "       maxamountmonthlyopdeposits = ".(validNumber($maxmensualdeposit) ? floatval($maxmensualdeposit) : (validNumberFormatted($maxmensualdeposit) ? floatval(parseFormattedNumber($maxmensualdeposit))  : '')).", ".
    "       maxqtymonthlyopwithdrawals = ".$opmensualwithdraw.", ".
    "       maxamountmonthlyopwithdrawals = ".(validNumber($maxmensualwithdraw) ? floatval($maxmensualwithdraw) : (validNumberFormatted($maxmensualwithdraw) ? floatval(parseFormattedNumber($maxmensualwithdraw))  : '')).", ".
    "       maxamountmonthlyopxfer = ".(validNumber($maxmensualxfer) ? floatval($maxmensualxfer) : (validNumberFormatted($maxmensualxfer) ? floatval(parseFormattedNumber($maxmensualxfer))  : ''))." ".
    (($maxpagomovil != null)?(",pagomovilmaxsend = ".$maxpagomovil):"").
    "       WHERE levelid = ".$levelid.
    "       AND currencyid = ".$currencyid.
    "       AND usertype = ".$usertype;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));

    //Consultamos el nombre de la moneda para mostrarlo en la auditoria
    $sql = "SELECT name FROM currencies WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    
    //auditoria
    setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizaron los límites para la moneda ".$row['name'].", Persona ".($usertype == 1 ? 'Natural' : 'Jurídica').", Nivel ".$levelid);  
    
    $out->levelid = (int)$levelid;
    $out->currencyid = (int)$currencyid;
    $out->usertype = (int)$usertype;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
