<?php
// cms/api/rates/delete
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid','id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 81))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que exista
    $sql = "SELECT COUNT(id) AS qty FROM rateshistory WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row["qty"] == 0){
        badEnd("404", array("msg"=>"No se encuentra el registro"));
    }
    
    // Obtenemos los datos para la auditoria
    $sql = "SELECT rateshistory.amount AS amount, ".
    "       currencies.decimals AS decimals, ".
    "       currencies.symbol AS symbol ".
    "       FROM rateshistory, currencies ".
    "       WHERE rateshistory.id = ".$id.
    "       AND currencies.id = rateshistory.currencyid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    $sql = "DELETE FROM rateshistory WHERE id = ".$id;
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Tasa"));
        else
            badEnd("500",array("msg"=>determinateDBError($db)));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "TASAS", $sessionid, "CMS", "Se eliminó la tasa #".$id." de ".numberFormatt($row['amount'], $row['decimals'])." ".$row['symbol']);

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>