<?php
// cms/api/regions/update

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","countryid","dsc","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    $countryid = mysqli_real_escape_string($db, $_GET["countryid"]);
    $name = mysqli_real_escape_string($db, $_GET["dsc"]);
    $status = mysqli_real_escape_string($db, $_GET["status"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es igual a 0, se crea, si no se actualiza la region
    if($id == 0){
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 48))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "INSERT INTO regions(countryid, name, status, created_at, updated_at)".
        "       VALUES (".$countryid.", '".$name."', ".$status.", NOW(), NOW())";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "ESTADOS", $sessionid, "CMS", "Se agregó el estado ".$name);
    }else{
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 49))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Consultamos para validar que el registro exista
        $sql = "SELECT COUNT(id) AS qty FROM regions WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE regions SET".
        "       countryid = ".$countryid.", ".
        "       name = '".$name."', ".
        "       status = ".$status.", ".
        "       updated_at = NOW()".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "ESTADOS", $sessionid, "CMS", "Se actualizó el estado ".$name);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
