<?php
// cms/api/roles/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","offset","numofrec");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $offset = mysqli_real_escape_string($db, $_GET["offset"]);
    $numofrec = mysqli_real_escape_string($db, $_GET["numofrec"]);
    $order = "";
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 10))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        $filter = " AND (name LIKE '".mysqli_real_escape_string($db, $_GET["filter"])."%')";
    }
    
    //En caso de que el order sea enviado, se construye el query
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".determinateOrder(mysqli_real_escape_string($db, $_GET["order"]));
    }
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(id) AS qty".
    "       FROM cmsusers".
    "       WHERE type = 1 ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los registros que sean type = 1(roles)
    $sql = "SELECT * FROM cmsusers".
    "       WHERE type = 1 ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->name = $row["name"];
        
        $record->status = new stdClass();
        $record->status->id = (int)$row["status"];
        $record->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 7);
    $access->read =   tienePrivilegio($db, $sessionid, 10);
    $access->update = tienePrivilegio($db, $sessionid, 8);
    $access->delete = tienePrivilegio($db, $sessionid, 9);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   0 = ID del rol DESCENDENTE (Mas reciente)
    *   1 = Nombre del rol ASCENDENTE
    *   2 = Status del rol ASCENDENTE
    *   -1 = Nombre del rol DESCENDENTE
    *   -2 = Status del rol DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = "id DESC";
                break;
            case 1:
                $orderres = "name ASC";
                break;
            case 2:
                $orderres = "status ASC";
                break;
            case -1:
                $orderres = "name DESC";
                break;
            case -2:
                $orderres = "status DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 0, 1, 2, -1 o -2"));
                break;
        }
        
        return $orderres;
    }
?>
