//Variables globales
var cleared = null;
var sessionId = sessionStorage.getItem("sessionId");
var dataC = false;
var userSelected = 0;
var userEmail = '';
var userType = 0;

window.onload = function () {
    initApp();

    document.getElementById('informsList').addEventListener('change', function () {
        console.log(this.value);
        if (this.value != 0) {
            let parameterUserName = getParameterByName("userName");
            gotoPage("menu", this.value, { "userName": parameterUserName });
        }
    });

    document.getElementById("identification").addEventListener("click", function () {
        document.getElementById("doc").focus();
    });

    //BUSQUEDA INTELIGENTE por correo
    document.getElementById("emailUser").addEventListener("keyup", function (e) {
        userSelected = "";
        if (this.value.length >= 3) {
            if (cleared !== null) {
                clearTimeout(cleared);
            }
            cleared = setTimeout(function () { myUsers(document.getElementById("emailUser").value); }, 1000);
        } else if (e.keyCode == 8) {
            document.getElementById("emailUser").value = "";
            userSelected = "";
            if (cleared !== null) {
                clearTimeout(cleared);
            }
        }
    });

    //BUSQUEDA INTELIGENTE por cedula
    document.getElementById("doc").addEventListener("keyup", function (e) {
        userSelected = "";
        if (this.value.length >= 3) {
            if (cleared !== null) {
                clearTimeout(cleared);
            }
            cleared = setTimeout(function () { myUsersByDoc(document.getElementById("doc").value); }, 1000);
        } else if (e.keyCode == 8) {
            document.getElementById("doc").value = "";
            userSelected = "";
            if (cleared !== null) {
                clearTimeout(cleared);
            }
        }
    });

    window.addEventListener("click", function () {
        var div = document.getElementById("searchResult");
        div.classList.add("noShow");

        div = document.getElementById("searchResultByDoc");
        div.classList.add("noShow");
    });
}

function mySearchAdd(lista, data, num) {
    lista.innerHTML = "";
    if (num === 0) {
        var line = document.createElement("li");
        line.innerHTML = '<span class="smallRsp">No tenemos registros que coincidan con su busqueda.</span>';
        lista.appendChild(line);
    } else {
        for (navLink of data) {
            var line = document.createElement("li");
            line.classList.add("myNewLineUser");
            line.innerHTML = '<p class="nameResult"> ' + navLink + '</p>';
            lista.appendChild(line);
        }
    }
    document.querySelectorAll('[class="myNewLineUser"]').forEach(function (element) {
        element.addEventListener('mousedown', function (event) {
            var inpt = document.getElementsByClassName("tagInptEle")[0].getElementsByTagName("input")[0];
            inpt.value = this.children[0].innerText;
        });
        element.addEventListener('click', function (event) {
            setTimeout(function () {
                var inpt = document.getElementsByClassName("tagInptEle")[0].getElementsByTagName("input")[0];
                inpt.value = "";
            }, 500);
        });
    });
}



function callDownload() {

    download(`reports/userdetails?sessionid=${encodeURIComponent(req.sessionid)}&userid=${userSelected}`);
    return;
}

//Función para cargar listado
function loadList() {

    if (verifyData()) {

        document.getElementById('bodyTableCurrencies').style.display = "none"
        document.getElementById('noCurrencieDefine').style.display = "none"

        var req = {
            "userid": userSelected,
            "sessionid": sessionId,
        }

        console.log(req)

        callWS("GET", "reports/userdetails", req, respLoadReportsUserDetails);
        return 0;
    } else {
        document.getElementById('serviceTable').style.display = "none"
    }
}

function verifyData() {
    document.getElementById('noServiceTable').style.display = "none"
    var ok = true;
    var arrayData = []

    if (!document.getElementById("emailUser").value || userSelected == '' || userSelected == 0) {
        arrayData.push('Usuario')
    }

    if (arrayData.length > 0 || userSelected == '' || userSelected == 0) {
        ok = false
        if (arrayData.length > 1) {
            document.getElementById('msgInTable').innerHTML = "Faltan los siguientes datos: "
            for (var i = 0; i < arrayData.length; i++) {
                if (i + 1 == arrayData.length) {
                    document.getElementById('msgInTable').innerHTML += ' y ' + arrayData[i] + '.'
                } else {
                    document.getElementById('msgInTable').innerHTML += arrayData[i] + ', '
                }
            }
        } else {
            document.getElementById('msgInTable').innerHTML = "Falta el siguiente dato: " + arrayData[0] + '.'
        }
        document.getElementById('bodyTableCurrencies').style.display = "table"
        document.getElementById('noCurrencieDefine').style.display = "table-cell"
    }
    return ok
}

function setTableModel() {
    document.getElementById('serviceTable').innerHTML = `
        <div style="display: table; width: 94%; padding: 0% 3%;margin-top: 5px;">
            <div style="display: table-cell; width: calc(100% - 45px); vertical-align: middle; height: 45px;">
                <p class="infT" id="userNameDetails"></p>
                
                <p class="infT" id="typeStatusUser">
                
                </p>
                
            </div>
            <!--
            <div style="display: table-cell; width: 45px; vertical-align: middle;" class="showInPrint">
                 <div class="circledown" id="downloadData" style="width: 45px;">
                    <i class="fa fa-download blue" aria-hidden="true"></i>
                </div>
            </div>-->
            <span style='margin:0px 4px;'></span>
            <div style="display: table-cell; width: 45px; vertical-align: middle;" class="showInPrint">
                 <div class="circledown" id="printData" style="width: 45px;">
                    <i class="fa fa-print blue" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div id="reportImp">
            <div class="tableInf">
                <div class="tableInfName">
                    <!--Name-->
                    <p></p>
                </div>
            </div>
        </div>  
        <div class="tableInf">
            <div>
                <div>
                    <div id="userDetailsInfoHeader" class="tableLine tableSubtotalPerson" style="border-top: 1px solid white;">
                        <div class="cellSubtotalFinal1">
                            <div class="divCellCnt">
                                <span><b>INFORMACIÓN DE USUARIO</b></span>
                            </div>
                        </div>
                        <div class="cellSubtotalFinal3 showInPrint">
                            <div class="divCellCnt">
                                <label for="printUserInfo">Seleccione para imprimir</label>
                                <label class="containerCheck">
                                  <input type="checkbox" id="printUserInfo" checked>
                                  <span class="checkmark"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- INFORMACION DEL USUARIO BOX -->
                    <div id='userDetailsInfo'>
                    </div>
                    
                    <div id='userDetailsRegisterHeader' class="tableLine tableSubtotalPerson" style="border-top: 1px solid white;">
                        <div class="cellSubtotalFinal1">
                            <div class="divCellCnt">
                                <span><b>INFORMACIÓN DE REGISTRO</b></span>
                            </div>
                        </div>
                        <div class="cellSubtotalFinal3 showInPrint">
                            <div class="divCellCnt">
                                <label for="printUserRegister">Seleccione para imprimir</label>
                                <label class="containerCheck">
                                  <input type="checkbox" id="printUserRegister" checked>
                                  <span class="checkmark"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- INFORMACION DEL USUARIO REGISTRO -->
                    <div id='userDetailsRegister'>
                    </div>
                    
                    <div id='userDetailsAccountsHeader' class="tableLine tableSubtotalPerson" style="border-top: 1px solid white;">
                        <div class="cellSubtotalFinal1">
                            <div class="divCellCnt">
                                <span><b>BALANCES</b></span>
                            </div>
                        </div>
                        <div class="cellSubtotalFinal3 showInPrint">
                            <div class="divCellCnt">
                                <label for="printUserBalance">Seleccione para imprimir</label>
                                <label class="containerCheck">
                                  <input type="checkbox" id="printUserBalance" checked>
                                  <span class="checkmark"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- INFORMACION DEL BALANCE DEL USUARIO -->
                    <div id='userDetailsAccounts'>
                    </div>
                    
                    <div id='userDetailsMovementsHeader' class="tableLine tableSubtotalPerson" style="border-top: 1px solid white;">
                        <div class="cellSubtotalFinal1">
                            <div class="divCellCnt">
                                <span><b>DATOS DE TRANSACCIONES</b></span>
                            </div>
                        </div>
                        <div class="cellSubtotalFinal3 showInPrint">
                            <div class="divCellCnt">
                                <label for="printUserTransaction">Seleccione para imprimir</label>
                                <label class="containerCheck">
                                  <input type="checkbox" id="printUserTransaction" checked>
                                  <span class="checkmark"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- INFORMACION DE TRANSACCIONES DEL USUARIO -->
                    <div id='userDetailsMovements'>
                    </div>
                    
                </div>
            </div>
        </div>`

    document.getElementById('serviceTable').style.display = "initial"
    document.getElementById('noServiceTable').style.display = "none"

    addEvents()
}

function addEvents() {
    /*document.getElementById("downloadData").addEventListener('click', function(){
        callDownload();
    });*/

    document.getElementById('printData').addEventListener('click', function () {
        printDiv();
    })

    document.getElementById('printUserInfo').addEventListener('change', function () {
        let div = document.getElementById('userDetailsInfo');
        let header = document.getElementById('userDetailsInfoHeader');
        if (this.checked) {
            div.classList.remove('showInPrint');
            header.classList.remove('showInPrint');
        } else {
            div.classList.add('showInPrint');
            header.classList.add('showInPrint');
        }
    });

    document.getElementById('printUserRegister').addEventListener('change', function () {
        let div = document.getElementById('userDetailsRegister');
        let header = document.getElementById('userDetailsRegisterHeader');
        if (this.checked) {
            div.classList.remove('showInPrint');
            header.classList.remove('showInPrint');
        } else {
            div.classList.add('showInPrint');
            header.classList.add('showInPrint');
        }
    });

    document.getElementById('printUserBalance').addEventListener('change', function () {
        let div = document.getElementById('userDetailsAccounts');
        let header = document.getElementById('userDetailsAccountsHeader');
        if (this.checked) {
            div.classList.remove('showInPrint');
            header.classList.remove('showInPrint');
        } else {
            div.classList.add('showInPrint');
            header.classList.add('showInPrint');
        }
    });

    document.getElementById('printUserTransaction').addEventListener('change', function () {
        let div = document.getElementById('userDetailsMovements');
        let header = document.getElementById('userDetailsMovementsHeader');
        if (this.checked) {
            div.classList.remove('showInPrint');
            header.classList.remove('showInPrint');
        } else {
            div.classList.add('showInPrint');
            header.classList.add('showInPrint');
        }
    });
}

function respLoadReportsUserDetails(status, rsp) {
    switch (status) {
        case 200:
            setTableModel()
            putInf(JSON.parse(rsp))
            //if(currencies.records!==null)addOptions("modulFilter",currencies.records);
            break;
        case 204:
            document.getElementById('msgInTable').innerHTML = 'Usuario no encontrado';
            document.getElementById('msgInTable').classList.add("msgError");
            document.getElementById('msgInTable').style.display = "block";
            document.getElementById('bodyTableCurrencies').style.display = "table"
            document.getElementById('noCurrencieDefine').style.display = "table-cell"
            break;
        case 400:
            console.log(rsp);
            break;
        case 401:
            document.getElementById('msgInTable').innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            document.getElementById('msgInTable').classList.add("msgError");
            document.getElementById('msgInTable').style.display = "block";
            setTimeout(function () {
                document.getElementById('msgInTable').classList.remove("msgError");
                myLogout()
                document.getElementById('msgInTable').style.display = "none";
            }, 3000);
            break;
        case 403:
            document.getElementById('msgInTable').innerHTML = JSON.parse(rsp).msg;
            document.getElementById('msgInTable').classList.add("msgError");
            document.getElementById('msgInTable').style.display = "block";
            document.getElementById('bodyTableCurrencies').style.display = "table"
            document.getElementById('noCurrencieDefine').style.display = "table-cell"
            break;
        case 500:
            console.log(rsp);
            break;
        default:
            console.log(rsp);
    }
}

function putInf(inf) {
    console.log(inf);
    putRecords(inf)
}

function putRecords(inf) {
    drawReportsUserDetails(inf.entry)
}

function drawReportsUserDetails(rsp) {
    var tbl;
    var node;
    var error;
    tbl = document.getElementById('reportImp')
    node = tbl.children[0].cloneNode(true);
    //error = tbl.children[0].cloneNode(true);
    tbl.innerHTML = "";
    //tbl.appendChild(error);
    var tmp = null;
    tmp = node.cloneNode(true);


    // Validamos el tipo de usuario
    if (rsp.company != null) {
        userType = 2;

        // Colocamos el nombre del usuario y su correo
        userEmail = rsp.usr;
        document.getElementById('userNameDetails').innerHTML = `<b>${rsp.company.name}${rsp.company.comercialname != '' ? ` / ${rsp.company.comercialname}` : ''}</b> ${rsp.usr}`;
        document.getElementById('typeStatusUser').innerHTML = `Persona ${rsp.type.dsc} - ${rsp.status.dsc}`;

        drawUserInfoPerson(rsp);
        drawUserRegisterCompany(rsp);
        drawUserBalances(rsp);
        drawTransactions(rsp);

    } else if (rsp.person != null) {
        userType = 1;
        // Colocamos el nombre del usuario y su correo
        document.getElementById('userNameDetails').innerHTML = `<b>${rsp.person.firstname} ${rsp.person.firstlastname}</b> ${rsp.usr}`;
        document.getElementById('typeStatusUser').innerHTML = `Persona ${rsp.type.dsc} - ${rsp.status.dsc}`;

        drawUserInfoPerson(rsp);
        drawUserRegisterPerson(rsp);
        drawUserBalances(rsp);
        drawTransactions(rsp);
    }
}

function drawTransactions(rsp) {
    document.getElementById('userDetailsMovements').innerHTML = `
        <div class="tableDetails">
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Operaciones Realizadas</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Fecha Operación</span>
                </div>
                
                <div class="alignTextLeft">
                    <span>Tipo de Transacción</span>
                </div>
                
                <div>
                    <span>Moneda</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Cantidad Total</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Destino</span>
                </div>
                
                <div>
                    <span>Estatus</span>
                </div>
                
            </div>
            
            ${getMovements(rsp.operations.records)}
            
            ${getSubtotals(rsp.operations.subtotals)}
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Intercambios Completados</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Fecha Operación</span>
                </div>
                
                <div>
                    <span>Par</span>
                </div>
                
                <div>
                    <span>Tipo</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Cantidad</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Precio</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Total</span>
                </div>
                
            </div>
            
            ${getExchanges(rsp.exchanges)}
        </div>
    `;
}

function getExchanges(exchanges) {
    let rows = '';

    for (let i = 0; i < exchanges.length; i++) {
        rows += `
            <div class="tableRowPadding tableRowDetails ${((i + 1) % 2 == 0 ? 'oddRowBg' : '')}">
                <div>
                    <span>${exchanges[i].date.formatted}</span>
                </div>
                
                <div>
                    <span>${exchanges[i].pair.dsc}</span>
                </div>
                
                <div>
                    <span>${exchanges[i].type.dsc} ${exchanges[i].side.dsc}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${exchanges[i].qty.formatted}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${exchanges[i].price.formatted}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${exchanges[i].total.formatted}</span>
                </div>
            </div>
        `;
    }

    return rows;
}

function getSubtotals(rsp) {
    let rows = '';

    rows += `
        <div class="tableRowSubtotalsTx tableRowDetails tableRowPadding">
            <div class="subtotalTitle">
                <span>Depósitos Aprobados   Subtotal</span>
            </div>
            
            <div class="subtotalCurrenciesBox">
                ${currencyTotals(rsp.deposit)}
            </div>
            
        </div>
    `;

    rows += `
        <div class="tableRowSubtotalsTx tableRowDetails tableRowPadding">
            <div class="subtotalTitle">
                <span>Retiros Aprobados   Subtotal</span>
            </div>
            
            <div class="subtotalCurrenciesBox">
                ${currencyTotals(rsp.withdrawals)}
            </div>
            
        </div>
    `;

    rows += `
        <div class="tableRowSubtotalsTx tableRowDetails tableRowPadding">
            <div class="subtotalTitle">
                <span>Transferencias Aprobadas   Subtotal</span>
            </div>
            
            <div class="subtotalCurrenciesBox">
                ${currencyTotals(rsp.xfer)}
            </div>
            
        </div>
    `;

    return rows;
}

function currencyTotals(currencies) {
    let totals = '';

    for (let i = 0; i < currencies.length; i = 3 + i) {
        totals += `
            <div class="subtotalCurrenciesRow">
                <span class="currencyBoxDetails">${currencies.length > i ? `${currencies[i].amount.formatted}    ${currencies[i].currency.symbol}` : ''}</span>
                <span class="currencyBoxDetails">${currencies.length > i + 2 ? `${currencies[i + 1].amount.formatted}    ${currencies[i + 1].currency.symbol}` : ''}</span>
                <span class="currencyBoxDetails">${currencies.length > i + 3 ? `${currencies[i + 2].amount.formatted}    ${currencies[i + 2].currency.symbol}` : ''}</span>
            </div>
        `;
    }

    return totals;
}

function getMovements(records) {
    let rows = '';

    for (let i = 0; i < records.length; i++) {
        rows += `
            <div class="tableRowPadding tableRowDetails ${((i + 1) % 2 == 0 ? 'oddRowBg' : '')}">
            
                <div>
                    <span>${records[i].date.formatted}</span>
                </div>
                
                <div class="alignTextLeft">
                    <span>${records[i].type.dsc}</span>
                </div>
                
                <div>
                    <span>${records[i].account.currency.symbol}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${records[i].amount.formatted}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${determinateDestination(records[i])}</span>
                </div>
                
                <div>
                    <span>${(records[i].status == 1 ? 'Aprobado' : (records[i].status == 2 ? 'Rechazado' : 'Pendiente'))}</span>
                </div>
                
            </div>
        `;
    }

    return rows;
}

function determinateDestination(record) {
    if (record.type.id == 1) {
        if (record.account.realwallet != null) {
            return record.account.realwallet;
        } else {
            return "";
        }
    } else if (record.type.id == 2) {

        if (record.userpaymentmethod.bankid != undefined) {
            return record.userpaymentmethod.dsc;
        } else if (record.account.realwallet != null) {
            return record.account.realwallet;
        } else {
            return record.userpaymentmethod.paymentmethod.dsc;
        }

    } else if (record.type.id == 3) {
        if (record.amount.number < 0) {
            if (record.userpaymentmethod !== null && record.userpaymentmethod !== undefined)
                return record.userpaymentmethod.user.fullname;
            else
                return "";
        } else {
            return '';
        }
    } else {
        return '';
    }
    /*
    ${(records[i].userpaymentmethod.user != undefined ? 
                        ( records[i].userpaymentmethod.user.id != -1 ? records[i].userpaymentmethod.user.fullname : '') : 
                        }*/
}

function drawUserBalances(rsp) {

    /*Colocamos la cabecera*/
    document.getElementById('userDetailsAccounts').innerHTML = `
        <div class="tableDetails">
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Moneda</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Cantidad Disponible</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Cantidad Pendiente</span>
                </div>
                
                <div class="alignTextRight">
                    <span>Cantidad Total</span>
                </div>
                
                <div>
                    <span>Última Operación</span>
                </div>
                
                <div>
                    <span>Wallet</span>
                </div>
            </div>
            
            ${getAccountData(rsp.accounts)}
        </div>
    `;
}

function getAccountData(rsp) {
    let data = '';

    for (let i = 0; i < rsp.length; i++) {
        data += `
            <div class="tableRowPadding tableRowDetails ${((i + 1) % 2 == 0 ? 'oddRowBg' : '')}">
            
                <div>
                    <span>${rsp[i].currency.symbol}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${rsp[i].avaliable.formatted}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${rsp[i].committed.formatted}</span>
                </div>
                
                <div class="alignTextRight">
                    <span>${rsp[i].total.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp[i].lasttransaction.formatted}</span>
                </div>
                
                <div>
                    <span>${(rsp[i].wallet == null ? '' : rsp[i].wallet.dsc)}</span>
                </div>
                
            </div>
        `;
    }

    return data;
}

function drawUserRegisterCompany(rsp) {
    document.getElementById('userDetailsRegister').innerHTML = `
        <div class="tableDetails">
        
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos Básicos</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Tipo de Compañía</span>
                </div>
                
                <div>
                    <span>Número de Identificación</span>
                </div>
                
                <div>
                    <span>Fecha de Creación</span>
                </div>
                
                <div>
                    <span>País de Registro</span>
                </div>
                
                <div>
                    <span>Estado de Registro</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.company.type.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.document.dsc == null ? '' : rsp.company.document.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.datecreated.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.company.document.country.dsc == null ? '' : rsp.company.document.country.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.document.region.dsc == null ? '' : rsp.company.document.region.dsc}</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Ciudad de Registro</span>
                </div>
                
                <div>
                    <span>Código Postal</span>
                </div>
                
                <div>
                    <span>Teléfono</span>
                </div>
                
                <div>
                    <span>Sitio Web</span>
                </div>
                
                <div>
                    <span>Número de Socios</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.company.document.city.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.document.postalcode.value}</span>
                </div>
                
                <div>
                    <span>${rsp.company.phone}</span>
                </div>
                
                <div>
                    <span>${rsp.company.website}</span>
                </div>
                
                <div>
                    <span>${rsp.company.partnersnumber}</span>
                </div>
                
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos De Socios</span>
                </div>
            </div>
            
            ${getPartnersCompany(rsp.company.partners)}
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Dirección de Empresa</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>País</span>
                </div>
                
                <div>
                    <span>Estado</span>
                </div>
                
                <div>
                    <span>Ciudad / Municipio</span>
                </div>
                
                <div>
                    <span>Dirección</span>
                </div>
                
                <div>
                    <span>Casa/Apt</span>
                </div>
                
                <div>
                    <span>Código Postal</span>
                </div>
                
                <div>
                    <span>Sucursales</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.company.country.dsc == null ? '' : rsp.company.country.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.region.dsc == null ? '' : rsp.company.region.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.city.dsc == null ? '' : rsp.company.city.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.company.street}</span>
                </div>
                
                <div>
                    <span>${rsp.company.home}</span>
                </div>
                
                <div>
                    <span>${rsp.company.document.postalcode.value}</span>
                </div>
                
                <div>
                    <span>${rsp.company.branchoffices}</span>
                </div>
                
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Información Comercial</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Actividad Económica</span>
                </div>
                
                <div>
                    <span>Ingreso Anual</span>
                </div>
                
                <div>
                    <span>Patrimonio</span>
                </div>
                
                <div>
                    <span>Políticamente Expuesto</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
                
                <div>
                    <span>${rsp.company.economicalactivity}</span>
                </div>
                
                <div>
                    <span>${rsp.company.anualincome.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.company.patrimony.formatted}</span>
                </div>
                
                <div>
                    <span>${(rsp.company.politicalexposed == 1 ? 'Si' : 'No')}</span>
                </div>
                
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Soporte de Información</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                ${getHeaderImagesRegister(rsp.company.uploads)}
            </div>
            
            <div class="tableRowPadding tableRowDetails">
                ${getLinkImages(rsp.company.uploads)}
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos Transaccionales</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Cantidad (prom.) Depósitos y Retiros Mensuales</span>
                </div>
                
                <div>
                    <span>Volumen Promedio Mensual $US</span>
                </div>
                
                <div>
                    <span>Tipo de Operaciones</span>
                </div>
                
                <div>
                    <span>Relación con Grupo Económico</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
                
                <div>
                    <span>${rsp.company.qtyoperationsmothly}</span>
                </div>
                
                <div>
                    <span>${rsp.company.amooperationsmonthly.number}</span>
                </div>
                
                <div>
                    <span>${rsp.company.preferoptype.dsc}</span>
                </div>
                
                <div>
                    <span>${(rsp.company.economicrelation == 1 ? 'Si' : (rsp.company.economicrelation == 0 ? 'No' : ''))}</span>
                </div>
                
            </div>
            
        </div>
    `;
}

function getPartnersCompany(partners) {
    let rows = '';
    let count = 1;

    for (let i = 0; i < partners.length; i++) {
        if (partners[i].legalrep == 1) {
            rows += `
                <div class="tableRowPadding headerDetailCol">
                    <div>
                        <span>Nombre Representante Legal</span>
                    </div>
                    
                    <div>
                        <span>Cédula Representante Legal</span>
                    </div>
                    
                    <div>
                        <span>Teléfono Representante Legal</span>
                    </div>
                    
                    <div>
                        <span>Políticamente Expuesto</span>
                    </div>
                </div>
            `;
        } else {
            rows += `
                <div class="tableRowPadding headerDetailCol">
                    <div>
                        <span>Nombre Socio ${count}</span>
                    </div>
                    
                    <div>
                        <span>Cédula Socio ${count}</span>
                    </div>
                    
                    <div>
                        <span>Teléfono Socio ${count}</span>
                    </div>
                    
                    <div>
                        <span>Políticamente Expuesto</span>
                    </div>
                </div>
            `;

            count++;
        }

        rows += `
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${partners[i].name}</span>
                </div>
                
                <div>
                    <span>${partners[i].document}</span>
                </div>
                
                <div>
                    <span>${partners[i].phone}</span>
                </div>
                
                <div>
                    <span>${(partners[i].politicalexposed == '1' ? 'Si' : 'No')}</span>
                </div>
                
            </div>
        `;

        if (partners[i].politicalexposed == '1') {
            rows += `
                <div class="tableRowPadding headerDetailCol">
                    <div>
                        <span>Ente de Adscripción</span>
                    </div>
                    
                    <div>
                        <span>Cargo que Desempeña</span>
                    </div>
                    
                    <div>
                        <span>País</span>
                    </div>
                    
                    <div>
                        <span>Identificación del Relacionado</span>
                    </div>
                </div>
                <div class="tableRowPadding tableRowDetails">
            
                    <div>
                        <span>${partners[i].affiliationbody}</span>
                    </div>
                    
                    <div>
                        <span>${partners[i].positionheld}</span>
                    </div>
                    
                    <div>
                        <span>${partners[i].pepcountryid.dsc}</span>
                    </div>
                    
                    <div>
                        <span>${partners[i].peprelatedid}</span>
                    </div>
                    
                </div>
                `;
        }
    }

    return rows;
}

function drawUserRegisterPerson(rsp) {
    document.getElementById('userDetailsRegister').innerHTML = `
        <div class="tableDetails">
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos Básicos</span>
                </div>
            </div>
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Tipo de Documento</span>
                </div>
                
                <div>
                    <span>Número</span>
                </div>
                
                <div>
                    <span>País de Emisión</span>
                </div>
                
                <div>
                    <span>Fecha de Emisión</span>
                </div>
                
                <div>
                    <span>Fecha de Expiración</span>
                </div>
                
                <div>
                    <span>Sexo</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.person.document.type.dsc == null ? '' : rsp.person.document.type.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.document.dsc == null ? '' : rsp.person.document.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.document.country.dsc == null ? '' : rsp.person.document.country.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.document.datecreated.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.person.document.dateexpiration.formatted}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.gender == 'M' ? 'Masculino' : 'Femenino')}</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Fecha de Nacimiento</span>
                </div>
                
                <div>
                    <span>Estado Civil</span>
                </div>
                
                <div>
                    <span>Teléfono</span>
                </div>
                                
                <div>
                    <span>Ciudadano Americano</span>
                </div>
                
                <div>
                    <span>Ciudadano Venezolano</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.person.birthdate.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.person.maritalstatus.dsc == undefined ? '' : rsp.person.maritalstatus.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.phone}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.american == 1 ? 'Si' : 'No')}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.venezuelan == 1 ? 'Si' : 'No')}</span>
                </div>
                
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos de Residencia</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>País de Residencia</span>
                </div>
                
                <div>
                    <span>Estado</span>
                </div>
                
                <div>
                    <span>Ciudad / Municipio</span>
                </div>
                
                <div>
                    <span>Calle o Avenida</span>
                </div>
                                
                <div>
                    <span>Código Postal</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.person.country.dsc == null ? '' : rsp.person.country.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.region.dsc == null ? '' : rsp.person.region.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.city.dsc == null ? '' : rsp.person.city.dsc}</span>
                </div>
                
                <div>
                    <span>${rsp.person.street == null ? '' : rsp.person.street}</span>
                </div>
                                
                <div>
                    <span>${rsp.person.postalcode == null ? '' : rsp.person.postalcode}</span>
                </div>
                
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos Profesionales</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Profesión</span>
                </div>
                
                <div>
                    <span>Actividad Económica</span>
                </div>
                
                <div>
                    <span>Comerciante Ind.</span>
                </div>
                
                <div>
                    <span>Ocupación</span>
                </div>
                
                <div>
                    <span>Nombre de Empresa</span>
                </div>
                
                <div>
                    <span>Ingreso Anual</span>
                </div>
                
                <div>
                    <span>Patrimonio</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.person.profession}</span>
                </div>
                
                <div>
                    <span>${rsp.person.economicalactivity}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.independentdealer == 1 ? 'Si' : 'No')}</span>
                </div>
                
                <div>
                    <span>${rsp.person.ocupation}</span>
                </div>
                
                <div>
                    <span>${rsp.person.company}</span>
                </div>
                
                <div>
                    <span>${rsp.person.anualincome.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.person.patrimony.formatted}</span>
                </div>
                
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Políticamente Expuesto</span>
                </div>
                
                <div>
                    <span>Ente de Adscripción</span>
                </div>
                
                <div>
                    <span>Cargo que Desempeña</span>
                </div>
                
                <div>
                    <span>País</span>
                </div>
                
                <div>
                    <span>Identificación del Relacionado</span>
                </div>
                
            </div>
            
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${(rsp.person.politicalexposed == 1 ? 'Si' : 'No')}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.politicalexposed == 1 ? rsp.person.affiliationbody : '')}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.politicalexposed == 1 ? rsp.person.positionheld : '')}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.politicalexposed == 1 ? (rsp.person.pepcountryid.dsc == null ? '' : rsp.person.pepcountryid.dsc) : '')}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.politicalexposed == 1 ? rsp.person.peprelatedid : '')}</span>
                </div>
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Soporte de Información</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                ${getHeaderImagesRegister(rsp.person.uploads)}
            </div>
            
            <div class="tableRowPadding tableRowDetails">
                ${getLinkImages(rsp.person.uploads)}
            </div>
            
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Datos Transaccionales</span>
                </div>
            </div>
            
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Cantidad (prom.) Depósitos y Retiros Mensuales</span>
                </div>
                
                <div>
                    <span>Volumen Promedio Mensual $US</span>
                </div>
                
                <div>
                    <span>Tipo de Operaciones</span>
                </div>
                
                <div>
                    <span>Relación con Grupo Económico</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
                
                <div>
                    <span>${rsp.person.qtyoperationsmothly == null ? '' : rsp.person.qtyoperationsmothly}</span>
                </div>
                
                <div>
                    <span>${rsp.person.amooperationsmonthly.number == null ? '' : rsp.person.amooperationsmonthly.number}</span>
                </div>
                
                <div>
                    <span>${rsp.person.preferoptype.dsc}</span>
                </div>
                
                <div>
                    <span>${(rsp.person.economicrelation == 1 ? 'Si' : (rsp.person.economicrelation == 0 ? 'No' : ''))}</span>
                </div>
                
            </div>
                
        </div>
    `;
}

function getHeaderImagesRegister(uploads) {
    let rows = '';

    if (uploads != null) {
        for (let i = 0; i < uploads.length; i++) {
            rows += `
                <div>
                    <span>${uploads[i].dsc}</span>
                </div>
            `;
        }
    }

    return rows;
}

function getLinkImages(uploads) {
    let rows = '';

    if (uploads != null) {
        for (let i = 0; i < uploads.length; i++) {
            rows += `
                <div>
                    <a href="${uploads[i].url}" target="_blank">Ver Documento</a>
                </div>
            `;
        }
    }

    return rows;
}

function drawUserInfoPerson(rsp) {
    document.getElementById('userDetailsInfo').innerHTML = `
        <div class="tableDetails">
            <div class="headerDetailsRow tableRowPadding">
                <div class="notBorder">
                    <span>Registro de Usuario</span>
                </div>
            </div>
            <div class="tableRowPadding headerDetailCol">
                <div>
                    <span>Fecha Registro</span>
                </div>
                
                <div>
                    <span>Fecha Verificación</span>
                </div>
                
                <div>
                    <span>Último Acceso</span>
                </div>
                
                <div>
                    <span>Declaración Jurada</span>
                </div>
                
                <div>
                    <span>Nivel KYC</span>
                </div>
                
                <div>
                    <span>Nivel Riesgo</span>
                </div>
            </div>
            
            <div class="tableRowPadding tableRowDetails">
            
                <div>
                    <span>${rsp.datecreated}</span>
                </div>
                
                <div>
                    <span>${rsp.terms.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.lastsession.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.declaration.formatted}</span>
                </div>
                
                <div>
                    <span>${rsp.level.id}</span>
                </div>
                
                <div>
                    <span>${determinateRiskLevel(rsp.risklevel.id)}</span>
                </div>
                
            </div>
            <div class="headerDetailsRow tableRowPadding statementTitle">
                <div class="notBorder">
                    <span>Declaración Jurada de Usuario</span>
                </div>
            </div>
            <div class="tableRowPadding tableRowDetails" >
            
                <div class="statement">
                    <span>${getStatement(rsp)}</span>
                </div>
                
            </div>
        </div>
    `;
}

function getStatement(inf) {
    var statement = ""
    if (inf.declaration.date != '1970-01-01 00:00') {
        if (inf.person) {
            statement = "Yo " + inf.person.firstname + ' ';
            if (inf.person.secondname != null) {
                statement += inf.person.secondname + ' ';
            }
            statement += inf.person.firstlastname;
            if (inf.person.secondlastname != null) {
                statement += ' ' + inf.person.secondlastname;
            }
            statement += ', titular de la ' + inf.person.document.type.dsc;
            if (inf.person.document.type.dsc == 'Cédula') {
                statement += ' de Identidad'
            }
            statement += ' Nro. ' + inf.person.document.dsc

            if (inf.person.street) {
                statement += ', domiciliado en la Calle ' + inf.person.street
            }
            if (inf.person.city.dsc) {
                statement += ', en ' + inf.person.city.dsc
            }
            if (inf.person.country.dsc) {
                statement += ', en ' + inf.person.country.dsc
            }
            statement += ', declaro bajo fe de juramento que todos los datos y documentos suministrados son ciertos y fehacientes. Igualmente autorizo' +
                ' a la empresa Asesoría Financiera C.A. a efectos de verificar la veracidad de lo aquí declarado' +
                ', en cumplimiento con la providencia 044-2021 sobre normas relativas a la administración y fiscalización de los riesgos relacionados con la Legitimación de Capitales, el Financiamiento del Terrorismo y el Financiamiento de la Proliferación de Armas de Destrucción Masiva, aplicables a los Proveedores de Servicios de Activos Virtuales y a las personas y entidades que proporcionen productos y servicios a través de actividades que involucren Activos Virtuales, en el sistema integral de criptoactivos, emanada por la Superintendencia Nacional de Criptoactivos y Actividades Conexas (SUNACRIP) y publicado en la Gaceta Oficial número 42.110, en fecha 21 de abril del año 2021.' +
                '<br/><br/>' +
                'De esta misma forma declaro bajo fe de juramento, que los capitales, bienes, fondos, haberes, beneficios o criptoactivos, que sean depositados en la plataforma, durante todo el período que permanezca vigente la relación con la empresa Asesoría Financiera. IO, C.A., son provenientes de actividades legítimas. ' +
                'Por lo tanto, declaro que tienen una procedencia lícita, la cual puede ser corroborada por los organismos competentes y no tienen relación alguna con dinero, capitales, bienes, fondos, haberes, beneficios o criptoactivos que se consideren producto de actividades ilícitas o hechos típicos antijurídicos contemplados en la Ley Orgánica contra la Delincuencia Organizada y Financiamiento al Terrorismo publicada en Gaceta Oficial No 39.912 el 30 de abril de 2012, así como en lo establecido en la Ley Orgánica de Drogas publicada en Gaceta Oficial No 39.546 el 05 de noviembre de 2010.' +
                '<br/><br/>' + transformDate(inf.declaration)
            return statement
        } else if (inf.company) {
            statement = "Yo " + inf.company.partners[0].name + ' titular de la Cédula de Identidad Nro. ' + inf.company.partners[0].document + ' y de este domicilio'

            if (inf.company.street) {
                statement += ' ' + inf.company.street + ', en'
            }

            if (inf.company.city.dsc) {
                statement += ' ' + inf.company.city.dsc
            }
            if (inf.company.country.dsc) {
                statement += ', ' + inf.company.country.dsc
            }
            statement += '. En mi condición de Representante Legal de la empresa ' + inf.company.name +
                ' identificada con el número de registro de información fiscal RIF '
                + inf.company.document.dsc + '. <br/><br/>'
                + 'Declaro bajo Fe de Juramento: que todos los datos y documentos suministrados son ciertos y fehacientes, igualmente autorizo suficientemente a la empresa Asesoria' +
                ' Financiera .IO, C.A., a efecto de verificar la veracidad de lo aquí declarado' +
                ', en cumplimiento con la providencia 044-2021 sobre normas relativas a la administración y fiscalización de los riesgos relacionados con la Legitimación de Capitales, el Financiamiento del Terrorismo y el Financiamiento de la Proliferación de Armas de Destrucción Masiva, aplicables a los Proveedores de Servicios de Activos Virtuales y a las personas y entidades que proporcionen productos y servicios a través de actividades que involucren Activos Virtuales, en el sistema integral de criptoactivos, emanada por la Superintendencia Nacional de Criptoactivos y Actividades Conexas (SUNACRIP) y publicado en la Gaceta Oficial número 42.110, en fecha 21 de abril del año 2021.' +
                '<br/><br/>' +
                'De esta misma forma declaro bajo fe de juramento, que los capitales, bienes, fondos, haberes, beneficios o criptoactivos, que sean depositados en la plataforma, durante todo el período que permanezca vigente la relación con la empresa Asesoría Financiera. IO, C.A., son provenientes de actividades legítimas. ' +
                'Por lo tanto, declaro que tienen una procedencia lícita, la cual puede ser corroborada por los organismos competentes y no tienen relación alguna con dinero, capitales, bienes, fondos, haberes, beneficios o criptoactivos que se consideren producto de actividades ilícitas o hechos típicos antijurídicos contemplados en la Ley Orgánica contra la Delincuencia Organizada y Financiamiento al Terrorismo publicada en Gaceta Oficial No 39.912 el 30 de abril de 2012, así como en lo establecido en la Ley Orgánica de Drogas publicada en Gaceta Oficial No 39.546 el 05 de noviembre de 2010.' +

                '<br/><br/>' + transformDate(inf.declaration)


            return statement
        }
        else {
            return statement
        }
    }
    else {
        statement = 'No existe declaración jurada.'
        return statement
    }
}

function transformDate(date) {
    var months = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
    var dateObject = new Date(date.date);
    return ' A los ' + dateObject.getDate() + ' días del mes de ' + months[dateObject.getMonth()] + ' de ' + dateObject.getFullYear() + '.';
}

//A los '+f.getDate()+' días del mes de '+meses[f.getMonth()]+' de '+f.getFullYear()+'.';

function determinateRiskLevel(id) {

    switch (id) {
        case 0:
            return 'Bajo';
            break;
        case 1:
            return 'Moderado';
            break;
        case 2:
            return 'Alto';
            break;
        default:
            return 'Bajo';
    }
}

//************* BUSQUEDA INTELIGENTE *******************
function myUsers(value) {
    var par = {};
    par.filter = value;
    par.offset = 0;
    par.order = "1";
    par.numofrecords = 2000;
    par.sessionid = sessionId;
    callWS("GET", "appusers/list", par, rspUser);
    return 0;
}
function rspUser(status, rsp) {
    switch (status) {
        case 200:
            // console.log(JSON.parse(rsp));
            var resp = JSON.parse(rsp);
            var lista = document.getElementById("resultsC");
            var div = document.getElementById("searchResult");
            div.classList.remove("noShow");
            mySearchAddUser(lista, resp.records, resp.numofrecords);
            break;
        case 400:
            console.log(JSON.parse(rsp));
            break;
        case 401:
            msg.innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            msg.classList.add("msgError");
            msg.style.display = "block";
            setTimeout(function () {
                msg.classList.remove("msgError");
                myLogout()
                msg.style.display = "none";
            }, 3000);
            break;
        case 403:
            console.log(JSON.parse(rsp));
            break;
        case 500:
            var resSeller = JSON.parse(rsp);
            alert("Error 500 " + resSeller.msg);
            console.log(JSON.parse(rsp));
            break;
        default:
        //console.log(rsp);
    }
}
function mySearchAddUser(lista, data, num) {
    lista.innerHTML = "";
    if (num === 0) {
        var line = document.createElement("li");
        line.innerHTML = '<span class="smallRsp">No tenemos registros que coincidan con su busqueda.</span>';
        lista.appendChild(line);
    } else {
        for (navLink of data) {
            var line = document.createElement("li");
            line.classList.add("myNewLineUser");
            line.id = "user-" + navLink.id;
            line.innerHTML = '<p class="nameResult"> ' + navLink.usr + '</p>';
            lista.appendChild(line);
        }
    }
    document.querySelectorAll('[class="myNewLineUser"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id = element.id;
            var par = {};
            console.log(element.id);
            par.id = parseInt(id.split("-")[1]);
            par.sessionid = sessionId;
            callWS("GET", "appusers/entry", par, rspUserEntry);
        });
    });
}

function rspUserEntry(status, rsp) {
    switch (status) {
        case 200:
            console.log(JSON.parse(rsp));

            var resp = JSON.parse(rsp).entry;
            let ci = document.getElementById('doc');
            document.getElementById("emailUser").value = resp.usr;

            if (resp.company != null) {
                ci.value = resp.company.document.dsc.value;
            } else {
                ci.value = resp.person.document.dsc.value;
            }

            userSelected = resp.id;

            loadList();
            break;
        case 400:
            console.log(JSON.parse(rsp));
            break;
        case 401:
            msg.innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            msg.classList.add("msgError");
            msg.style.display = "block";
            setTimeout(function () {
                msg.classList.remove("msgError");
                myLogout()
                msg.style.display = "none";
            }, 3000);
            break;
        case 403:
            console.log(JSON.parse(rsp));
            break;
        case 500:
            var resSeller = JSON.parse(rsp);
            console.log(JSON.parse(rsp));
            break;
        default:
        //console.log(rsp);
    }
}

//************* BUSQUEDA INTELIGENTE POR CEDULA *******************
function myUsersByDoc(value) {
    var par = {};
    par.filter = value;
    par.offset = 0;
    par.order = "1";
    par.numofrecords = 2000;
    par.sessionid = sessionId;
    callWS("GET", "appusers/list", par, rspUserByDoc);
    return 0;
}
function rspUserByDoc(status, rsp) {
    switch (status) {
        case 200:
            // console.log(JSON.parse(rsp));
            var resp = JSON.parse(rsp);
            var lista = document.getElementById("resultsByDoc");
            var div = document.getElementById("searchResultByDoc");
            div.classList.remove("noShow");
            mySearchAddUserByDoc(lista, resp.records, resp.numofrecords);
            break;
        case 400:
            console.log(JSON.parse(rsp));
            break;
        case 401:
            msg.innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            msg.classList.add("msgError");
            msg.style.display = "block";
            setTimeout(function () {
                msg.classList.remove("msgError");
                myLogout()
                msg.style.display = "none";
            }, 3000);
            break;
        case 403:
            console.log(JSON.parse(rsp));
            break;
        case 500:
            var resSeller = JSON.parse(rsp);
            alert("Error 500 " + resSeller.msg);
            console.log(JSON.parse(rsp));
            break;
        default:
        //console.log(rsp);
    }
}
function mySearchAddUserByDoc(lista, data, num) {
    console.log(data);
    lista.innerHTML = "";
    if (num === 0) {
        var line = document.createElement("li");
        line.innerHTML = '<span class="smallRsp">No tenemos registros que coincidan con su busqueda.</span>';
        lista.appendChild(line);
    } else {
        for (navLink of data) {
            var line = document.createElement("li");
            line.classList.add("myNewLineUser");
            line.id = "user-" + navLink.id;
            line.innerHTML = '<p class="nameResult"> ' + (`${navLink.doc} - ${navLink.fullname}`) + '</p>';

            lista.appendChild(line);
        }
    }
    document.querySelectorAll('[class="myNewLineUser"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id = element.id;
            var par = {};
            console.log(element.id);
            par.id = parseInt(id.split("-")[1]);
            par.sessionid = sessionId;
            callWS("GET", "appusers/entry", par, rspUserEntry);
        });
    });
}

function rspUserEntry(status, rsp) {
    switch (status) {
        case 200:
            console.log(JSON.parse(rsp));

            var resp = JSON.parse(rsp).entry;
            let ci = document.getElementById('doc');
            document.getElementById("emailUser").value = resp.usr;

            if (resp.company != null) {
                ci.value = resp.company.document.dsc.value;
            } else {
                ci.value = resp.person.document.dsc.value;
            }

            userSelected = resp.id;

            loadList();
            break;
        case 400:
            console.log(JSON.parse(rsp));
            break;
        case 401:
            msg.innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            msg.classList.add("msgError");
            msg.style.display = "block";
            setTimeout(function () {
                msg.classList.remove("msgError");
                myLogout()
                msg.style.display = "none";
            }, 3000);
            break;
        case 403:
            console.log(JSON.parse(rsp));
            break;
        case 500:
            var resSeller = JSON.parse(rsp);
            console.log(JSON.parse(rsp));
            break;
        default:
        //console.log(rsp);
    }
}

function printSection(name) {

}

function printDiv() {
    console.log(globalurl);
    let divContents = document.getElementById(`serviceTable`).innerHTML;
    var printWindow = window.open('', '', 'height=400,width=800');

    let urlParams = new URLSearchParams(window.location.search);
    console.log(urlParams);

    printWindow.document.write(`
        <html>
            <head>
                <title>Expediente Usuario ${userEmail}</title>
                <link rel="stylesheet" href="${globalurl}/css/menu.css?v=10">
                <link rel="stylesheet" href="${globalurl}/css/menu/inform2.css?v=10">
                <link rel="stylesheet" href="${globalurl}/css/main.css?v=10">
                <link rel="stylesheet" href="${globalurl}/css/fonts.css?v=10">
                <link href="${globalurl}/css/font-awesome/all.css" rel="stylesheet">
                <style>
                    .showInPrint{
                        display: none;
                    }
                    
                    .headerBoxPrint{
                        display: flex;
                        flex-direction: row;
                        justify-content: space-between;
                        color: #4A4A4A;
                        font-family: Roboto;
                        font-size: 14px;
                    }
                    
                    .titlePrint{
                        color: #4A4A4A;
                        font-family: Roboto;
                        font-size: 24px;
                        line-height: 25px;
                        font-weight: bold;
                        text-align: center;
                        margin: 30px 0px;
                    }
                    
                    .colTextEndPrint{
                        display: flex;
                        flex-direction: column;
                        align-items: flex-end;
                        justify-content: center;
                    }
                    
                    .colTextStartPrint{
                        display: flex;
                        flex-direction: column;
                        align-items: flex-start;
                        justify-content: center;
                    }
                    
                    .imageSizePrint{
                        height: 120px;
                        width: 140px;
                        margin-right: 15px;
                    }
                    
                    .tableInf {
                        display: table;
                        width: 94%;
                        padding: 0px !important;
                        margin: auto;
                        margin-top: 5px;
                        margin-bottom: 10px;
                    }
                </style>
            </head>
            <body>
            
                <div class="headerBoxPrint" style="padding: 0px 20px;">
                    <div class="headerBoxPrint">
                        <img src="${globalurl}/./settings/img/logo-email.png" 
                            class="imageSizePrint" alt='AFX Exchange Logo'/>
                        <div class="colTextStartPrint">
                            <span><b>Asesoría Financiera IO, C.A.</b></span>
                            <span>J - 30252203-0</span>
                        </div>
                    </div>
                    
                    <div class="colTextEndPrint">
                        <span>Emitido el ${dateToday()} por:</span>
                        <span><b>${urlParams.get('userName')}</b></span>
                    </div>
                    
                </div>
                
                <h1 class="titlePrint">EXPEDIENTE DIGITAL DE USUARIO PERSONA ${(userType == 1 ? 'NATURAL' : 'JURÍDICO')}</h1>
                
                ${divContents}
                <script>
                    window.onload = function(){
                        
                        // Obtenemos los que tengan la clase pa no mostrar
                        let divs = document.getElementsByClassName('showInPrint');
                        
                        
                        for(let i = 0; i < divs.length; i++){
                            divs[i].style.display = 'none';
                        }
                        
                        window.print();
                    }
                </script>
            </body>
        </html>
    `);
    printWindow.document.close();
    //printWindow.print();
}
