<?php
// pay/api/app/home
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $out->user = new stdClass();
    
    if(isset($_GET['sessionid']) && $_GET['sessionid'] != ''){
        //Validamos la session
        $sql = "SELECT payusers.userid AS id, ".
        "       GROUP_CONCAT(IF(userpersons.fname IS NULL, ".
        "           CONCAT(usercompanies.name, ".
        "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
        "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
        "       ) SEPARATOR '|') AS name ".
        "       FROM payusers ".
        "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
        "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
        "       WHERE payusers.sessionid ='".$_GET['sessionid']."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
    
        if($row['id'] != null){
            
            $userid = isSessionValidPAY($db, $_GET['sessionid']);

            $out->user->id = (int)$row['id'];
            $out->user->fullname = $row['name'];
            
            $sql = "SELECT avatarimgtype FROM payusers WHERE userid = ".$out->user->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $row = $res->fetch_assoc();
            
            if ($row['avatarimgtype'] != null) {
                $out->user->avatar = new stdClass();
                //Buscamos el archivo para obtener su nombre y extension
                $filestest = glob("../../../uploads/users/".$out->user->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                
                //El primer resultado
                $info = pathinfo($filestest[0]);
                
                if($info['basename'] != ""){
                    $out->user->avatar = new stdClass();
                    $out->user->avatar->type = $row['imagetype'];
                    $out->user->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$_GET['sessionid'];
                }else{
                    $out->user->avatar = null;
                }
            } else {
                $out->user->avatar = null;
            }
        }else{
            $out->user->id = 0;
        }
    }else{
        $out->user->id = 0;
    }
    
    // numero de horas a devolver para la grafica (max 24)
    $lasthours = 10;
    
    $graph= "SELECT      HREF.pairid, GROUP_CONCAT(IFNULL(O.price, '--')) price ".
            "FROM        ( ".
            "            SELECT P.id pairid, l24.ref h FROM (SELECT * FROM pairs WHERE status=1) P, (SELECT DATE_FORMAT((@now := DATE_SUB(@now, INTERVAL 1 HOUR)), '%Y%m%d%H') ref FROM cities, (SELECT @now := DATE_ADD(NOW(), INTERVAL 1 HOUR)) AS tt limit ".$lasthours.") l24 ".
            "            ) HREF ".
            "LEFT JOIN   ( ".
            "SELECT		O.pairid, DATE_FORMAT(T.datecreated, '%Y%m%d%H') h, O.price  ".
            "FROM		orders O   ".
            "INNER JOIN	transactions T  ".
            "ON			O.id=T.orderid  ".
            "WHERE		T.id IN  ".
            "( ".
            "SELECT		MAX(T.id) tid  ".
            "FROM		transactions T   ".
            "INNER JOIN	orders O   ".
            "ON			T.orderid=O.id  ".
            "WHERE		T.id IN  ".
            "			(  ".
            "			SELECT 		MIN(T.id) tid  ".
            "			FROM 		transactions T   ".
            "			INNER JOIN	orders O  ".
            "			ON			T.orderid=O.id  ".
            "            WHERE		T.datecreated > DATE_SUB(NOW(), INTERVAL 1 DAY) ".
            "            GROUP BY    O.id  ".
            "			)  ".
            "GROUP BY	O.pairid, DATE_FORMAT(T.datecreated, '%Y%m%d%H') ".
            ") ".
            ") O ".
            "ON			HREF.pairid = O.pairid ".
            "AND         HREF.h = O.h ".
            "GROUP BY	HREF.pairid ".
            "ORDER BY	HREF.pairid, HREF.h ";


    $lst24= "SELECT		O.pairid, O.price ".
            "FROM		orders O  ".
            "INNER JOIN	transactions T ".
            "ON			O.id=T.orderid ".
            "WHERE		T.id IN ".
            "            ( ".
            "            SELECT		MAX(T.id) tid ".
            "            FROM		transactions T  ".
            "            INNER JOIN	orders O  ".
            "            ON			T.orderid=O.id ".
            "            WHERE		T.id IN ".
            "            			( ".
            "            			SELECT 		MIN(T.id) tid ".
            "            			FROM 		transactions T  ".
            "            			INNER JOIN	orders O ".
            "            			ON			T.orderid=O.id ".
            "                       WHERE		T.datecreated <= DATE_SUB(NOW(), INTERVAL 1 DAY) " .
            "                       GROUP BY    O.id ".
            "            			) ".
            "            GROUP BY	O.pairid ".
            "            )";
    
    $lstp = "SELECT		O.pairid, O.price ".
            "FROM		orders O  ".
            "INNER JOIN	transactions T ".
            "ON			O.id=T.orderid ".
            "WHERE		T.id IN ".
            "            ( ".
            "            SELECT		MAX(T.id) tid ".
            "            FROM		transactions T  ".
            "            INNER JOIN	orders O  ".
            "            ON			T.orderid=O.id ".
            "            WHERE		T.id IN ".
            "            			( ".
            "            			SELECT 		MIN(T.id) tid ".
            "            			FROM 		transactions T  ".
            "            			INNER JOIN	orders O ".
            "            			ON			T.orderid=O.id ".
            "                       GROUP BY    O.id ".
            "            			) ".
            "            GROUP BY	O.pairid ".
            "            )";
    
    
    $ask =  "SELECT		O.pairid, MIN(O.price) price ".
            "FROM       orders O ".
            "LEFT JOIN	(SELECT		T.orderid, T.accountid, SUM(T.amount) ABO ".
            "           FROM		transactions T  ".
            "           WHERE		T.amount < 0 ".
            "           GROUP BY	T.orderid, T.accountid) T ".
            "ON			O.id=T.orderid ".
            "AND		O.accountid=T.accountid ".
            "WHERE		O.canceled IS NULL ".
            "AND		O.side=1 ".
            "AND		O.quantity+IFNULL(T.ABO,0) <> 0 ".
            "GROUP BY	O.pairid";

    $bid =  "SELECT		O.pairid, MAX(O.price) price ".
            "FROM       orders O ".
            "LEFT JOIN	(SELECT		T.orderid, T.accountid, SUM(T.amount) ABO ".
            "           FROM		transactions T  ".
            "           WHERE		T.amount > 0 ".
            "           GROUP BY	T.orderid, T.accountid) T ".
            "ON			O.id=T.orderid ".
            "AND		O.paymentid=T.accountid ".
            "WHERE		O.canceled IS NULL ".
            "AND		O.side=2 ".
            "AND		O.quantity-IFNULL(T.ABO,0) <> 0 ".
            "GROUP BY	O.pairid";


    $volume =   "SELECT     O.pairid, A.currencyid acccurid, ".
                "           SUM(T.amount) AS transactionamount ".
                "FROM       transactions T ".
                "INNER JOIN orders O ".
                "ON         T.orderid=O.id ".
                "INNER JOIN accounts A ".
                "ON         T.accountid=A.id ".
                "WHERE      T.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
                "GROUP BY   O.pairid, A.currencyid";
    
    $sql =  "SELECT 	P.id AS pairsid, " .
            "           P.refcurrencyid AS pairsrefcurrency,  ".
            "           C.name AS currencyname, ".
            "           C.symbol AS currencysymbol, ".
            "           C.icon AS currencyicon, ".
            "           C.decimals AS currencydecimals, ".
            "           C.id AS currencyid, ".
            "           CR.name AS refcurrencyname, ".
            "           CR.symbol AS refcurrencysymbol, ".
            "           CR.icon AS refcurrencyicon, ".
            "           CR.decimals AS refcurrencydecimals, ".
            "           IFNULL(V.transactionamount, 0) transactionamount, ".
            "           IFNULL(A.price, 0) askprice, ".
            "           IFNULL(B.price, 0) bidprice, ".
            "           IFNULL(L.price, 0) lastprice, ".
            "           IFNULL(D.price, 0) lastprice24, ".
            "           IFNULL(G.price, 0) graph ".
            "FROM 		pairs P ".
            "INNER JOIN currencies C ".
            "ON			C.id = P.currencyid ".
            "INNER JOIN currencies CR ".
            "ON			P.refcurrencyid= CR.id ".
            "LEFT JOIN  (".$volume.") V ".
            "ON         V.pairid=P.id ".
            "AND        V.acccurid=P.refcurrencyid ".
            "LEFT JOIN  (".$ask.") A ".
            "ON         A.pairid=P.id " .
            "LEFT JOIN  (".$bid.") B ".
            "ON         B.pairid=P.id " .
            "LEFT JOIN  (".$lstp.") L ".
            "ON         L.pairid=P.id " .
            "LEFT JOIN  (".$lst24.") D ".
            "ON         D.pairid=P.id " .
            "LEFT JOIN  (".$graph.") G ".
            "ON         G.pairid=P.id " .
            "WHERE 		P.status = 1 " .
            "ORDER BY   P.id";

    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($pairdata = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int) $pairdata["pairsid"];
        
        $record->pair = $pairdata['refcurrencysymbol'].'/'.$pairdata['currencysymbol'];
        
        $record->basecurrency = new stdClass();
        $record->basecurrency->id = (int)$pairdata['pairsrefcurrency'];
        $record->basecurrency->symbol = $pairdata['refcurrencysymbol'];
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";
        
        //$record->basecurrency->test = $pairdata['refcurrencyicon'];
        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $record->basecurrency->url = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $pairdata['refcurrencyicon']) {
                    $record->basecurrency->url = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $record->basecurrency->url = null;
        }

        $record->volume = new stdClass();
        $record->volume->number = (float)number_format($pairdata["transactionamount"], $pairdata["refcurrencydecimals"], '.','');
        $record->volume->formatted = numberFormatt($record->volume->number,$pairdata["refcurrencydecimals"]);
        
        $record->ask = new stdClass();
        $record->ask->number = (float)number_format($pairdata['askprice'], $pairdata["decimals"], '.','');
        $record->ask->formatted = numberFormatt($record->ask->number,$pairdata["decimals"]);
    
        $record->bid = new stdClass();
        $record->bid->number = (float)number_format($pairdata['bidprice'],$pairdata["decimals"],'.','');
        $record->bid->formatted = numberFormatt($record->bid->number,$pairdata["decimals"]);

        $record->lastprice = new stdClass();
        $record->lastprice->number = (float)number_format($pairdata["lastprice"], $pairdata["currencydecimals"], '.','');
        $record->lastprice->formatted = numberFormatt($record->lastprice->number,$pairdata["currencydecimals"]);
        
        $record->change = new stdClass();
        
        if($record->lastprice->number == 0){
            $record->change->number = 0;
            $record->change->formatted = numberFormatt($record->change->number,2)."%";
        }else{
            if($row['transactionamount'] > 0){
                $record->change->number = (($record->lastprice->number - $pairdata['lastprice24'])*100)/$pairdata['lastprice24'] ;
                $record->change->formatted = numberFormatt($record->change->number,2)."%";
            }else{
                $record->change->number = 0;
                $record->change->formatted = numberFormatt($record->change->number,2)."%";
            }
        }
        
        $record->period = "Ultimas 24h";
        
        $prices = explode(",", $pairdata["graph"]);
        $historical = array();
        $last = $record->lastprice->number;
        
        foreach ($prices as $price){
            if ($price != "--")
                $last = (float)$price;
            $historical[] = $last;
        }
        $record->historical = $historical;
        $pairs [] = $record;
    }
    
    $out->pairs = $pairs;
    
    // Obtenemos las noticias
    $sql = "SELECT * FROM paynews";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($news = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$news['id'];
        
        $record->title = new stdClass();
        $record->title->text = $news['title'];
        $record->title->color = $news['titcolor'];
        $record->title->font_size = $news['titsize'];
        
        $record->content = new stdClass();
        $record->content->text = $news['content'];
        $record->content->color = $news['concolor'];
        $record->content->font_size = $news['consize'];
        
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/news/".$record->id.".{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $record->background = new stdClass();
            $record->background->image = "";
            $record->background->color = $news['baccolor'];
        }else{
            $record->background = null;
        }
        
        $dateconverted = strtotime($news['createddate']);
        
        $record->createddate = new stdClass();
        $record->createddate->date = date('Y-m-d H:i', $dateconverted);

        $record->createddate->formatted = date('j', $dateconverted)." de ".determinateMonthEsp(date('n', $dateconverted))." de " .date('Y', $dateconverted)." - ".date('g:i a', $dateconverted);
        
        $newsArr [] = $record;
    }
    
    $out->news = $newsArr;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>