<?php
//pay/api/login/recover
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include_once("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("hash","pwd");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Definimos las variables y guardamos los datos recibidos por GET
    $hash = $_GET["hash"];
    $pwd = $_GET["pwd"];
    $out = new stdClass();
    
    $sql = "SELECT userid FROM payusers WHERE sessionid = '".$hash."'";
    if (!$rs=$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $user = $rs->fetch_assoc();
    
    $sql =  "UPDATE users " .
            "SET    pwd = '" . $pwd . "', ".
            "       sessionid = NULL, ".
            "       pwdexpiration = DATE_ADD(NOW(), INTERVAL 1 YEAR), ".
            "       status = 1 ".
            "WHERE  sessionid='".$hash."'";
    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    if ($db->affected_rows == 0){
        badEnd("401", array("msg"=>"Hash incorrecto"));
    }
    
    // Retornamos mensaje de que todo fue exitoso
    $out->msg = "Contraseña cambiada satisfactoriamente";
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT users.usr AS email, IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name, ".
    "       IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone, " .
    "       users.level AS level, users.lang AS lang ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE id = ".$user['userid'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $userdata = $rs->fetch_assoc();
    
    try {
        
        // incluir auditoria
        $sql = "INSERT INTO audit (application, module, userid, dsc, ipaddress) " .
               "VALUES            ('APP','USUARIOS APP', '" .$user['userid']. "', 'Se cambio la clave del usuario ".strtolower($userdata['email'])."', NULL)";
        if (!$db->query($sql)){
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
        
    } catch (Exception $e){
        die();
    }
    
    // Consultamos los datos del mensaje
    $sql = "SELECT * FROM cmsmessages WHERE id = 11";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $data = $rs->fetch_assoc();
    
    // Validamos que el usuario tenga las notificaciones activas
    $sql = "SELECT * FROM usermessages ".
    "       WHERE categoryid = ".$data['category'].
    "       AND usrid = ".$user['userid'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userPref = $rs->fetch_assoc();
    
    if($userPref['email'] == null || $userPref['email'] == 1){
        $subject = $data['name_esp'];
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = 
        "       <div style='background-color: #F8F8FA;padding: 20px;'>".
        "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/settings/img/logo-email.png'/>".
        "           <div style='margin: auto; display: block;background-color: #FFF;border-radius: 22px;width: 60%;padding:30px;'>".
        "               <h1 class='goodText' style='color:#474C58;text-align:center;font-size: 20px;font-weight: bold;'>Hola ".$userdata['name']."</h1>".
        "               <p class='goodText' style='font-size: 18px;color: #474C58;text-align:center;margin-bottom:30px;margin-left:20px;margin-right:20px;'>".$data['dsc_esp']."</p>".
        "           </div>".
        "           <p class='copy' style='margin-top:40px; color: #767E93;text-align:center;'>".$footerEmails."</p>".
        "       </div>";
        
        enviarCorreo2($fromeMail, strtolower($userdata['email']), $subject, $body);
    }
    // Se valida la preferenca del mensaje y se envía según el idioma
    if($userPref['sms'] == null || $userPref['sms'] == 1){
        $msg = $data['sms_esp'];
        enviarSMS($userdata['phone'], $msg);
    }
    
    if($userPref['system'] == null || $userPref['system'] == 1){
        
        $email = '';
        $sms = '';
        
        // Si se envia por correo obtenemos el correo del usuario
        if($userPref['email'] == null || $userPref['email'] == 1){
            $sql = "SELECT usr ".
            "       FROM users ".
            "       WHERE id = ".$user['userid'];
            if (!$resPref=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                    
            $rowPrefCom = $resPref->fetch_assoc();
            
            $email = $rowPrefCom['usr'];
        }
        
        // SI se envia por sms, obtenemos el numero del usuario
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
            "       FROM users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE users.id = ".$user['userid'];
            if (!$resPref=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $rowPrefCom = $resPref->fetch_assoc();
            
            $sms = $rowPrefCom['phone'];
            
        }
                        
        // Enviamos el mensaje por la mensajeria interna
        $msg = $data['dsc_esp'];
        saveInternalMsg($db, $msg, $user['userid'], $email, $sms);
    }
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>


