<?php
//pay/api/payment/execute
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('txidcrc');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $txid = $_GET['txidcrc'];
    $notes = '';
    $rate = 1;
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer transferencias
    isLevelValid($db, $userid);
    
    if(isset($_GET['notes']) && $_GET['notes'] != ''){
        $notes = $_GET['notes'];
    }
    
    // Validamos que exista el movimiento
    $sql = "SELECT COUNT(id) AS qty FROM transactions ".
    "       WHERE CONCAT(LPAD(id,'8','0'),RIGHT(CRC32(LPAD(id,'8','0')), 2)) = ".$txid.
    "       AND paypending = 1".
    "       AND validthru IS NOT NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        badEnd("404", array("msg"=>"Cobro no encontrado"));
    }
    
    // Obtenemos el movimiento de cobro
    $sql = "SELECT transactions.id AS txid, ".
    "       payusers.userid AS userid, ".
    "       payusers.receivecurrencies AS receivecurrencies, ".
    "       payusers.avatarimgtype AS avatartype, ".
    "       IF(transactions.amountghost = 0, transactions.amount, transactions.amountghost) AS amountrx, ".
    "       currencies.id AS currencyrxid, ".
    "       currencies.symbol AS currencyrxsymbol, ".
    "       currencies.name AS currencyrxname, ".
    "       currencies.decimals AS currencyrxdecimals, ".
    "       currencies.icon AS currencyrxicon, ".
    "       paytxdetails.amounttx AS amounttx, ".
    "       paytxdetails.currencytx AS currencytxid, ".
    "       accounts.id AS accountdestid, ".
    "       IF(userpersons.fname IS NULL, ".
    "           CONCAT(usercompanies.name, ".
    "               IF(usercompanies.comercialname IS NULL, ".
    "                   '',".
    "                   CONCAT('/',usercompanies.comercialname)".
    "               )".
    "           ), ".
    "           CONCAT(userpersons.fname, ".
    "               IF(userpersons.sname IS NULL OR userpersons.sname = '',".
    "                   '',".
    "                   CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname))".
    "               )".
    "       ) AS username ".
    "       FROM transactions, accounts, currencies, paytxdetails, payusers ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       WHERE CONCAT(LPAD(transactions.id,'8','0'),RIGHT(CRC32(LPAD(transactions.id,'8','0')), 2)) = ".$txid.
    "       AND accounts.id = transactions.accountid".
    "       AND accounts.userid = payusers.userid".
    "       AND accounts.currencyid = currencies.id".
    "       AND transactions.paypending = 1".
    "       AND paytxdetails.transactionid = transactions.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $txdata = $rs->fetch_assoc();
    
    // Obtenemos el correo del usuario
    $sql = "SELECT usr FROM users ".
    "       WHERE id = ".$txdata['userid'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $userdesdata = $rs->fetch_assoc();
    
    // Obtenemos la cuenta del usuario
    $sql = "SELECT accounts.currencyid AS accurrencyid, ".
    "       accounts.id AS accountid ".
    "       FROM accounts, payusers ".
    "       WHERE accounts.userid = payusers.userid ".
    "       AND payusers.sessionid = '".$sessionid."' ".
    "       AND accounts.paymentmethodid = -1 ".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = ".$txdata['currencyrxid'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdataor = $rs->fetch_assoc();
    
    if($accountdataor['accountid'] == $txdata['accountdestid']){
        badEnd("403",array("msg"=>"No puedes pagar a si mismo"));
    }
    
    $currencyid = $txdata['currencyrxid'];
    
    if($accountdataor['accountid'] == null){
        badEnd("500",array("msg"=>"accountid no encontrado"));
    }
    
    $sql = "SELECT * FROM currencies ".
    "       WHERE id = ".$accountdataor["accurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currencydata = $rs->fetch_assoc();
    
    $rate = determinateRate($db, $txdata['currencyrxid'], $currencyid, $currencydata['decimals']);
    //CORREGIDO BUG VALOR USADO '$rate->price' (empty) VALOR REAL '$rate->number' - JR
    $realamount = number_format($txdata['amountrx'] * $rate->number, $currencydata['decimals'], '.', '');
    $amount = $realamount;
    
    $sql = "SELECT SUM(amount) - ABS(IF(( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountdataor['accountid'].
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1) IS NOT NULL,  ".
	"               ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountdataor['accountid'].
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountdataor['accountid'].
    "           AND orders.accountid = ".$accountdataor['accountid'].
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0 ".
	"           AND orders.type != 1) IS NOT NULL, ( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountdataor['accountid'].
    "           AND orders.accountid = ".$accountdataor['accountid'].
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0 ".
	"           AND orders.type != 1),0) ".
	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"           FROM transactions  ".
	"           WHERE transactions.paypending = 1".
	"           AND transactions.accountid = ".$accountdataor['accountid'].
	"           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"           (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"           FROM transactions  ".
	"           WHERE transactions.paypending = 1".
	"           AND transactions.accountid = ".$accountdataor['accountid'].
	"           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"      ) as qty FROM transactions WHERE accountid = ".$accountdataor['accountid'].
    "       AND paypending = 0";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $balancetx = $res->fetch_assoc();
    
    if(number_format($balancetx["qty"], $currencydata['decimals'], '.', '') <= 0 || number_format($balancetx["qty"], $currencydata['decimals'], '.', '') < $realamount){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    //Consultamos la cuenta que tiene la moneda del xfer de AFX
    $sql = "SELECT * FROM accounts WHERE userid = -1".
    "       AND currencyid = ".$currencyid.
    "       AND paymentmethodid = -4";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currencyid.
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    //Validamos que el monto sea mas que el minimo aceptado
    if(validateMin($currencyid,$userdata["type"], 2, $db, $amount)){
        badEnd("403", array("msg"=>"A:".($txdata['amountrx'])." R: ".($rate->price)." Monto:".$amount." - Monto m&iacute;nimo autorizado: ".numberFormatt($fee['minxfer'], $currencydata['decimals'])));
    }
    
    //Calculamos el monto real quitandole la comision
    if($fee["pctfeexfer"] != null || $fee["nmlfeesxfer"] != null ){
        if($fee["pctfeexfer"] == null){
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$currencyid.
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'nmlfeesxfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $realfee = number_format($amount - ($amount - ($fee["nmlfeesxfer"] - ($fee["nmlfeesxfer"]/100 * $userExg['exonerated']) )), $currencydata['decimals'], '.', '');
            $realamount = number_format($realamount - $realfee, $currencydata['decimals'], '.', '');
        }else{
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$currencyid.
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'pctfeexfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $realfee = number_format((($fee["pctfeexfer"] - ($fee["pctfeexfer"]/100 * $userExg['exonerated']) )*$amount)/100, $currencydata['decimals'], '.', '');
            $realamount = number_format($realamount - $realfee, $currencydata['decimals'], '.', '');
        }
    }else{
        $realfee = 0;
        $realamount = number_format($realamount - $realfee, $currencydata['decimals'], '.', '');
    }
    
    if($realamount <= 0){
        badEnd("403", array("msg"=>"Total neto no puede ser menor o igual a 0"));
    }
    
    validateOperationsPay($db, $accountdataor['accountid'], $userid, $amount, 3);
    
    $db->autocommit(FALSE);
    
    // Actualizamos los datos del movimiento
    $sql = "UPDATE transactions SET ".
    "       paypending = 0, ".
    "       validthru = NULL, ".
    "       validator = NULL, ".
    "       accountorigin = ".$accountdataor['accountid'].", ".
    "       amount = ".$realamount.", ".
    "       amountghost = 0 ".
    "       WHERE id = ".$txdata['txid'].
    "       AND paypending = 1";
    if (!$rs=$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500",array("msg"=>$error));
    }
    
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0){
        $db->rollback();
        $db->close();
        badEnd("403", array("msg"=>"Cobro ya ejecutado"));
    }
    
    // Insertamos el pago
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       accountorigin, ".
    "       validator, ".
    "       validthru, ".
    "       txid, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Pago PAY a ".$userdesdata['usr']."', ".
    "       ".$accountdataor['accountid'].", ".
    "       0, ".
    "       -".$realamount.", ".
    "       ".$txdata['accountdestid'].", ".
    "       ".$accountdataor['accountid'].", ".
    "       NULL, ".
    "       NULL, ".
    "       ".$txdata['txid'].", ".
    "       0".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500",array("msg"=>$error));
    }
    
    //insertamos el fee de la transferencia del pago
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Pago PAY', ".
    "       ".$accountdataor['accountid'].", ".
    "       ".$txdata['txid'].", ".
    "       ".$accountdataor['accountid'].", ".
    "       -".$realfee.", ".
    "       0, ".
    "       ".$afxdata["id"].", ".
    "       NULL, ".
    "       NULL".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."222"));
    }
    
    //insertamos el fee de la transferencia
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Pago PAY', ".
    "       ".$afxdata["id"].", ".
    "       ".$txdata['txid'].", ".
    "       ".$accountdataor['accountid'].", ".
    "       0, ".
    "       ".$realfee.", ".
    "       ".$afxdata["id"].", ".
    "       NULL, ".
    "       NULL".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."333"));
    }
    
    //Guardamos el id de la transaccion de deposito
    $out->txid = (int)$db->insert_id;
    
    // Insertamos los detalles del pago
    $sql = "INSERT INTO paytxdetails(".
    "       transactionid, ".
    "       amounttx, ".
    "       currencytx, ".
    "       notes)".
    "       VALUES(".
    "           ".$out->txid.", ".
    "           ".$realamount.", ".
    "           ".$currencyid.", ".
    "           '".$notes."'".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500",array("msg"=>$error));
    }
    
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAuditPAY($db, "OPERACIONES", $sessionid, "APP", "Se registró un pago por ".$realamount." (".$out->txid.") en ".$currencydata['name'].", del usuario ".$userdataaudit['name'], $ipaddress);
    
    $db->commit();
    
    $db->autocommit(TRUE);
    
    $out->rectxid = (int)$txdata['txid'];
    
    // Receptor
    $out->receiver = new stdClass();
    $out->receiver->id = (int)$txdata['userid'];
    $out->receiver->name = $txdata['username'];
    
    if ($txdata['avatartype'] != null) {
        $out->receiver->avatar = new stdClass();
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/users/".$out->receiver->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $out->receiver->avatar = new stdClass();
            $out->receiver->avatar->type = $txdata['avatartype'];
            $out->receiver->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
        }else{
            $out->receiver->avatar = null;
        }
    } else {
        $out->receiver->avatar = null;
    }
    
    // Transaccion
    $sql = "SELECT * FROM currencies WHERE id = ".$txdata['currencytxid'];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $currtx = $res->fetch_assoc();
    
    $out->transaction = new stdClass();
    
    $out->transaction->amount = new stdClass();
    $out->transaction->amount->number = (float)$txdata['amounttx'];
    $out->transaction->amount->formatted = numberFormatt($out->transaction->amount->number, $currtx['decimals']);
    
    $out->transaction->currency = new stdClass();
    $out->transaction->currency->id = (int)$currtx['id'];
    $out->transaction->currency->name = $currtx['name'];
    $out->transaction->currency->symbol = $currtx['symbol'];
    $out->transaction->currency->decimals = $currtx['decimals'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    //$record->basecurrency->test = $pairrefdata['icon'];
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->transaction->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $currtx['icon']) {
                $out->transaction->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->transaction->currency->icon = null;
    }
    
    $out->reception = new stdClass();
    
    $out->reception->amount = new stdClass();
    $out->reception->amount->number = (float)$txdata['amountrx'];
    $out->reception->amount->formatted = numberFormatt($out->reception->amount->number, $txdata['currencyrxdecimals']);
    
    $out->reception->currency = new stdClass();
    $out->reception->currency->id = (int)$txdata['currencyrxid'];
    $out->reception->currency->name = $txdata['currencyrxname'];
    $out->reception->currency->symbol = $txdata['currencyrxsymbol'];
    $out->reception->currency->decimals = $txdata['currencyrxdecimals'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    //$record->basecurrency->test = $pairrefdata['icon'];
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->reception->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $txdata['currencyrxicon']) {
                $out->reception->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->reception->currency->icon = null;
    }
    
    $receivecurrencies = explode(',', $txdata['receivecurrencies']);
    
     foreach($receivecurrencies as $currencyid){
        $sql = "SELECT curr.id AS currencyid,".
        "       curr.name AS currencyname, ".
        "       curr.symbol AS currencysymbol, ".
        "       curr.decimals AS currencydecimals, ".
        "       curr.status AS currencystatus, ".
        "       curr.interface AS currencyinterface, ".
        "       acc.id AS accountid, ".
        "       acc.paymentmethodid AS paymentmethodid, ".
        "       acc.status AS accountstatus, ".
        "       IF(acc.id IS NULL, 0, ( ".
        "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id) - ".
        "               ( ".
        "                   IF( ".
        "                   (SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
        "                   FROM orders ".
        "                   WHERE orders.accountid = acc.id ".
        "                   AND orders.canceled IS NULL ".
        "                   AND orders.type != 1) IS NULL, 0, ".
        "                   (SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
        "                   FROM orders ".
        "                   WHERE orders.accountid = acc.id ".
        "                   AND orders.canceled IS NULL ".
        "                   AND orders.type != 1) ".
        "                   ) + IF( ".
        "                   (SELECT SUM(transactions.amount) AS amount ".
        "                   FROM transactions, orders ".
    	"                   WHERE orders.id = transactions.orderid ".
        "                   AND transactions.accountid = acc.id ".
        "                   AND orders.accountid = acc.id  ".
        "                   AND orders.canceled IS NULL ".
        "                   AND transactions.amount < 0 ".
        "                   AND orders.type != 1) IS NULL, 0, ".
        "                   (SELECT SUM(transactions.amount) AS amount ".
        "                   FROM transactions, orders ".
    	"                   WHERE orders.id = transactions.orderid ".
        "                   AND transactions.accountid = acc.id ".
        "                   AND orders.accountid = acc.id ".
        "                   AND orders.canceled IS NULL ".
        "                   AND transactions.amount < 0 ".
        "                   AND orders.type != 1) ".
        "                   ) ".
        "               ) ".
        "       )) AS avaliable ".
        "       FROM currencies curr ".
        "       LEFT JOIN accounts acc ON ".
        "           acc.currencyid = curr.id ".
        "           AND acc.userid = ".$userid.
        "           AND acc.paymentmethodid = -1 ".
        "           AND acc.entityusrid = ".$entityid.
        "       WHERE curr.status = 1 ".
        "       AND curr.id > 0 ".
        "       AND curr.id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
    
        $record = new stdClass();

        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['currencydecimals'];
        
        $record->rate = new stdClass();
        
        // Obtenemos la tasa de cambio
        if ($out->transaction->currency->id == $record->id) {
            $record->rate->number = (float)number_format(1, $record->decimals, '.', '');
            $record->rate->formatted = numberFormatt($record->rate->number, $record->decimals);
        } else {
            //Si la moneda no es igual a la inicial debemos buscar si estan relacionadas en un par
            $sql = "SELECT COUNT(pairs.id) AS qty ".
            "       FROM pairs ".
            "       WHERE ".
            "       (currencyid = ".$out->transaction->currency->id.
            "           AND refcurrencyid = ".$record->id.
            "       ) OR ".
            "       (currencyid = ".$record->id.
            "           AND refcurrencyid = ".$out->transaction->currency->id.
            "       )";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
        
            $pairres = $res->fetch_assoc();
                
            //Si existe el par directo hacemos la conversion de balance
            if($pairres['qty'] > 0){
                
                $sql = "SELECT * FROM pairs WHERE ".
                "       (currencyid = ".$out->transaction->currency->id.
                "           AND refcurrencyid = ".$record->id.
                "       ) OR ".
                "       (currencyid = ".$record->id.
                "           AND refcurrencyid = ".$out->transaction->currency->id.
                "       )";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
        
                $pairres = $res->fetch_assoc();
                
                //Obtenemos la ultima transaccion realizada
                $sql = "SELECT (SELECT ord.price FROM orders ord ".
                "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice ".
                "       FROM orders, accounts, transactions t  ".
                "           LEFT JOIN transactions txother ".
                "               ON t.orderid != txother.orderid ".
                "               AND t.txid = txother.txid  ".
                "               AND txother.amount > 0 ".
                "               AND txother.dsc NOT LIKE 'Comisi%' ".
                "       WHERE t.orderid IS NOT NULL ".
                "       AND orders.id = txother.orderid ".
                "       AND orders.pairid = ".$pairres['id'].
                "       AND t.id = t.txid ".
                "       AND t.dsc NOT LIKE 'Comisi%' ".
                "       AND accounts.id = orders.accountid ".
                "       GROUP BY t.txid ".
                "       ORDER BY t.datecreated DESC, t.id DESC".
                "       LIMIT 1";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                            
                $lastexchange = $res->fetch_assoc();
                
                if ($out->transaction->currency->id == $pairres['currencyid']) {
                    $record->rate->number = bcdiv(number_format($lastexchange['orderprice'] == null ? 0 : 1 / $lastexchange['orderprice'],13, '.', ''), '1',$record->decimals);
                } else {
                    $record->rate->number = bcdiv(number_format($lastexchange['orderprice'] == null ? 0 : $lastexchange['orderprice'],13, '.', ''), '1',$record->decimals);
                }
                
                if ($record->rate->number == 0) {
                    if ($out->transaction->currency->id == $pairres['currencyid']) {
                        $record->rate->number = bcdiv(number_format($lastexchange['orderprice'] == null ? 0 : 1 / $lastexchange['orderprice'],13, '.', ''), '1',13);
                    } else {
                        $record->rate->number = bcdiv(number_format($lastexchange['orderprice'] == null ? 0 : $lastexchange['orderprice'],13, '.', ''), '1',13);
                    }
                }
                
                $record->rate->formatted = numberFormatt($record->rate->number, $record->decimals);
            }else{
                $record->rate->number = (float)number_format(0, $record->decimals, '.', '');
                $record->rate->formatted = numberFormatt($record->rate->number, $record->decimals);
            }
        }
        
        $account = new stdClass();
        $account->id = (int)$row["accountid"];
        //Balance a partir de las transacciones
        $account->balance = new stdClass();
        $account->balance->number = $row['avaliable'] == null ? 0 : (float)bcdiv(number_format($row['avaliable'],13, '.', ''), '1',$row["currencydecimals"]);
        $account->balance->number = $account->balance->number < 0 ? 0 : $account->balance->number;
        $account->balance->formatted = numberFormatt($account->balance->number,$row["currencydecimals"]);
        
        $record->account = $account;
        
        $records [] = $record;
    }
    
    $out->acceptedcurrencies = $records;
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>