<?php
//pay/api/preferences/entry
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $_GET['sessionid'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    $sql = "SELECT users.id AS id, ".
    "       users.usr AS email, ".
    "       users.paymobilephone AS phone, ".
    "       users.level AS level, ".
    "       payusers.avatarimgtype AS avatarimgtype, ".
    "       payusers.datecreated AS datecreated, ".
    "       payusers.receivecurrencies AS receivecurrencies, ".
    "       payusers.sendcurrencies AS sendcurrencies, ".
    "       payusers.acceptedcurrencies AS acceptedcurrencies, ".
    "      IF(userpersons.fname IS NULL, ".
    "           usercompanies.name, ".
    "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)))".
    "       ) AS name, ".
    "       IF(userpersons.fname IS NULL, ".
    "           usercompanies.comercialname, ".
    "           CONCAT(userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
    "       ) AS lastname, ".
    "       IF(userpersons.fname IS NULL, ".
    "           CONCAT(usercompanies.name, ".
    "               IF(usercompanies.comercialname IS NULL OR usercompanies.comercialname = '', '', CONCAT('/',usercompanies.comercialname))), ".
    "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
    "       ) AS fullname ".
    "       FROM payusers, users ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       WHERE users.id = ".$userid.
    "       AND users.id = payusers.userid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->id = (int)$row['id'];
    $out->name = $row['name'];
    $out->lastname = $row['lastname'];
    $out->fullname = $row['fullname'];
    $out->email = $row['email'];
    $out->mobilephone = $row['phone'];
    
    $levelInfo = getLevelById($db, $row['level']);
    $out->level = new stdClass();
    $out->level->id = (int)$row['level'];
    $out->level->dsc = 'Nivel '.$levelInfo['orden'];
    
    $out->datecreated = new stdClass();
    $out->datecreated->date = date("Ymd Hi", strtotime($row['datecreated']));
    $out->datecreated->formatted = date("d/m/Y", strtotime($row['datecreated']));
    
    //  Guardamos las monedas que tiene en la BD guardadas
    $receivecurrencies = explode(',', $row['receivecurrencies']);
    $sendcurrencies = explode(',', $row['sendcurrencies']);
    $acceptedcurrencies = explode(',', $row['acceptedcurrencies']);
    
    if ($row['avatarimgtype'] != null) {
         $out->avatar = new stdClass();
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/users/".$out->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $out->avatar = new stdClass();
            $out->avatar->type = $row['avatarimgtype'];
            $out->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
        }else{
            $out->avatar = null;
        }
    }else {
        $out->avatar = null;
    }
    
    //  Obtenemos las cuentas con sus monedas
    $sql = "SELECT curr.id AS currencyid,".
    "       curr.name AS currencyname, ".
    "       curr.symbol AS currencysymbol, ".
    "       curr.decimals AS decimals, ".
    "       acc.status AS accountstatus ".
    "       FROM currencies curr ".
    "       LEFT JOIN accounts acc ON ".
    "       acc.currencyid = curr.id ".
    "       AND acc.userid = ".$userid.
    "       AND acc.paymentmethodid = -1 ".
    "       AND acc.entityusrid = -1 ".
    "       WHERE (curr.status = 1 ".
    "       OR curr.id = (SELECT acc.currencyid ".
    "           FROM accounts acc ".
    "           WHERE acc.userid = ".$userid.
    "           AND acc.currencyid = curr.id ".
    "           AND curr.status = 1 ".
    "           AND acc.paymentmethodid = -1 ".
    "           AND acc.entityusrid = -1)) AND curr.id > 0".
    "           AND curr.xfer = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($row = $rs->fetch_assoc()){
        // Guardamos los datos de la moneda
        $record = new stdClass();
        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['decimals'];
        $record->receive = false;
        $record->send = false;
        $record->accepted = false;

        // Validamos si existe la moneda en su configuracion
        foreach($receivecurrencies as $currency){
            if($currency == $record->id){
                $record->receive = true;
            }
        }
        
        // Validamos si existe la moneda en su configuracion de envio
        foreach($sendcurrencies as $currency){
            if($currency == $record->id){
                $record->send = true;
            }
        }
        
        // Validamos si existe la moneda en su configuracion de aceptacion
        foreach($acceptedcurrencies as $currency){
            if($currency == $record->id){
                $record->accepted = true;
            }
        }
        
        $records [] = $record;
    }
    
    $out->currencies = $records;
    
    $out->devices = getUserDevices($db, $userid);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para obtener los dispositivos del usuario
    *
    */
    function getUserDevices($db, $userid) {
        // Consultamos los devices
        $sql = "SELECT paydevices.id AS deviceid, ".
        "       paydevices.name AS name, ".
        "       paydevices.token AS token ".
        "       FROM paydevices, payuserdevices".
        "       WHERE paydevices.id = payuserdevices.paydeviceid".
        "       AND payuserdevices.payuserid = ".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $devices = [];
        while($row = $rs->fetch_assoc()){
            $record = new stdClass();
            $record->id = (int)$row['deviceid'];
            $record->name = $row['name'];
            
            $devices [] = $record;
        }
        
        return $devices;
    }
?>