<?php
//pay/api/preferences/uploadpicture
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $image = $_FILES["image"];
    if($image["name"] == null){
        badEnd("400", array("msg"=>"Parametros obligatorios image"));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $_POST['sessionid'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);

    // Guardamos la foto en el directorio
    $db->autocommit(FALSE);
    
    //Obtenemos la extension de la imagen
    //$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
    switch ($image["type"]){
        case "image/jpeg":
        case "image/jpg":
            $ext = "jpg";
        break;
        case "image/png":
            $ext = "png";
        break;
        default:
            $ext = "";
        break;
    }
    if($ext == ""){
        badEnd("402", array("msg"=>"Formato inválido"));
    }
    
    
    //Actualizamos el campo del usuario
    $sql = "UPDATE payusers SET ".
    "   	avatarimgtype = '".$image["type"]."' ".
    "       WHERE userid = ".$userid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Creamos la direccion del folder
    $urlfolder = "../../../uploads/users/".$userid;
    
    // Borramos cualquier avatar qque tenga (extensiones)
    $filesfromdir = glob($urlfolder.'/avatar.*');
    foreach($filesfromdir as $filefromdir){
        //Eliminamos fichero
        unlink($filefromdir);
    }
        
    //Movemos el FILE del directorio temporal al del sistema para su uso 
    if(!move_uploaded_file($image["tmp_name"], $urlfolder . "/avatar." . $ext)){
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>determinateMsgFail(array(
            "esp"=>"Error guardando la imagen",
            "eng"=>"Error saving image"), $lang, "Error guardando la imagen")));
    }
    
    $db->commit();
    
    $db->autocommit(TRUE);
    
    $sql = "SELECT users.id AS id, ".
    "       GROUP_CONCAT(IF(userpersons.fname IS NULL, ".
    "           CONCAT(usercompanies.name, ".
    "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
    "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL, '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL, '', CONCAT(' ',userpersons.slastname)) )".
    "       ) SEPARATOR '|') AS name ".
    "       FROM payusers, users ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       WHERE users.id = ".$userid.
    "       AND users.id = payusers.userid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->id = (int)$row['id'];
    $out->fullname = $row['name'];
    
    //  Obtenemos el image/type de la tabla payusers
    $sql = "SELECT avatarimgtype FROM payusers WHERE userid = ".$out->id;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $res->fetch_assoc();
    
    if ($row['avatarimgtype'] != null) {
         $out->avatar = new stdClass();
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/users/".$out->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $out->avatar = new stdClass();
            $out->avatar->type = $row['avatarimgtype'];
            $out->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
        }else{
            $out->avatar = null;
        }
    }else {
        $out->avatar = null;
    }
            
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>