<?php
//pay/api/sendmoney/usrbyemail
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'email');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $_GET['sessionid'];
    $email = strtolower($_GET['email']);
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Validamos que existe
    $sql = "SELECT COUNT(userid) AS qty FROM (SELECT users.id AS userid ".
    "       FROM users, usercompanies ".
    "       WHERE users.id > 0 ".
    "       AND usercompanies.usrid = users.id AND users.type IS NOT NULL".
    "       AND users.usr = '".$email."' ".
    "".
    "UNION ALL".
    "".
    "       SELECT users.id AS userid ".
    "       FROM users,userpersons ".
    "       WHERE users.id > 0 ".
    "       AND userpersons.usrid = users.id AND users.type IS NOT NULL".
    "       AND users.usr = '".$email."' ".
    " ) A     ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0) {
        badEnd("204", array("msg"=>"Usuario no encontrado"));
    }
    
    // Obtenemos sus datos
    $sql = "SELECT * FROM (".
    "       SELECT users.id AS userid, ".
    "       users.usr AS usr, ".
    "       usercompanies.phone AS phone, ".
    "       users.level AS level, ".
    "       usercompanies.doc AS doc, ".
    "       CONCAT(usercompanies.name, ".
    "           IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))) AS fullname, ".
    "       usercompanies.name AS name, ".
    "       usercompanies.comercialname AS secondname ".
    "       FROM users, usercompanies ".
    "       WHERE users.id > 0 ".
    "       AND usercompanies.usrid = users.id AND users.type IS NOT NULL".
    "       AND users.usr = '".$email."' ".
    "".
    "UNION ALL".
    "".
    "       SELECT users.id AS userid, ".
    "       users.usr AS usr, ".
    "       userpersons.phone AS phone, ".
    "       users.level AS level, ".
    "       userpersons.doc AS doc, ".
    "       CONCAT(userpersons.fname, ".
    "           IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),".
    "           ' ', ".
    "           userpersons.flastname, ".
    "           IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) ".
    "       ) AS fullname, ".
    "       CONCAT(userpersons.fname, IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname))) AS name, ".
    "       CONCAT(userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname))) AS secondname ". 
    "       FROM users,userpersons ".
    "       WHERE users.id > 0 ".
    "       AND userpersons.usrid = users.id AND users.type IS NOT NULL".
    "       AND users.usr = '".$email."' ".
    " ) A ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    // Validamos si tiene cuentas creadas de PAY
    $sql = "SELECT COUNT(accounts.id) AS qty ".
    "       FROM accounts ".
    "       WHERE accounts.paymentmethodid = -1 ".
    "       AND accounts.status = 1".
    "       AND accounts.userid = ".$row['userid'];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $accounts = $res->fetch_assoc();
    
    $out->user = new stdClass();
    
    $out->user->editable = $accounts['qty'] > 0 ? false : true;
    
    $out->user->id = (int)$row['userid'];
    $out->user->name = $row['name'];
    $out->user->lastname = $row['secondname'];
    $out->user->fullname = $row['fullname'];

    $out->user->level = new stdClass();
    $out->user->level->id = (int)$row['level'];
    $out->user->level->dsc = 'Nivel '.$row['level'];
    
    if ($out->user->editable) {
        $out->user->email = $row['usr'];
        $out->user->mobilephone = $row['phone'];
        $out->user->documentid = $row['doc'];
    } else {
        
        $out->user->email = privateEmail($row['usr']);

        $out->user->mobilephone = privatePhone($row['phone']);

        $out->user->documentid = privateDocument($row['doc']);
    }
    
    //  Obtenemos el image/type de la tabla payusers
    $sql = "SELECT avatarimgtype, status, acceptedcurrencies ".
    "       FROM payusers ".
    "       WHERE userid = ".$out->user->id;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $res->fetch_assoc();
    
    if ($row['avatarimgtype'] != null) {
        $out->user->avatar = new stdClass();
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/users/".$out->user->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $out->user->avatar = new stdClass();
            $out->user->avatar->type = $row['avatarimgtype'];
            $out->user->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
        }else{
            $out->user->avatar = null;
        }
    }else {
        $out->user->avatar = null;
    }
    
    $out->user->acceptedcurrencies = null;
    
    foreach(explode(',', $row['acceptedcurrencies']) as $curr){
        $out->user->acceptedcurrencies [] = (int)$curr;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>