<?php
// pay/api/register/uploadrequirement
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $parmsob = array('field');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $parmsob = array('ARCHIVO');
    if (!isset($_FILES['ARCHIVO'])){
        badEnd("400", array("msg"=>"Parametros obligatorios FILE: ARCHIVO", "msg2"=>$_FILES));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $field = str_pad($_POST['field'], 2, "0", STR_PAD_LEFT);
    $image = $_FILES['ARCHIVO'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Validamos el tipo de usuario para saber a que tabla apuntar
    $sql = "SELECT type, level FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    //Creamos la direccion del folder
    $urlfolder = "../../../uploads/users/".$userid;
        
    //Creamos el directorio en caso de que no exista
    if(!is_dir($urlfolder)){
        mkdir($urlfolder, 0777, true);
    }
    
    $filesfromdir = glob($urlfolder.'/*');
    
    $arrlendir = sizeof($filesfromdir);
    
    //Si no hay archivos significa que deben ser ingresados por primera vez
    if($arrlendir == 0){
        //Obtenemos la extension de la imagen
        //$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        switch ($image["type"]){
            case "image/jpeg":
            case "image/jpg":
                $ext = "jpg";
            break;
            case "image/png":
                $ext = "png";
            break;
            default:
                $ext = "";
            break;
        }
        if($ext == ""){
            badEnd("402", array("msg"=>"Formato inválido"));
        }
        
        //Movemos el FILE del directorio temporal al del sistema para su uso
        if(move_uploaded_file($image["tmp_name"], $urlfolder . "/" . $field . "." . $ext)){
            //Guardamos los datos del FILE en la BD para su busqueda
            $sql = "INSERT INTO useruploads (userid,prefuploadid,filetype,validated)".
            "       VALUES(".$userid.",".$field.",'".$image["type"]."',0)";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error,"sql"=>$sql));
                
            reqverifyuser($userid, $db, true);
        }else{
            badEnd("411", array($msg=>"Error subida de archivos ".$_FILES["file"]["error"]));
        }
    } else {
        //Si el archivo ya existia y quiere ser actualizado se elimina
        $filewithsamename = glob($urlfolder . "/" . $field . ".*");
        foreach ($filewithsamename as $file) {
            unlink($file);
        }
                
        //Obtenemos la extension de la imagen
        //$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        switch ($image["type"]){
            case "image/jpeg":
            case "image/jpg":
                $ext = "jpg";
            break;
            case "image/png":
                $ext = "png";
            break;
            default:
                $ext = "";
            break;
        }
        if($ext == ""){
            badEnd("402", array("msg"=>"Formato inválido"));
        }
            
        //Movemos el FILE del directorio temporal al del sistema para su uso
        if(move_uploaded_file($image["tmp_name"], $urlfolder . "/" . $field . "." . $ext)){
            
            //Validamos que el registro en la BD
            $sql = "SELECT userid, prefuploadid FROM useruploads".
            "       WHERE userid = ".$userid." AND".
            "       prefuploadid = ".$field;
            if (!$result=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                  
            $imagedata = $result->fetch_assoc();
                    
            //Si no existe, se inserta un nuevo registro
            if($imagedata["userid"] == null){
                $sql = "INSERT INTO useruploads(userid,prefuploadid,filetype,validated)".
                "       VALUES(".$userid.",".$field.",'".$image["type"]."',0)";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error,"sql"=>$sql));
                                    
                reqverifyuser($userid, $db, true);
            }else{
                /*Si no, actualizamos el ya existente cambiando el type(si es necesario) y 
                * colocamos el validated 0 para que el nuevo archivo sea validado
                */
                $sql = "UPDATE useruploads SET".
                "       filetype = '".$image["type"]."', ".
                "       validated = 0".
                "       WHERE".
                "       userid = ".$userid." AND".
                "       prefuploadid = ".$field;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                                
                    reqverifyuser($userid, $db, true);
            }
        }else{
            badEnd("411", array($msg=>"Error subida de archivos ".$_FILES["file"]["error"]));
        }
    }
    
    // Obtenemos el nivel para el usuario
    $records = getAvaliableLevels($db, $userid);
    
    if ($row['level'] == 0) {
        foreach($records as $levelIn) {
            // Si tiene disponible el nivel 0.5 (ID = 4) lo upgradeamos
            if (strpos($levelIn->name, '0.5') !== false) {
                $sql = "UPDATE users SET".
                "       level = ".$levelIn->id.
                "       WHERE id = ".$userid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                // Obtenemos las xfer por paypending = 1 y userid del usuario
                $sql = "SELECT transactions.id AS id, ".
                "       transactions.txid AS txid, ".
                "       transactions.amount AS amount, ".
                "       transactions.accountid AS accountid ".
                "       FROM transactions ".
                "       LEFT JOIN  accounts ON accounts.id = transactions.accountdestination AND accounts.userid = ".$userid.
                "       WHERE transactions.paypending = 1 ".
                "       AND transactions.id = transactions.txid ".
                "       AND (transactions.accountdestination = ".$userid." OR accounts.id IS NOT NULL)";
                if (!$resxfer=$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                while($transRow = $resxfer->fetch_assoc()){
                    // Creamos la cuenta de destino del usuario
                    //Validamos si es una criptomoneda o fiat
                    $isCripto = false;
                    $isFiat = false;
                    
                    // Obtenemos los datos de la moneda de la cuenta
                    $sql = "SELECT ".
                    "       currencies.id AS currencyid, ".
                    "       currencies.interface AS interface, ".
                    "       currencies.symbol AS symbol ".
                    "       FROM currencies, accounts ".
                    "       WHERE accounts.currencyid = currencies.id".
                    "       AND accounts.id = ".$transRow['accountid'];
                    if (!$res=$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                    
                    $currencydata = $res->fetch_assoc();
                    
                    // Validamos que el usuario no tenga una cuenta ya con esa moneda
                    $sql = "SELECT COUNT(accounts.id) AS qty ".
                    "       FROM accounts, users ".
                    "       WHERE accounts.currencyid = ".$currencydata['currencyid'].
                    "       AND users.id = ".$userid.
                    "       AND accounts.userid = users.id ".
                    "       AND accounts.paymentmethodid = -1";
                    if (!$res=$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                    
                    $accountcount = $res->fetch_assoc();
                    
                    if($accountcount['qty'] == 0){
                        if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 3 || intval($currencydata['interface']) == 2){
                            $isFiat = true;
                        }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6 || intval($currencydata['interface']) == 7){
                            $isCripto = true;
                        }
                                    
                        if($isCripto && !$isFiat){
                            $apiKeySecret = '';
                            $txidWallet = '';
                            //Si interface = 5, generamos la wallet con la api de la TCV
                            if(intval($currencydata['interface']) == 5){
                                /*$rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                                $out->test = $rsp;
                                
                                //Si el address es null o la respuesta distinta a 201, error
                                if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                                    badEnd("402", array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                                }
                                            
                                $walletid = $rsp['address'];
                                $apiKeySecret = randomString(8);*/
                                $walletid = randomString(30);
                                $apiKeySecret = randomString(8);
                            }elseif(intval($currencydata['interface']) == 4){
                                $parms = array("label"=>"afxaddr");
                                $request = array('method'=>'getnewaddress','parms' => $parms);
                                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
                                
                                // Validamos que el error no sea nulo para mandar el mensaje
                                if($rsp['error'] != null){
                                    badEnd('500',array("msg"=>$rest['error']['message']));
                                }
                                
                                if($rsp['result'] == null){
                                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                                }
                                
                                $walletid = $rsp['result'];
                                $apiKeySecret = randomString(8);
                            }else if(intval($currencydata['interface']) == 6){
                                //TETHER
                                $request = array('method'=>'createAddress');
                                //$request = array('method'=>'createAddress2','parms' => $parms); //testing width trx transaction
                                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                            
                                if($rest['newaddress']['address_base58'] == null){
                                    badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                                }
                            
                                $walletid = $rest['newaddress']['address_base58'];
                                $apiKeySecret = $rest['newaddress']['private_key'];
                            
                                $txidWallet = $rest['transaction']['txid'];
                            }else if(intval($currencydata['interface']) == 7){
                                // DASH
                                $parms = array("label"=>"afxaddr");
                                $request = array('method'=>'getnewaddress','parms' => $parms);
                                $rsp = json_decode(queryServicesDash($DASH_URL, $request),true);
                            
                                // Validamos que el error no sea nulo para mandar el mensaje
                                if($rsp['error'] != null){
                                    badEnd('500',array("msg"=>$rest['error']['message']));
                                }
                                            
                                if($rsp['result'] == null){
                                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                                }
                                
                                $walletid = $rsp['result'];
                                $apiKeySecret = randomString(8);
                            }else{
                                $walletid = randomString(30);
                                $apiKeySecret = randomString(8);
                            }
                                    
                            //Insertamos la nueva cuenta
                            $sql = "INSERT INTO accounts".
                            "       (".
                            "       paymentmethodid, ".
                            "       userid, ".
                            "       currencyid, ".
                            "       details1, ".
                            "       entityusrid, ".
                            "       status ".
                            "       )".
                            "       VALUES(".
                            "       -1, ".
                            "       ".$userid.", ".
                            "       ".$currencydata['currencyid'].", ".
                            "       '".$walletid."', ".
                            "       -1, ".
                            "       1 ".
                            "       )";
                            if (!$db->query($sql)){
                                badEnd("500", array("msg"=>determinateDBError($db)));
                            }
                            
                            // Retornamos el id que fue insertado
                            $idcreated = (int)$db->insert_id;
                                    
                            //Al ser una cripto, creamos una wallet
                            $sql = "INSERT INTO wallets".
                            "       (".
                            "       wallet, ".
                            "       secretKey, ".
                            "       accountid, ".
                            "       txid, ".
                            "       expirationDate".
                            "       )".
                            "       VALUES(".
                            "       '".$walletid."', ".
                            "       '".$apiKeySecret."', ".
                            "       ".$idcreated.", ".
                            "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
                            "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                            "       )";
                            if (!$db->query($sql)){
                                badEnd("500", array("msg"=>determinateDBError($db)));
                            }
                        
                        }else if($isFiat && !$isCripto){
                            //Insertamos la nueva cuenta
                            $sql = "INSERT INTO accounts".
                            "       (".
                            "       paymentmethodid, ".
                            "       userid, ".
                            "       currencyid, ".
                            "       entityusrid, ".
                            "       status".
                            "       )".
                            "       VALUES(".
                            "       -1, ".
                            "       ".$userid.", ".
                            "       ".$currencydata['currencyid'].", ".
                            "       -1, ".
                            "       1".
                            "       )";
                            if (!$db->query($sql)){
                                badEnd("500", array("msg"=>determinateDBError($db)));
                            }
                        }else{
                            badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
                        }
                    }
                    
                    //Consultamos nuevamente los datos del usuario de destino
                    $sql = "SELECT accounts.id AS accountid ".
                    "       FROM accounts, users ".
                    "       WHERE accounts.userid = users.id ".
                    "       AND users.id = ".$userid.
                    "       AND accounts.currencyid = ".$currencydata['currencyid'].
                    "       AND accounts.paymentmethodid = -1";
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                    $accountdestination = $res->fetch_assoc();
                    
                    // Obtenemos el correo del usuario
                    $sql = "SELECT users.usr AS usr ".
                    "       FROM users, accounts ".
                    "       WHERE accounts.id = ".$transRow['accountid'].
                    "       AND users.id = accounts.userid";
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                    $usrorigin = $res->fetch_assoc();
                    
                    //insertamos la transferencia hacia el destino
                    $sql = "INSERT INTO transactions".
                    "       (".
                    "       datecreated, ".
                    "       dsc, ".
                    "       accountid, ".
                    "       txid, ".
                    "       accountorigin, ".
                    "       amountghost, ".
                    "       amount, ".
                    "       accountdestination, ".
                    "       validator, ".
                    "       validthru, ".
                    "       paypending ".
                    "       )".
                    "       VALUES(".
                    "       NOW(), ".
                    "       'Transferencia PAY de ".$usrorigin['usr']."', ".
                    "       ".$accountdestination["accountid"].", ".
                    "       ".$transRow['txid'].", ".
                    "       ".$transRow['accountid'].", ".
                    "       0, ".
                    "       ".abs($transRow['amount']).", ".
                    "       ".$accountdestination["accountid"].", ".
                    "       NULL, ".
                    "       NULL, ".
                    "       0 ".
                    "       )";
                    if (!$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                    
                    // Quitamos el paypending a 0
                    $sql = "UPDATE transactions SET ".
                    "       paypending = 0 ".
                    "       WHERE transactions.txid = ".$transRow['txid'];
                    if (!$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                    
                    // Actualizamos el movimiento de origen por la cuenta nueva
                    $sql = "UPDATE transactions SET ".
                    "       accountdestination = ".$accountdestination["accountid"].
                    "       WHERE id = ".$transRow['id'];
                    if (!$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                }
            }
        }
    }
    
    $out->msg = "Archivo guardado";
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>