<?php
//pay/api/sendmoney/prepare
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'currency');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $_GET['sessionid'];
    $currencyid = $_GET['currency'];

    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //  Obtenemos el nivel del usuario
    $sql = "SELECT level, type FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    $level = $row['level'];
    $usertype = $row['type'];
    
    // Validamos que la moneda exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();

    if($row['qty'] == 0){
        badEnd("402", array("msg"=>"Moneda no encontrada"));
    }
    
    $sql = "SELECT interface ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    // Devolvemos la moneda si es pago movil o no
    $out->pagomovil = $row['interface'] == 1;
    
    //  Obtenemos las monedas que tiene el usuario para enviar
    $sql = "SELECT sendcurrencies ".
    "       FROM payusers ".
    "       WHERE userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    $sendcurrencies = explode(',', $row['sendcurrencies']);
    
    //Consultamos las monedas
    $sql = "SELECT curr.id AS currencyid,".
    "       curr.name AS currencyname, ".
    "       curr.symbol AS currencysymbol, ".
    "       curr.decimals AS currencydecimals, ".
    "       curr.status AS currencystatus, ".
    "       curr.interface AS currencyinterface, ".
    "       acc.id AS accountid, ".
    "       acc.paymentmethodid AS paymentmethodid, ".
    "       acc.status AS accountstatus, ".
    "       IF(acc.id IS NULL, 0, ( ".
    "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id AND paypending = 0) - ".
    "           ABS(IF(( ".
    "               SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "               FROM orders ".
    "               WHERE orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"               AND orders.type != 1) IS NOT NULL,  ".
	"                   ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = acc.id".
    "           AND orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"               AND transactions.amount < 0 ".
	"               AND orders.type != 1) IS NOT NULL, ( ".
    "               SELECT SUM(transactions.amount) AS amount ".
    "            FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND transactions.accountid = acc.id".
    "               AND orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"                AND transactions.amount < 0 ".
	"                AND orders.type != 1),0) ".
	"           + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"                FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"               (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"               FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"           )".
    "       )) AS avaliable ".
    "       FROM currencies curr ".
    "       LEFT JOIN accounts acc ON ".
    "           acc.currencyid = curr.id ".
    "           AND acc.userid = ".$userid.
    "           AND acc.paymentmethodid = -1 ".
    "           AND acc.entityusrid = -1 ".
    "       WHERE curr.status = 1 ".
    "       AND curr.id > 0 ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();

        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['currencydecimals'];
        //Ojo samu en esta segúnda validación en estas monedas se validan que NO sean fiat. 
        //Esta moneda determina si es una "cripto" que puede cubrir los fondos para que afx realice el pago movil por fuera. Corrijo la validación
        //$record->pagomovil = $row['currencyinterface'] == 1;
        $notallowed = array(0,1,2,3);//Interfaces que no se admiten
        $record->pagomovil = !(in_array($row['currencyinterface'],$notallowed));
        $record->send = false;
        
        // Validamos si existe la moneda en su configuracion de envio
        foreach($sendcurrencies as $currency){
            if($currency == $record->id){
                $record->send = true;
            }
        }
        
        $record->rate = determinateRate($db, $currencyid, $record->id, $record->decimals);
        
        $account = new stdClass();
        $account->id = (int)$row["accountid"];
        
        //Balance a partir de las transacciones
        
        $account->balance = new stdClass();
        
        $account->balance->number = $row['avaliable'] == null ? 0 : (float)bcdiv(number_format($row['avaliable'],13, '.', ''), '1',$row["currencydecimals"]);
        $account->balance->number = $account->balance->number < 0 ? 0 : $account->balance->number;
        $account->balance->formatted = numberFormatt($account->balance->number,$row["currencydecimals"]);
        
        $record->account = $account;
        
        $sql = "SELECT maxamountmonthlyopxfer AS maxxfer, ".
        "       pagomovilmaxsend as pagomovilmaxsend, ".
        "       maxamountopsendpay AS maxmoneysendamount ".
        "       FROM cmspreffees ".
        "       WHERE levelid = ".$level.
        "       AND usertype = ".$usertype.
        "       AND currencyid = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $maxes = $res->fetch_assoc();
        
        $record->maxs = new stdClass();
        
        // Obtenemos la configuracion del envio de dinero
        $record->maxs->moneysend = new stdClass();
        $record->maxs->moneysend->amount = new stdClass();
        $record->maxs->moneysend->amount->number = (float)number_format($maxes['maxmoneysendamount'], $record->decimals, '.', '');
        $record->maxs->moneysend->amount->formatted = numberFormatt($record->maxs->moneysend->amount->number, $record->decimals);
        
        // Obtenemos la configuracion de las transferencias
        $record->maxs->xfer = new stdClass();
        $record->maxs->xfer->amount = new stdClass();
        $record->maxs->xfer->amount->number = (float)number_format($maxes['maxxfer'], $record->decimals, '.', '');
        $record->maxs->xfer->amount->formatted = numberFormatt($record->maxs->xfer->amount->number, $record->decimals);
        
        // Obtenemos la configuracion de las transferencias
        $record->maxs->pagomovil = new stdClass();
        $record->maxs->pagomovil->amount = new stdClass();
        $record->maxs->pagomovil->amount->number = (float)number_format($maxes['pagomovilmaxsend'], $record->decimals, '.', '');
        $record->maxs->pagomovil->amount->formatted = numberFormatt($record->maxs->pagomovil->amount->number, $record->decimals);
        
        // Fees de movimientos
        $sql = "SELECT nmlfeesxfer AS nmlxfer, ".
        "       pctfeexfer as pctxfer, ".
        "       pctfeewithdrawals AS pctwith, ".
        "       nmlfeewithdrawals AS nmlwith, ".
        "       pagomovilpct AS pctpagomovil ".
        "       FROM cmspreffees ".
        "       WHERE levelid = ".$level.
        "       AND usertype = ".$usertype.
        "       AND currencyid = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $fees = $res->fetch_assoc();
        
        $record->fees = new stdClass();
        
        // Obtenemos la configuracion de las transferencias
        $record->fees->xfer = new stdClass();
        
        if($fees['pctxfer'] == 0){
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$record->id.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'nmlfeesxfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $record->fees->xfer->nominal = (float)number_format($fees['nmlxfer'] - ($fees['nmlxfer']/100 * $userExg['exonerated']), $record->decimals,'.','');
            $record->fees->xfer->percent = 0;
        }else{
            
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$record->id.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'pctfeexfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $record->fees->xfer->percent = (float)number_format($fees['pctxfer'] - ($fees['pctxfer']/100 * $userExg['exonerated']), 3,'.','');
            $record->fees->xfer->nominal = 0;
        }
        
        $record->fees->withdrawal = new stdClass();
        
        if($fees['pctwith'] == 0){
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$record->id.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'nmlfeewithdrawals'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $record->fees->withdrawal->nominal = (float)number_format($fees['nmlwith'] - ($fees['nmlwith']/100 * $userExg['exonerated']), $record->decimals,'.','');
            $record->fees->withdrawal->percent = 0;
        }else{
            
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$record->id.
            "       AND userid = ".$userid.
            "       AND preffeesfield = 'pctfeewithdrawals'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $record->fees->withdrawal->percent = (float)number_format($fees['pctwith'] - ($fees['pctwith']/100 * $userExg['exonerated']), 3,'.','');
            $record->fees->withdrawal->nominal = 0;
        }
        
        $sql = "SELECT nmlfeesxfer AS nmlxfer, ".
        "       pctfeexfer as pctxfer, ".
        "       pctfeewithdrawals AS pctwith, ".
        "       nmlfeewithdrawals AS nmlwith, ".
        "       pagomovilpct AS pctpagomovil ".
        "       FROM cmspreffees ".
        "       WHERE levelid = ".$level.
        "       AND usertype = ".$usertype.
        "       AND currencyid = 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $fees = $res->fetch_assoc();
            
        // Obtenemos la configuracion de las transferencias
        $record->fees->pagomovil = new stdClass();
        
        $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
        "       WHERE currencyid = 1".
        "       AND userid = ".$userid.
        "       AND preffeesfield = 'pagomovilpct'";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $userExg = $res->fetch_assoc();
        
        $record->fees->pagomovil->percent = (float)number_format($fees["pctpagomovil"] - ($fees["pctpagomovil"]/100 * $userExg['exonerated']), 3,'.','');
        
        $records [] = $record;
    }
    
    $out->currencies = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*
     El calculo de tasa de conversión referencial será el precio ponderado
     de la ultima orden market si hubo una en las ultimas 4 horas en el
     par de monedas sino se tomarla del CMS Preferencias Tasas de cambio
     el valor correspondiente.
*/
function determinateRate2($db, $basecurrency, $seccurrency, $basedecimals){
    $rate = new stdClass();
    if ($seccurrency == $basecurrency) {
        $rate->number = (float)number_format(1, $basedecimals, '.', '');
        $rate->formatted = numberFormatt($rate->number, $basedecimals);
    } else {
        //Si la moneda no es igual a la inicial debemos buscar si estan relacionadas en un par
        $sql = "SELECT COUNT(pairs.id) AS qty ".
        "       FROM pairs ".
        "       WHERE ".
        "       (currencyid = ".$seccurrency.
        "           AND refcurrencyid = ".$basecurrency.
        "       ) OR ".
        "       (currencyid = ".$basecurrency.
        "           AND refcurrencyid = ".$seccurrency.
        "       )";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $pairres = $res->fetch_assoc();
        
        //Si existe el par directo hacemos la conversion de balance
        if($pairres['qty'] > 0){
            
            $sql = "SELECT * FROM pairs WHERE ".
            "       (currencyid = ".$seccurrency.
            "           AND refcurrencyid = ".$basecurrency.
            "       ) OR ".
            "       (currencyid = ".$basecurrency.
            "           AND refcurrencyid = ".$seccurrency.
            "       )";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $pairres = $res->fetch_assoc();
            
            // Obtenemos los decimales de la base
            $sql = "SELECT decimals ".
            "       FROM currencies ".
            "       WHERE id = ".$pairres['refcurrencyid'];
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $currencybaserow = $res->fetch_assoc();
            $basedecimals = $currencybaserow['decimals'];
            
            // Validamos que la ultima operacion es de las ultimas 4 horas, si no, obtenemos el otro rate
                
            //Obtenemos la ultima transaccion realizada
            $sql = "SELECT (SELECT ord.price FROM orders ord ".
            "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice ".
            "       FROM orders, accounts, transactions t  ".
            "           LEFT JOIN transactions txother ".
            "               ON t.orderid != txother.orderid ".
            "               AND t.txid = txother.txid  ".
            "               AND txother.amount > 0 ".
            "               AND txother.dsc NOT LIKE 'Comisi%' ".
            "       WHERE t.orderid IS NOT NULL ".
            "       AND orders.id = txother.orderid ".
            "       AND orders.pairid = ".$pairres['id'].
            "       AND t.id = t.txid ".
            "       AND t.dsc NOT LIKE 'Comisi%' ".
            "       AND accounts.id = orders.accountid ".
            "       AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 4 HOUR)".
            "       GROUP BY t.txid ".
            "       ORDER BY t.datecreated DESC, t.id DESC".
            "       LIMIT 1";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                        
            $lastexchange = $res->fetch_assoc();
            
            // Si el movimiento no es nulo, hacemos el proceso de su calculo
            if($lastexchange['orderprice'] != null){
                $rate->number = bcdiv(number_format($lastexchange['orderprice'],13, '.', ''), '1',$basedecimals);
            } else {
                // Si es nulo, obtenemos el precio del rate de preferencias
                // Obtenemos el precio de la moneda base
                $sql = "SELECT rate AS price FROM cmsprefrates WHERE currencyid = ".$pairres['refcurrencyid'];
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                            
                $lastpricebase = $res->fetch_assoc();//-->Valor de la moneda base relativo a 1 USD
                
                // Obtenemos el precio de la moneda ref
                $sql = "SELECT rate AS price FROM cmsprefrates WHERE currencyid = ".$pairres['currencyid'];
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                            
                $lastpriceref = $res->fetch_assoc();
                
                if($lastpricebase['price'] <= 0 || $lastpriceref['price'] <= 0){
                    $rate->number = bcdiv(number_format(0, 13, '.', ''), '1',$basedecimals);
                } else {
                    if ($pairres['refcurrencyid'] == $basecurrency) {
                        $rate->number = bcdiv(number_format(($lastpriceref['price'] * 1 ) / $lastpricebase['price'],13, '.', ''), '1',$basedecimals);
                    } else {
                        $rate->number = bcdiv(number_format(($lastpricebase['price'] * 1) / $lastpriceref['price'],13, '.', ''), '1',$basedecimals);
                    }
                    
                }
            }
                
            $rate->formatted = numberFormatt($rate->number, $basedecimals);
        }else{
            // Si es nulo, obtenemos el precio del rate de preferencias
            // Obtenemos el precio de la moneda base
            $sql = "SELECT rate AS price FROM cmsprefrates WHERE currencyid = ".$basecurrency;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                        
            $lastpricebase = $res->fetch_assoc();
            
            // Obtenemos el precio de la moneda ref
            $sql = "SELECT rate AS price FROM cmsprefrates WHERE currencyid = ".$seccurrency;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                        
            $lastpriceref = $res->fetch_assoc();
            
            if($lastpricebase['price'] <= 0 || $lastpriceref['price'] <= 0){
                $rate->number = bcdiv(number_format(0, 13, '.', ''), '1',$basedecimals);
            } else {
                if ($pairres['currencyid'] == $basecurrency) {
                    $rate->number = bcdiv(number_format($lastpricebase['price'],13, '.', ''), '1',$basedecimals);
                } else {
                    $rate->number = bcdiv(number_format(($lastpricebase['price'] * 1) / $lastpriceref['price'],13, '.', ''), '1',$basedecimals);
                }
            }
            
            $rate->formatted = numberFormatt($rate->number, $basedecimals);
        }
    }
    
    return $rate;
}
?>