<?php

namespace App\Console\Commands;

use App\City;
use App\Country;
use App\Region;
use Illuminate\Console\Command;

class CountryLocation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'country:location';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Insert in the database the countries, regions and locality';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        // api battuta to country, regions and location.

        $json = file_get_contents('http://battuta.medunes.net/api/country/all/?key=f6507c21d699fe7c8140819b3199518e');
        $countries = json_decode($json, true);

        $countries2 = Country::All();

        /** save country */
        foreach ($countries as $country) {
            if ($countries2->count()) {
                foreach ($countries2 as $country2) {
                    if (!($country['name'] == $country2->name)) {
                        $c = new Country;
                        $c->name = $country['name'];
                        $c->name_prefix = $country['code'];
                        $c->phone_prefix = 0;
                        $c->save();
                        $this->info($country['name'] .' Saved');

                    }
                }
            } else {
                $c = new Country;
                $c->name = $country['name'];
                $c->name_prefix = $country['code'];
                $c->phone_prefix = 0;
                $c->save();
                $this->info($country['name'] . ' Saved');

            }
        }/** End foreach the country */

        $countries2 = Country::All();
        /** save regions || state || provinces */
        foreach ($countries2 as $country) {
            $json = file_get_contents('http://battuta.medunes.net/api/region/' . $country->name_prefix . '/all/?key=f6507c21d699fe7c8140819b3199518e');
            $regions = json_decode($json, true);
            $regions2 = $country->regions()->all();
            foreach ($regions as $region) {
                if ($regions2->count()) {
                    foreach ($regions2 as $region2) {
                        if (!($region['name'] == $region2->name)) {

                            $r = new Region;
                            $r->name = $region['name'];
                            $r->country()->associate($country);
                            $r->save();
                            $this->info($region['name'] . ' Saved');

                        }
                    }
                } else {
                    $r = new Region;
                    $r->name = $region['name'];
                    $r->country()->associate($country);
                    $r->save();
                    $this->info($region['name'] . ' Saved');

                }
            }

        }/** End foreach the regions || state || provinces */

        foreach ($countries2 as $country) {
            $regions2 = $country->regions()->all();
            foreach ($regions2 as $region) {
                $json = file_get_contents('https: //battuta.medunes.net/api/city/' . $country->name_prefix . '/search/?region=' . substr($region->name, 0, 4) . '&key=f6507c21d699fe7c8140819b3199518e');
                $cities = json_decode($json, true);
                $cities2 = $region->cities()->all();
                foreach ($cities as $city) {
                    if ($cities2->count()) {
                        foreach ($cities2 as $city2) {
                            if (!($city['name'] == $city2->name)) {

                                $ci = new City;
                                $ci->name = $city['name'];
                                $ci->region()->associate($region);
                                $ci->country()->associate($country);
                                $ci->save();
                                $this->info($city['name'] . ' Saved');

                            }
                        }
                    } else {
                        $ci = new City;
                        $ci->name = $city['name'];
                        $ci->region()->associate($region);
                        $ci->country()->associate($country);
                        $ci->save();
                        $this->info($city['name'] . ' Saved');
                        
                    }

                }
            }
        }
    }
}
