<?php

namespace App\Console\Commands;

use App\User;
use App\Newsletter;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Mail\NewsletterMail;
use Illuminate\Console\Command;

class NewsletterCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'newsletter:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send Newsletter';

    private $setting;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {
        $users = User::All();
        
        $newsletter = Newsletter::Where('send', false)->first();
        if($newsletter){
            $data = [
                'title' => $newsletter->title,
                'message' => $newsletter->message
            ];
    
            foreach($users as $user){
                $this->info('Message Title: ' . $newsletter->title . ' User Email: ' . $user->email);
                Mail::to($user->email)->send(new NewsletterMail($data));
                sleep(10);
            }

            $newsletter->send = true;
            $newsletter->save();
        }
        

    }


}
