<?php

namespace App\Console\Commands;

use App\User;
use App\Level;
use App\Setting;
use Illuminate\Console\Command;

class UserLevel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:level';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify User Level';

    private $setting;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {
        $users = User::All();
        $level = Level::whereCode(1)->first();

        foreach($users as $user){
            if($user->verified){

                $this->info('Usuario: ' . $user->profile->fname .' '. $user->profile->flastname);
                $this->info($level->percent);

                $user->config->withdraw_max_limit = $this->setting->withdraw_max_limit * $level->percent;
                $this->info('Limit: ' . $user->config->withdraw_max_limit);
                $user->level()->associate($level);
                $user->push();
            }
        }
    }


}
