<?php

namespace App\Console\Commands;

use App\Balance;
use App\Currency;
use App\User;
use Illuminate\Console\Command;
use Kraken;
use TCV;
class VerifyDeposits extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'deposit:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify deposits in the system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {
        //Select Users With Client Role
        $users = User::whereHas('roles', function ($query) {
            $query->where('code', '30');
        })->get();

        $currencies = Currency::Where('type', 'Cryptocurrency')->get();

        foreach ($users as $user) {

            foreach ($currencies as $currency) {

                if ($currency->symbol == 'PTR') {
                    
                    $this->info('Verify Deposits in ' . $currency->name . ' for user ' . $user->fname . ' ' . $user->flastname);

                    $deposits = $user->orders()->where('type', 'deposit')->where('status', 'pending')->where('in_currency', $currency->id)->get();

                    foreach ($deposits as $deposit) {
                        
                        $this->info('Deposits PTR ' . $deposit->reference);

                        sleep(1);
                        
                        $tcv = TCV::viewDeposits($currency->symbol, 'accepted',100);

                        foreach ($tcv as $depo) {
                            $this->info($depo['txid']);
                            
                            
                            if (strtolower($deposit->reference) == strtolower($depo['txid'])) {

                                $this->info('Deposit N° ' . $deposit->reference . ' Have A Match - Status: ' . $depo['state']);

                                if ($depo['confirmations'] > 2 && $deposit->status == 'pending') {

                                    $this->info('Deposit N° ' . $deposit->reference . ' Is Successfully');

                                    $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();
                                    $balanceG = Balance::where('currency_id', $currency->id)->where('user_id', null)->first();

                                    $balance->pending_amount = $balance->pending_amount - $deposit->in_amount;
                                    $balanceG->pending_amount = $balanceG->pending_amount - $deposit->in_amount;


                                    $balance->amount = $balance->amount + $depo['amount'];
                                    $balanceG->amount = $balanceG->amount + $depo['amount'];

                                    $deposit->status = 'complete';
                                    $deposit->in_amount = $depo['amount'];

                                    $deposit->save();
                                    $balance->save();
                                    $balanceG->save();
                                }
                            }
                        }
                    }
                } else {
                    if ($currency->symbol == 'BTC') {

                        $sym = 'XBT';
                    } else {

                        $sym = $currency->symbol;
                    }

                    $this->info('Verify Deposits in ' . $currency->name . ' for user ' . $user->fname . ' ' . $user->flastname);

                    $deposits = $user->orders()->where('type', 'deposit')->where('status', 'pending')->where('in_currency', $currency->id)->get();

                    foreach ($deposits as $deposit) {

                        $this->info('Deposits ' . $deposit->reference);

                        sleep(1);

                        $kraken = Kraken::viewDeposits($sym);

                        foreach ($kraken['result'] as $depo) {

                            if (strtolower($deposit->reference) == strtolower($depo['txid'])) {

                                $this->info('Deposit N° ' . $deposit->reference . ' Have A Match - Status: ' . $depo['status']);

                                if (strtolower($depo['status']) == 'success' && $deposit->status == 'pending') {

                                    $this->info('Deposit N° ' . $deposit->reference . ' Is Successfully');

                                    $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();
                                    $balanceG = Balance::where('currency_id', $currency->id)->where('user_id', null)->first();

                                    $balance->pending_amount = $balance->pending_amount - $deposit->in_amount;
                                    $balanceG->pending_amount = $balanceG->pending_amount - $deposit->in_amount;


                                    $balance->amount = $balance->amount + $depo['amount'];
                                    $balanceG->amount = $balanceG->amount + $depo['amount'];

                                    $deposit->status = 'complete';
                                    $deposit->in_amount = $depo['amount'];

                                    $deposit->save();
                                    $balance->save();
                                    $balanceG->save();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
