<?php

namespace App\Console\Commands;

use App\Balance;
use App\Order;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Mail\OrderComplete;
use Kraken;
use TCV;

class VerifyMarket extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'market:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify market in the system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        //Select Users With Client Role
        $orders = Order::Where('orders.type', 'market')->where('status', 'processing')->with(['outCurrencyOrder', 'inCurrencyOrder'])->orderBy('rate', 'asc')->get();

        $this->info('start command');
        foreach ($orders as $order) {

            if (strtolower($order->outCurrencyOrder->symbol) == 'ptr' || strtolower($order->inCurrencyOrder->symbol) == 'ptr') {

                $sym = strtolower($order->outCurrencyOrder->symbol);
                $sym2 = strtolower($order->inCurrencyOrder->symbol);

                $ord = TCV::getOrder($order->txid);

                $this->info(json_encode($ord));

                if ($ord['state'] == 'done' && $order->status = 'processing') {
                    $balancein = Balance::where('currency_id', $order->in_currency)->where('user_id', $order->user_id)->first();
                    $balanceinG = Balance::where('currency_id', $order->in_currency)->where('user_id', null)->first();

                    $balanceout = Balance::where('currency_id', $order->out_currency)->where('user_id', $order->user_id)->first();
                    $balanceoutG = Balance::where('currency_id', $order->out_currency)->where('user_id', null)->first();

                    $balanceout->pending_amount -= $order->out_amount;
                    $balanceoutG->pending_amount -= $order->out_amount;

                    $this->info('Values ' . $ord['volume'] . ' ' . $ord['avg_price'] . ' ' . $ord['executed_volume']);

                    if ($order->trade_type == 'bid') {

                        $amount = 0;
                        foreach ($ord['trades'] as $tr) {
                            $amount = $tr['funds'];
                        }

                        $price = 1 / $ord['price'];

                        $order->in_amount = $amount;
                        $order->rate = $price;
                        $order->filled = $ord['executed_volume'];

                    } else {

                        foreach ($ord['trades'] as $tr) {
                            $amount = $tr['funds'];
                        }

                        $order->filled = $amount;
                        $order->rate = $ord['price'];
                        $order->in_amount = $ord['executed_volume'];

                    }

                    $diferencial = $order->out_amount - ($order->fee + $order->filled);

                    if ($diferencial < 0) {
                        $diferencial = ($order->fee + $order->filled) - $order->out_amount;
                    }

                    $order->fee_network += $diferencial;
                    $order->fee += $order->fee_network;

                    $balancein->amount += $order->in_amount;
                    $balanceinG->amount += $order->in_amount;
                    

                    $this->info('Diferencial: ' . number_format($diferencial, 8) . ', In Amount: ' . $order->in_amount . ', Rate: ' . $order->rate . ', Filled: ' . $order->filled . ',  Fee Net: ' . number_format($order->fee_network, 8) . ', Fee: ' . number_format($order->fee, 8));

                    $balancein->save();
                    $balanceinG->save();

                    $balanceout->save();
                    $balanceoutG->save();

                    $order->status = 'complete';
                    $order->save();
                    $this->info('Order Complete');

                    $data = [
                        'reference' => $order->reference,
                    ];

                    $user = User::find($order->user_id);
            
                    Mail::to([$user->email])->send(new OrderComplete($data));

                }

            } /*else {
                $kraken = Kraken::getClosedOrders();

                $krorder = $kraken['result']['closed'];

                foreach ($krorder as $key => $value) {
                    $this->info('orden Ref ' . $key);
                    $this->info('Values ' . $value['fee'] . ' ' . $value['cost'] . ' ' . $value['price'] . ' ' . $value['vol_exec']);
                    if ($key == $order->txid) {
                        if ($value['status'] == 'closed' && $order->status = 'processing') {

                            $balancein = Balance::where('currency_id', $order->in_currency)->where('user_id', $order->user_id)->first();
                            $balanceinG = Balance::where('currency_id', $order->in_currency)->where('user_id', null)->first();

                            $balanceout = Balance::where('currency_id', $order->out_currency)->where('user_id', $order->user_id)->first();
                            $balanceoutG = Balance::where('currency_id', $order->out_currency)->where('user_id', null)->first();
                            $this->info('Values ' . $value['fee'] . ' ' . $value['cost'] . ' ' . $value['price'] . ' ' . $value['vol_exec']);

                            $balanceout->pending_amount -= $order->out_amount;
                            $balanceoutG->pending_amount -= $order->out_amount;

                            if ($order->trade_type == 'bid') {

                                $order->fee += $value['fee'];
                                $order->fee_thirdparty += $value['fee'];
                                $order->filled = $value['cost'];
                                $order->in_amount = $value['vol_exec'];
                                $order->rate = $value['price'];

                            } else {

                                $price = 1 / $value['price'];
                                $order->filled = $value['vol_exec'];
                                $order->in_amount = $value['cost'];
                                $order->rate = $price;
                                $order->fee += $value['fee'] * $price;
                                $order->fee_thirdparty += $value['fee'] * $price;

                            }

                            $diferencial = $order->out_amount - ($order->fee + $order->filled);

                            if ($diferencial < 0) {
                                $diferencial = ($order->fee + $order->filled) - $order->out_amount;
                            }

                            $order->fee_network += $diferencial;
                            $order->fee += $order->fee_network;

                            $balancein->amount += $order->in_amount;
                            $balanceinG->amount += $order->in_amount;

                            $balancein->save();
                            $balanceinG->save();

                            $balanceout->save();
                            $balanceoutG->save();

                            $order->status = 'complete';
                            $order->save();

                            $data = [
                                'reference' => $order->reference,
                            ];
        
                            $user = User::find($order->user_id);
                    
                            Mail::to([$user->email])->send(new OrderComplete($data));
                        }
                    }
                }
            }*/
        }
    }
}
