<?php

namespace App\Console\Commands;

use App\Balance;
use App\Currency;
use App\Order;
use App\User;
use Illuminate\Console\Command;
use Kraken;

class VerifyOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'orders:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify orders in the system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        //Select Users With Client Role
        $users = User::whereHas('roles', function ($query) {
            $query->where('code', '30');
        })->get();

        $currencies = Currency::Where('exchangeable', true)->where('active', true)->get();

        foreach ($users as $user) {

            foreach ($currencies as $currency) {
                $query = Currency::whereNotIn('symbol', [$currency->symbol])->where('active', true);
                if ($currency->symbol == 'USD') {

                } else if ($currency->prima) {
                    $query->where('prima', '0');
                } else {
                    $query->where('exchangeable', '0')->where('prima', '0');
                }
                $currencies2 = $query->get();

                foreach ($currencies2 as $currency2) {
                    if ($currency->symbol == 'BTC') {
                        $sym = 'XBT';
                        $sym2 = $currency2->symbol;
                    } else if ($currency2->symbol == 'BTC') {
                        $sym2 = 'XBT';
                        $sym = $currency2->symbol;
                    } else {
                        $sym = $currency->symbol;
                        $sym2 = $currency2->symbol;
                    }

                    $query = Order::where('orders.type', 'exchange')->where('status', 'processing')->orderBy('rate', 'asc');

                    $query->Where(function ($query) use ($currency) {
                        $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                            ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
                    });

                    $query->Where(function ($query) use ($currency2) {
                        $query->Where('in_currency', 'like', '%' . $currency2->id . '%')
                            ->orWhere('out_currency', 'like', '%' . $currency2->id . '%');
                    });

                    $orders = $query->get();

                    foreach ($orders as $order) {

                        if ($currency->type == 'FIAT') {
                            $pair = 'X' . $sym2 . 'Z' . $sym;
                        } else if ($currency2->type == 'FIAT') {
                            $pair = 'X' . $sym . 'Z' . $sym2;
                        } else {
                            $pair = 'X' . $sym2 . 'X' . $sym;
                        }

                        $kraken = Kraken::getClosedOrders();

                        $krorder = $kraken['result']['closed'];

                        foreach ($krorder as $key => $value) {
                            $this->info('orden Ref ' . $key);
                            if ($key == $order->reference) {
                                if ($value['status'] == 'closed') {
                                    $balancein = Balance::where('currency_id', $currency->id)->where('user_id', $order->user_id)->first();
                                    $balanceinG = Balance::where('currency_id', $currency->id)->where('user_id', null)->first();

                                    $balanceout = Balance::where('currency_id', $currency2->id)->where('user_id', $user->id)->first();
                                    $balanceoutG = Balance::where('currency_id', $currency2->id)->where('user_id', null)->first();
                                    $this->info('Values ' . $value['fee'] . ' ' . $value['cost'] . ' ' . $value['price']);

                                    $order->fee = $value['fee'];
                                    $order->filled = $value['cost'];
                                    if ($order->trade_type == 'bid') {
                                        $balancein->pending_amount = $order->out_amount;
                                        $balanceinG->pending_amount = $order->out_amount;

                                        $balanceout->pending_amount = $order->in_amount;
                                        $balanceoutG->pending_amount = $order->in_amount;

                                        $order->in_amount = $value['vol_exec'];
                                        $order->out_amount = $value['cost'];
                                        $order->rate = $value['descr']['price'];
                                    } else {
                                        $balancein->pending_amount = $order->in_amount;
                                        $balanceinG->pending_amount = $order->in_amount;

                                        $balanceout->pending_amount = $order->out_amount;
                                        $balanceoutG->pending_amount = $order->out_amount;

                                        $order->out_amount = $value['vol_exec'];
                                        $order->in_amount = $value['cost'];
                                        $order->rate = $value['descr']['price'];
                                    }

                                    $balancein->save();
                                    $balanceinG->save();

                                    $balanceout->save();
                                    $balanceoutG->save();

                                    $order->status = 'complete';
                                    $order->save();
                                }
                            }
                        }

                    }
                }
            }
        }
    }
}
