<?php

namespace App\Console\Commands;

use App\Currency;
use Illuminate\Console\Command;
use Kraken;

class VerifyPrice extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'price:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify currencies price';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        $currencies = Currency::all();

        foreach ($currencies as $currency) {
            $this->info($currency->name);
            if ($currency->value == "coinmarketcap" && $currency->type == "Cryptocurrency") {
/*
$url = 'https://pro-api.coinmarketcap.com/v1/tools/price-conversion';
$parameters = [
'symbol' => $currency->symbol,
'amount' => '1',
'convert' => 'USD',
];

$headers = [
'Accepts: application/json',
'X-CMC_PRO_API_KEY: 96547e22-ef2c-4b79-b04f-5b4e2992dd72',
];
$qs = http_build_query($parameters); // query string encode the parameters
$request = "{$url}?{$qs}"; // create the request URL

$curl = curl_init(); // Get cURL resource
// Set cURL options
curl_setopt_array($curl, array(
CURLOPT_URL => $request, // set the request URL
CURLOPT_HTTPHEADER => $headers, // set the headers
CURLOPT_RETURNTRANSFER => 1, // ask for raw response instead of bool
));

$response = curl_exec($curl); // Send the request, save the response

$data = json_decode($response);

curl_close($curl); // Close request

if ($data->data->quote->USD->price) {

//Assign price usd as value
$currency->price = $data->data->quote->USD->price;

} else {

$currency->price = 1;

} */

                $symbol = $currency->symbol;
                $symbol2 = 'X' . $symbol;

                if (strtolower($currency->symbol) == 'btc') {
                    $symbol = 'XBT';
                    $symbol2 = 'X' . $symbol;
                }

                if (strtolower($currency->symbol) == 'dash') {
                    $symbol2 = $currency->symbol;
                }

                $pair = $symbol . 'USD';
                $pair2 = $symbol2 . 'ZUSD';
                if (strtolower($currency->symbol) == 'dash') {
                    $pair2 = $currency->symbol . 'USD';
                }
                $kraken = Kraken::getTicker($pair);

                $this->info($kraken['result'][$pair2]['c'][0]);
                $currency->price = $kraken['result'][$pair2]['c'][0];

            } else {
                $this->info($currency->name . ' No coinmarket');
                if (strtolower($currency->name) == 'petro') {

                    $this->info($currency->name . ' view petro');

                    $this->info($currency->name . ' view petro');

                    if ($this->url_exists('https://registro.petro.gob.ve/api/api/v1/prices?coin=ptr')) {
                        $json = file_get_contents('https://registro.petro.gob.ve/api/api/v1/prices?coin=ptr');
                        $data = json_decode($json);

                        $this->info($data[0]->price);

                        $currency->price = $data[0]->price;

                    }else{  
                        $this->info($currency->value);
                        $currency->price = $currency->value;
                    }

                } else {

                    $currency->price = $currency->value;

                }
                if (strtolower($currency->name) == 'bolivar') {

                    $this->info($currency->name . ' view Bolivar');
                    $json = file_get_contents('https://s3.amazonaws.com/dolartoday/data.json');

                    $data = explode(":", $json);
                    $price = explode(",", $data[38]);

                    $this->info($price[0]);

                    $currency->price = 1 / floatval($price[0]);
                }

            }
            $currency->save();
        }
    }

    private function url_exists($url = null)
    {

        if (empty($url)) {
            return false;
        }

        $ch = curl_init($url);

        //Establecer un tiempo de espera
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

        //establecer NOBODY en true para hacer una solicitud tipo HEAD
        curl_setopt($ch, CURLOPT_NOBODY, true);
        //Permitir seguir redireccionamientos
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        //recibir la respuesta como string, no output
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $data = curl_exec($ch);

        //Obtener el código de respuesta
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        //cerrar conexión
        curl_close($ch);

        //Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
        $accepted_response = array(200, 301, 302);

        if (in_array($httpcode, $accepted_response)) {

            return true;

        } else {

            return false;

        }
    }
}
