<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use App\UserData;
use App\Profile;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/email/first';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'fname' => 'required|string|max:255',
            'flastname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'country' => 'required|integer',
            'state' => 'required|integer',
            'city' => 'required|integer',
            'street' => 'required|string|max:100',
            'house' => 'required|string|max:100',
            'postal' => 'required|string|max:6',
            'phone' => 'required|string|max:18',
            'bornDate' => 'required|string|max:255',
            'bornCity' => 'required|integer',
            'password' => 'required|string|min:6|confirmed',

        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        $user = New User;
        $user->fname = $data['fname'];
        
        if(isset($data['sname'])){
            $user->sname = $data['sname'];
        }
        
        $user->flastname = $data['flastname'];
        
        if(isset($data['slastname'])){
            
            $user->slastname = $data['slastname'];

        }
        
        
        $user->email = $data['email'];
        $user->password = Hash::make($data['password']);
        $user->save();
        
        /*

        $user = User::create([
            'fname' => $data['fname'],
            'sname' => $data['sname'],
            'flastname' => $data['flastname'],
            'slastname' => $data['slastname'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
*/
        $this->createData($data,$user);


        return $user;

    }

    private function createData($data, $user){
      $profile = new Profile;
      $profile->street = $profile->street;
      $profile->house = $profile->house;
      $profile->postal_code = $profile->postal;
      $profile->born_date = $profile->bornDate;
      $profile->phonenumber = $profile->phone;
      $profile->country()->associate($profile->country);
      $profile->region()->associate($profile->state);
      $profile->city()->associate($profile->city);
      $profile->bornCountry()->associate($profile->bornCity);
      $profile->user()->associate($user);
      $profile->save();
    }
}
