<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Mail\VerifyIP;
use App\Session;
use App\User;
use Carbon\Carbon;

class VerificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function validIP()
    {
        return view('verifications.valid-ip');
    }

    public function SendEmailIP(Request $request)
    {   
        if (Auth::check()){
            $session = new Session;

            $ip = $request->ip();
            $user_agent = $request->server('HTTP_USER_AGENT');
            $user_agent = $request->header('User-Agent');
            $time = Carbon::now();  

            $userAuth = Auth::user();
            $user = User::where('id', $userAuth->id)->first();
            $user->last_login = $time;
            //$user->ip_last_login = $ip;
            $user->save();

            $sessions = Session::where('user_id', $user->id)->get();
            $exist = count($sessions);

            if($exist == 0){
                $session->user_id = $user->id;
                $session->ip_address = $ip;
                $session->user_agent = $user_agent;
                $session->verified = 0;
                $session->last_activity = $time;
                $session->save();
            }

            $address = $session->where('user_id', $user->id)
                                ->where('ip_address', $ip)
                                ->first();

            if(!$address){
                $session->user_id = $user->id;
                $session->ip_address = $ip;
                $session->user_agent = $user_agent;
                $session->last_activity = $time;
                $session->verified = 0;
                $session->save();
            }

            $token = $user->generateJWT();
            
        }
        $token = csrf_token();
        $email = Auth::user()->email;
        Mail::to($email)->send(new VerifyIP($token));

        return response()->json(['success'], 200);
    }

    public function VerifyIP(Request $request, $token)
    {
        if($token == csrf_token()){
            $user_id = Auth::user()->id;
            $sessions = Session::where('user_id', $user_id)->get();
            $ip = $sessions->where('ip_address', $request->ip())->first();
            
            if(!$ip){
                return view('verifications.error-valid-ip');
            }
            $ip->verified = 1;
            $ip->save();

            return view('verifications.confirm-valid-ip');
        }
        return view('verifications.error-valid-ip');
    }
}
