<?php

namespace App\Http\Controllers\Backend;

use App\Balance;
use App\Currency;
use App\Http\Controllers\Controller;
use App\Order;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;

use Kraken;

class CurrenciesController extends Controller
{

    //Execute if user is authenticated
    public function __construct()
    {

        $this->middleware(['auth', '2fa', 'verify.ip']);

    }

    //Function for Check if a url have a successfully response
    private function url_exists($url = null)
    {

        if (empty($url)) {
            return false;
        }

        $ch = curl_init($url);

        //Establecer un tiempo de espera
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

        //establecer NOBODY en true para hacer una solicitud tipo HEAD
        curl_setopt($ch, CURLOPT_NOBODY, true);
        //Permitir seguir redireccionamientos
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        //recibir la respuesta como string, no output
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $data = curl_exec($ch);

        //Obtener el código de respuesta
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        //cerrar conexión
        curl_close($ch);

        //Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
        $accepted_response = array(200, 301, 302);

        if (in_array($httpcode, $accepted_response)) {

            return true;

        } else {

            return false;

        }
    }

    //Listing Currencies
    public function index(Request $request)
    {

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $total = 0;

        //Select Currencies
        $query = Currency::select();

        //Search by
        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('name', 'like', '%' . $searchValue . '%')
                    ->orWhere('symbol', 'like', '%' . $searchValue . '%')
                    ->orWhere('type', 'like', '%' . $searchValue . '%')
                    ->orWhere('created_at', 'like', '%' . $searchValue . '%')
                    ->orWhere('updated_at', 'like', '%' . $searchValue . '%');
            });
        }

        //Order By
        if ($orderBy != '') {

            if ($orderDirection != '') {

                $query->orderBy($orderBy, 'desc');

            } else {

                $query->orderBy($orderBy);

            }
        } else if ($orderDirection != '') {

            $query->orderBy('created_at');

        } else {

            $query->orderBy('created_at', 'desc');

        }

        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Currencies
        $currencies = $query->get();

        //Loop Currencies
        foreach ($currencies as $currency) {

            $currency->value = $currency->price;
        }

        //Return Response in Json dataType
        return response()->json(['page' => $page, 'result' => $currencies, 'total' => $total], 202);
    }

    public function store(Request $request)
    {

        //Validate $request data
        $request->validate([
            'name' => 'required| max:20',
            'symbol' => 'required| max:6',
            'type' => 'required|max:20',
            'value' => 'required|max:20',
            'withfee' => 'required|max:20',
            'depfee' => 'required|max:20',
        ]);

        //Assign Variables
        $name = ucfirst(strtolower($request->name));
        $symbol = strtoupper($request->symbol);
        $type = $request->type;
        $value = $request->value;
        $withfee = $request->withfee;
        $depfee = $request->depfee;
        $minwith = $request->minwith;

        if (isset($request->exch)) {
            if ($request->exch == 'true') {
                $exch = true;
            } else {
                $exch = false;
            }
        } else {
            $exch = false;
        }

        if (isset($request->active)) {
            if ($request->active == 'true') {
                $active = true;
            } else {
                $active = false;
            }
        } else {
            $active = false;
        }

        if (isset($request->prima)) {
            if ($request->prima == 'true') {
                $prima = true;
            } else {
                $prima = false;
            }
        } else {
            $prima = false;
        }

        //Create Currency
        $currency = new Currency;
        $currency->name = $name;
        $currency->symbol = $symbol;
        $currency->type = $type;
        $currency->value = $value;
        $currency->prima = $prima;
        $currency->active = $active;
        $currency->withdraw_fee = $withfee;
        $currency->deposit_fee = $depfee;
        $currency->exchangeable = $exch;
        $currency->min_withdraw = $minwith;
        $currency->save();

        //Create Balance for currency
        $balance = new Balance;
        $balance->amount = 0;
        $balance->type = 'fund';
        $balance->currency()->associate($currency);
        $balance->save();

        $users = User::All();

        foreach ($users as $user) {
            $balanceU = new Balance;
            $balanceU->amount = 0;
            $balanceU->type = 'fund';
            $balanceU->currency()->associate($currency);
            $balanceU->user()->associate($user);
            $balanceU->save();
        }

        //Return Response in Json DataType
        return response()->json(['message' => "success"], 202);
    }

    //Show a Currency IN CONSTRUCCION
    public function show(Request $request)
    {
    }

    public function currenciesAll()
    {

        $currencies = Currency::where('active', true)->get();

        return response()->json(['result' => $currencies, 'message' => "success"], 202);
    }

    public function currenciesType(Request $request)
    {

        $currencies = Currency::Where('active', true)->get();
        $type = $currencies->unique('type')->pluck('type');

        return response()->json(['result' => $type, 'message' => "success"], 202);

    }

    public function currenciesName(Request $request)
    {

        $currencies = Currency::where('type', $request->type)->where('active', true)->get();
        $name = $currencies;

        return response()->json(['result' => $name, 'message' => "success"], 202);

    }

    public function tradeable(Request $request)
    {

        $searchValue = $request->searchValue;
        $symbol = $request->symbol;

        $master = Currency::Where('symbol', $symbol)->first();

        $query = Currency::whereNotIn('symbol', [$symbol])->where('active', true);
        if ($symbol == 'USD') {
            $query->whereNotIn('symbol', ['EUR']);
        } else if ($master->prima) {
            $query->where('prima', '0');
        } else {
            $query->where('exchangeable', '0')->where('prima', '0');
        }

        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('name', 'like', '%' . $searchValue . '%')
                    ->orWhere('symbol', 'like', '%' . $searchValue . '%');
            });

        }

        $name = $query->get();

        $tradeable = array();

        $now = Carbon::now();
        $less24 = $now->subHours(24);
        $co = 0;

        foreach ($name as $currency) {
            $last = Order::Where('type', 'exchange')->where(function ($query) use ($master) {
                $query->Where('in_currency', 'like', '%' . $master->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $master->id . '%');
            });

            $last->where(function ($query) use ($currency) {
                $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
            });

            $l = $last->where('status', 'complete')->orderBy('updated_at')->first();

            $hours = Order::Where('type', 'exchange')->where(function ($query) use ($master) {
                $query->Where('in_currency', 'like', '%' . $master->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $master->id . '%');
            });

            $hours->where(function ($query) use ($currency) {
                $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
            });

            $h = $hours->where('status', 'complete')->where('updated_at', '>', $less24)->get();

            if ($hours->count()) {
                $count = 0;
                $sum = 0;
                $sumV = 0;
                foreach ($h as $ohour) {
                    if ($ohour->trade_type == 'bid') {
                        $sumV += $ohour->out_amount;
                    } else {
                        $sumV += $ohour->in_amount;
                    }
                    $sum += $ohour->rate;
                    $count += 1;
                }
                $prom = $sum / $count;
                $promV = $sumV / $count;
            }

            if (empty($tradeable[$co])) {

                //Create object in $transactions array
                $tradeable[$co] = new \stdClass();

                $tradeable[$co]->id = $currency->id;
                $tradeable[$co]->name = $currency->name;
                $tradeable[$co]->symbol = $currency->symbol;
                if ($last->count()) {
                    if ($l->trade_type == 'bid') {
                        $tradeable[$co]->last = $l->rate;
                    } else {
                        $tradeable[$co]->last = $l->rate;
                    }
                } else {
                    if ($master->symbol == 'BTC') {
                        $sym = 'XBT';
                        $sym2 = $currency->symbol;
                    } else if ($currency->symbol == 'BTC') {
                        $sym2 = 'XBT';
                        $sym = $master->symbol;
                    } else {
                        $sym = $master->symbol;
                        $sym2 = $currency->symbol;
                    }

                    if ($currency->type == 'FIAT') {
                        $spair = 'X' . $sym . 'Z' . $sym2;
                        $pair = $sym . $sym2;
                    } else if ($master->type == 'FIAT') {
                        $spair = 'X' . $sym2 . 'Z' . $sym;
                        $pair = $sym2 . $sym;
                    } else {
                        $pair = $sym2 . $sym;
                        $spair = 'X' . $sym2 . 'X' . $sym;
                    }
                    if (($master->symbol == 'VES' || $currency->symbol == 'VES') || ($master->symbol == 'PTR' || $currency->symbol == 'PTR')) {
                        $tradeable[$co]->last = 0000;
                    } else {
                        $kraken = Kraken::getTicker($pair);
                        if ($currency->symbol == 'DASH' || $master->symbol == 'DASH') {
                            $result = $kraken['result'][$pair]['c'][0];
                        } else {
                            $result = $kraken['result'][$spair]['c'][0];
                        }
                        $tradeable[$co]->last = $result;
                    }
                }

                if ($hours->count()) {
                    $tradeable[$co]->h24 = $prom;
                    $tradeable[$co]->vol = $promV;
                } else {
                    if ($master->symbol == 'BTC') {
                        $sym = 'XBT';
                        $sym2 = $currency->symbol;
                    } else if ($currency->symbol == 'BTC') {
                        $sym2 = 'XBT';
                        $sym = $master->symbol;
                    } else {
                        $sym = $master->symbol;
                        $sym2 = $currency->symbol;
                    }

                    if ($currency->type == 'FIAT') {
                        $spair = 'X' . $sym . 'Z' . $sym2;
                        $pair = $sym . $sym2;
                    } else if ($master->type == 'FIAT') {
                        $spair = 'X' . $sym2 . 'Z' . $sym;
                        $pair = $sym2 . $sym;
                    } else {
                        $pair = $sym2 . $sym;
                        $spair = 'X' . $sym2 . 'X' . $sym;
                    }
                    if (($master->symbol == 'VES' || $currency->symbol == 'VES') || ($master->symbol == 'PTR' || $currency->symbol == 'PTR')) {
                        $tradeable[$co]->h24 = 0000;
                        $tradeable[$co]->vol = 0000;
                    } else {
                        $kraken = Kraken::getTicker($pair);
                        if ($currency->symbol == 'DASH' || $master->symbol == 'DASH') {
                            $result = $kraken['result'][$pair];
                        } else {
                            $result = $kraken['result'][$spair];
                        }

                        $tradeable[$co]->h24 = $result['h'][1];
                        $tradeable[$co]->vol = $result['v'][1];
                    }

                }
            }
            $co += 1;
        }

        return response()->json(['result' => $tradeable, 'message' => "success"], 202);

    }

    public function exchangeable()
    {

        $currencies = Currency::Where('active', true)->get();
        $user = Auth::User();
        $exchange = array();
        $co = 0;
        foreach ($currencies as $currency) {
            $last = Order::Where('type', 'exchange')->where(function ($query) use ($currency) {
                $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
            });

            $orderl = $last->where('status', 'complete')->orderBy('updated_at', 'desc')->first();

            $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();
        
            if (empty($exchange[$co])) {

                //Create object in $transactions array
                $exchange[$co] = new \stdClass();
                $exchange[$co]->id = $currency->id;
                $exchange[$co]->name = $currency->name;
                $exchange[$co]->symbol = $currency->symbol;
                $exchange[$co]->exchangeable = $currency->exchangeable;
                if ($last->count()) {
                    $exchange[$co]->last = $orderl->rate;
                    if ($orderl->trade_type == 'bid') {
                        $other = Currency::find($orderl->in_currency);
                    } else {
                        $other = Currency::find($orderl->out_currency);
                    }
                    $exchange[$co]->pair = $currency->symbol . '/' . $other->symbol;
                } else {
                    $exchange[$co]->last = 0;
                    $exchange[$co]->pair = Lang::get('messages.none');
                }

                $exchange[$co]->balance = $balance->amount;
                $exchange[$co]->pending_balance = $balance->pending_amount;
                $exchange[$co]->balance_usd = $balance->amount * $currency->price;
            }
            $co += 1;
        }

        return response()->json(['result' => $exchange, 'message' => "success"], 202);
    }

    public function fastExchange()
    {

        $currencies = Currency::Where('active', true)->get();
        $usd = Currency::Where('symbol', 'USD')->first();
        $user = Auth::User();

        $exchange = array();
        $co = 0;
        foreach ($currencies as $currency) {
            $last = Order::Where('type', 'exchange')->where(function ($query) use ($currency) {
                $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
            });

            $last->where(function ($query) use ($usd) {
                $query->Where('in_currency', 'like', '%' . $usd->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $usd->id . '%');
            });

            $get = $last->where('status', 'complete')->orderBy('updated_at')->first();

            $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();

            if (empty($exchange[$co])) {

                //Create object in $transactions array
                $exchange[$co] = new \stdClass();
                $exchange[$co]->id = $currency->id;
                $exchange[$co]->name = $currency->name;
                $exchange[$co]->symbol = $currency->symbol;
                if ($last->count()) {
                    $exchange[$co]->last = $get->rate;
                } else {
                    $exchange[$co]->last = 0;
                }
                $exchange[$co]->balance = $balance->amount;
                $exchange[$co]->exchangeable = $currency->exchangeable;

            }
            $co += 1;
        }

        return response()->json(['result' => $exchange, 'message' => "success"], 202);
    }

    public function fastReceive(Request $request)
    {

        $symbol = $request->symbol;

        $master = Currency::Where('symbol', $symbol)->first();
        if (strtolower($master->symbol) == 'btc') {
            $currencies = Currency::Where('active', true)->whereNotIn('symbol', [$symbol])->get();
        } else if ( strtolower($master->symbol) == 'ptr'){
            $currencies = Currency::Where('active', true)->whereNotIn('symbol', [$symbol, 'ETH'])->get();
        } else {
            if(strtolower($master->symbol) == 'eth'){
                $currencies = Currency::Where('active', true)->whereIn('symbol', ['BTC'])->get();
            }else{
                $currencies = Currency::Where('active', true)->whereIn('symbol', ['BTC', 'PTR'])->get();
            }
        }

        $usd = Currency::Where('symbol', 'USD')->first();
        $user = Auth::User();

        $exchange = array();
        $co = 0;
        foreach ($currencies as $currency) {
            $last = Order::Where('type', 'exchange')->where(function ($query) use ($currency) {
                $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
            });

            $last->Where('type', 'exchange')->where(function ($query) use ($usd) {
                $query->Where('in_currency', 'like', '%' . $usd->id . '%')
                    ->orWhere('out_currency', 'like', '%' . $usd->id . '%');
            });

            $get = $last->where('status', 'complete')->orderBy('updated_at')->first();

            $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();

            if (empty($exchange[$co])) {

                //Create object in $transactions array
                $exchange[$co] = new \stdClass();
                $exchange[$co]->id = $currency->id;
                $exchange[$co]->name = $currency->name;
                $exchange[$co]->symbol = $currency->symbol;
                if ($last->count()) {
                    $exchange[$co]->last = $get->rate;
                } else {
                    $exchange[$co]->last = 0;
                }
                $exchange[$co]->balance = $balance->amount;

            }
            $co += 1;
        }

        return response()->json(['result' => $exchange, 'message' => "success"], 202);
    }

    //Update a Currency
    public function update(Request $request)
    {

        //Validate $request data
        $request->validate([
            'id' => 'required',
            'name' => 'required| max:20',
            'symbol' => 'required| max:6',
            'type' => 'required|max:20',
            'withfee' => 'required|max:20',
            'depfee' => 'required|max:20',
        ]);

        //Assign Variables
        $name = ucfirst(strtolower($request->name));
        $symbol = strtoupper($request->symbol);
        $type = $request->type;
        $value = $request->value;
        $id = $request->id;
        $withfee = $request->withfee;
        $depfee = $request->depfee;
        $minwith = $request->minwith;

        if (isset($request->exch)) {
            if ($request->exch == 'true') {
                $exch = true;
            } else {
                $exch = false;
            }
        } else {
            $exch = false;
        }

        if (isset($request->active)) {
            if ($request->active == 'true') {
                $active = true;
            } else {
                $active = false;
            }
        } else {
            $active = false;
        }

        if (isset($request->prima)) {
            if ($request->prima == 'true') {
                $prima = true;
            } else {
                $prima = false;
            }
        } else {
            $prima = false;
        }

        //Update Currency
        $currency = Currency::Find($id);
        $currency->name = $name;
        $currency->symbol = $symbol;
        $currency->type = $type;
        $currency->value = $value;
        $currency->prima = $prima;
        $currency->active = $active;
        $currency->withdraw_fee = $withfee;
        $currency->deposit_fee = $depfee;
        $currency->min_withdraw = $minwith;
        $currency->exchangeable = $exch;

        $currency->save();

        //Return Response in Json DataType
        return response()->json(['message' => "success"], 202);
    }

    //Destroy Currency
    public function destroy(Request $request)
    {

        //Validate $request data
        $request->validate([
            'id' => 'required',
        ]);
        //Assign Variable
        $id = $request->id;

        //Find Currency with ID
        $currency = Currency::find($id);

        //Get Currency Balances
        $balances = $currency->balances()->get();

        //Loop Currency Balances
        foreach ($balances as $balance) {

            //Delete Balance
            $bal = Balance::find($balance->id);
            $bal->delete();

        }

        //Delete Currency
        $currency->delete();

        //Return Response in Json Datatype
        return response()->json(['message' => "success"], 202);
    }

}
