<?php

namespace App\Http\Controllers\Backend;

use App\Balance;
use App\Historical;
use App\Http\Controllers\Controller;
use App\Newsletter;
use Carbon\Carbon;
use App\Currency;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Kraken;

class DashboardController extends Controller
{

    //Execute if user is authenticated
    public function __construct()
    {

        $this->middleware(['auth', '2fa', 'verify.ip']);

    }

    //Function for order arrays
    private function sorting($order, $key)
    {

        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    //Function for Check if a url have a successfully response
    private function url_exists($url = null)
    {

        if (empty($url)) {
            return false;
        }

        $ch = curl_init($url);

        //Establecer un tiempo de espera
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

        //establecer NOBODY en true para hacer una solicitud tipo HEAD
        curl_setopt($ch, CURLOPT_NOBODY, true);
        //Permitir seguir redireccionamientos
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        //recibir la respuesta como string, no output
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $data = curl_exec($ch);

        //Obtener el código de respuesta
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        //cerrar conexión
        curl_close($ch);

        //Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
        $accepted_response = array(200, 301, 302);

        if (in_array($httpcode, $accepted_response)) {

            return true;

        } else {

            return false;

        }
    }

    //Dashboard Balances
    public function balance(Request $request)
    {

        //Select Authenticated user
        $user = Auth::User();

        //Declare $count variable
        $count = 0;

        //Declare $balances Array
        $balances = array();

        $balancesP = Balance::Where('balances.type', 'fund')->where('amount', '>=', '0')->where('currencies.active', true)->where('user_id', $user->id)->leftJoin('currencies', 'currencies.id', '=', 'balances.currency_id')->select('balances.amount', 'value', 'symbol', 'name', 'balances.currency_id')->orderBy('amount', 'DESC')->get();

        foreach ($balancesP as $balance) {
            if (empty($balances[$count])) {

                $balances[$count] = new \stdClass();

                $balances[$count]->amount = $balance->amount;
                $balances[$count]->value = $balance->value;
                $balances[$count]->symbol = $balance->symbol;
                $balances[$count]->type = $balance->type;
                $balances[$count]->name = $balance->name;
                $balances[$count]->currency_id = $balance->currency_id;
                $balances[$count]->equivalent = 0;
                $balances[$count]->percent = 0;
            } else {
                foreach ($balances as $bal) {
                    if ($bal->symbol == $balance->symbol) {

                        $newBals = $bal->amount + $balance->amount;
                        $bal->amount = $newBals;

                    }
                }
            }
            $count += 1;
        }

        //Declare USD and BTC Variables
        $usd = 0;
        $btc = 0;

        //Declare $chartt variable array
        $chart['symbol'] = [];
        $chart['amount'] = [];
        $coinB = Currency::where('symbol', 'BTC')->first();

        //Loop $balances Array
        foreach ($balances as $balance) {

            $coin = Currency::find($balance->currency_id);
            $balance->value = $coin->price;
    
            if ($balance->symbol == "USD") {

                //Assign bitcoin price to usd
                $balance->value_btc = $coinB->price;

            }

            //Assign USD value
            $usdvalue = $balance->amount * $balance->value;

            //Sum values
            $usd += $usdvalue;

        }


        $btc = $usd / $coinB->price;

        foreach ($balances as $balance) {

            //Assign $balance percent an equivalent data
            $usdvalue = $balance->amount * $balance->value;
            if($usd == 0){
                $balance->percent = 0;

            }else{
                $balance->percent = ($usdvalue / $usd) * 100;
            }
            
            $balance->equivalent = $usdvalue;

        }

        //Sort $balances array
        usort($balances, $this->sorting('', 'equivalent'));

        foreach ($balances as $balance) {

            //Put data in $chart array
            array_push($chart['amount'], $balance->equivalent);
            array_push($chart['symbol'], $balance->symbol);

        }

        //Return Response in JSON DataType
        return response()->json(['result' => $balances, 'usd' => $usd, 'btc' => $btc, 'chart' => $chart], 202);

    }

    //Newsletter Dashboard
    public function newsletter()
    {
        //Select Newsletters
        $newsletters = Newsletter::LeftJoin('profiles', 'newsletters.user_id', '=', 'profiles.user_id')->select('newsletters.*', 'fname')->orderBy('newsletters.created_at')->get();

        //Loop Newsletters
        foreach ($newsletters as $newsletter) {

            //Give String format to created date newsletter
            $date = $newsletter->created_at->toFormattedDateString();
            $newsletter->date = $date;

        }

        //Return Response In JSON Datatype
        return response()->json(['result' => $newsletters], 202);
    }

    //Historical Chart Data Dashboard
    public function historyChart(Request $request)
    {

        //Select Authenticated user
        $user = Auth::User();

        //Declare Variables
        $type = $request->type;
        $count = 0;

        //Select History Data with type
        $query = Historical::where('user_id', $user->id)->select('register', 'amount')->orderBy('register');

        //Get history data
        $histories = $query->get();
        $init = $user->created_at;

        $chart = array();
        //loop Histories
        foreach ($histories as $history) {

            if ($init == $history->register) {
                //Assign $chart data
                $date = Carbon::parse($history->register);
                $chart[$count] = new \stdClass();
                $chart[$count]->register = $date->toDateString();
                $chart[$count]->amount = $history->amount;

                $count += 1;

                if ($type == 'daily') {
                    $init->addDays(1);
                } else if ($type == 'weekly') {
                    $init->addWeeks(1);
                } else {
                    $init->addMonths(1);
                }

            }

        }
        usort($chart, $this->sorting('DESC', 'register'));

        //Return Response In Json Datatype
        return response()->json(['result' => $chart], 202);
    }

}
