<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Currency;
use App\Order;
use App\User;
use Barryvdh\DomPDF\Facade as PDF;
use App\Kraken;
use Illuminate\Support\Facades\Lang;

class ReportController extends Controller 
{
    public function __construct()
    {
        $this->middleware(['auth', '2fa', 'verify.ip']);
    }

    /* reporte por transaccion  */
    public function reportView ()
    {                                   
        return view('back.reports');
    }

    private function sorting($order, $key)
    {
        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    public function filter(Request $request)
    {
        $orders = Order::leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                        ->select('orders.*', 'symbol')
                        ->orderBy('created_at', 'desc')
                        ->get();

        $filter = array();
        $count = 0;
        
        foreach ($orders as $order)
        {
            $ord = $order->toArray();
            
            foreach ($ord as $key => $value) 
            {
                $cd1 = $key != 'id';
                $cd2 = $key != 'deleted_at';
                
                if ($cd1 && $cd2)
                {
                    if (empty($filter[$count]))
                    {
                        $filter[$count] = new \stdClass();

                        if ($key == 'user_id') 
                        {
                            $filter[$count]->sym = 'fname';
                            $filter[$count]->sym = 'flastname'; 
                            $filter[$count]->sym = 'in_amount'; 
                            $filter[$count]->sym = 'symbol'; 
                            $filter[$count]->sym = 'out_amount'; 
                            $filter[$count]->sym = 'created_at'; 
                            $filter[$count]->sym = 'updated_at';
                            $filter[$count]->sym = 'reference'; 
                            $filter[$count]->sym = 'trade_type';                         
                            $filter[$count]->name = Lang::get('messages.user');
                            
                        }
                        else
                        {
                            $filter[$count]->sym = $key;
                            $filter[$count]->name = Lang::get('messages.' . $key);
                        }
                    }
                    $count++;
                }
            }
        }

        return response()->json(['result' => $filter, 'message' => 'success'], 202);
    }

    public function index(Request $request)
    {

        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $filter = $request->filter;
        $total = 0;

        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency');
                            
        $query->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                            ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                            ->orderBy('created_at', 'desc');

        //Search by
        if ($searchValue != '') 
        {
            switch ($filter) 
            {
                case 'profiles':
                    if (strpos($searchValue, " ")) 
                    {
                        $split = explode(" ", $searchValue);
                        $query->Where(function ($query) use ($split) {
                            $query->Where('profiles.fname', 'like', '%' . $split[0] . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $split[1] . '%');
                        });

                    } 
                    
                    else 
                    {
                        $query->Where(function ($query) use ($searchValue) {
                            $query->Where('profiles.fname', 'like', '%' . $searchValue . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $searchValue . '%');
                        });

                    }

                    break;
                default:
                    $query->Where($filter, 'like', '%' . $searchValue . '%');
                    break;
            }            
        }

        if ($resultPage == null || $resultPage == 0) 
        {
            $resultPage = 10;
        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) 
        {
            $query->offset(($page - 1) * $resultPage);
        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) 
        {
            //Verify if $transactions array is empty
            if (empty($transactions[$count])) 
            {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }
        

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total], 202);
    }

    public function ticketPdf(Request $request,$id)
    {
        $count = 0;
        $transactions = array();
        $id = $id;   
        $transactionsP = Order::where('orders.id', $id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')->get();       

        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);

                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        $pdf = PDF::loadView('back.ticketPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.ticketPdf');
    }

    public function reportsGeneral(Request $request)
    {
        $count = 0;
        $transactions = array();
        $user_id = Auth::User()->id;         
        $transactionsP = Order::where('orders.user_id', $user_id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')
                                ->get();        

        foreach ($transactionsP as $transaction) 
        {
            //Verify if $transactions array is empty
            if (empty($transactions[$count])) 
            {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //return $transactions;
        $pdf = PDF::loadView('back.reportsPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.reportsPdf');
    }

    /*public function Excel(Request $request)
    {
        //$id_ticket = $request->id;
        
        $order = Order::all(); 

        $pdf = PDF::loadView('back.reportsPdf', compact('order'));

        return $pdf->download('back.reportsPdf');
    }*/

    /* fin reporte por transaccion */





    /* reporte por moneda  */
    public function reportViewC ()
    {
        return view('back.reports');
    }

    private function sortingC($order, $key)
    {
        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    public function filterC(Request $request)
    {
        $orders = Order::where('orders.out_currency', '0')
                        ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                        ->select('orders.*', 'symbol')
                        ->orderBy('created_at', 'desc')
                        ->first()->get();

        $filter = array();
        $count = 0;

        foreach ($orders as $order) 
        {
            $ord = $order->toArray();
            foreach ($ord as $key => $value) 
            {
                $cd1 = $key != 'id';
                $cd2 = $key != 'deleted_at';

                if ($cd1 && $cd2) 
                {
                    if (empty($filter[$count])) 
                    {
                        $filter[$count] = new \stdClass();

                        if ($key == 'user_id') 
                        {
                            $filter[$count]->sym = 'fname';
                            $filter[$count]->sym = 'flastname'; 
                            $filter[$count]->sym = 'in_amount'; 
                            $filter[$count]->sym = 'symbol'; 
                            $filter[$count]->sym = 'out_amount'; 
                            $filter[$count]->sym = 'created_at'; 
                            $filter[$count]->sym = 'updated_at';
                            $filter[$count]->sym = 'reference'; 
                            $filter[$count]->sym = 'trade_type';
                            $filter[$count]->name = Lang::get('messages.user');
                        } 
                        
                        else 
                        {
                            $filter[$count]->sym = $key;
                            $filter[$count]->name = Lang::get('messages.' . $key);
                        }

                    }
                    $count++;

                }

            }

        }

        return response()->json(['result' => $filter, 'message' => 'success'], 202);
    }

    public function indexC(Request $request)
    {

        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $filter = $request->filter;
        $total = 0;
        $currency = $request->currency;

        //Verify if $orderBy is empty
        if (empty($orderBy)) 
        {
            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('orders.out_currency', '1')->orwhere('orders.out_currency', '2')->orwhere('orders.out_currency', '4')->orwhere('orders.out_currency', '5')
                        ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency');
                    $query->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                            ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                            ->orderBy('created_at', 'desc');

        //Search by
        if ($searchValue != '') 
        {
            switch ($filter) 
            {
                case 'profiles':
                    if (strpos($searchValue, " ")) 
                    {
                        $split = explode(" ", $searchValue);
                        $query->Where(function ($query) use ($split) {
                            $query->Where('profiles.fname', 'like', '%' . $split[0] . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $split[1] . '%');
                        });
                    }
                    
                    else 
                    {
                        $query->Where(function ($query) use ($searchValue) {
                            $query->Where('profiles.fname', 'like', '%' . $searchValue . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $searchValue . '%');
                        });
                    }

                    break;
                default:
                    $query->Where($filter, 'like', '%' . $searchValue . '%');
                    break;

            }
        }

        if ($resultPage == null || $resultPage == 0) 
        {
            $resultPage = 10;
        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) 
        {
            $query->offset(($page - 1) * $resultPage);
        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) 
        {
            //Verify if $transactions array is empty
            if (empty($transactions[$count])) 
            {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }
        

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total], 202);
    }

    public function ticketPdfC(Request $request,$id)
    {
        $count = 0;
        $transactions = array();
        $id = $id;   
        $transactionsP = Order::where('orders.id', $id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')->get();       

        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);

                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        $pdf = PDF::loadView('back.ticketPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.ticketPdf');
    }

    public function reportsGeneralC(Request $request)
    {
        $count = 0;
        $transactions = array();
        $user_id = Auth::User()->id;         
        $transactionsP = Order::where('orders.user_id', $user_id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')
                                ->get();        

        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //return $transactions;
        $pdf = PDF::loadView('back.reportsPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.reportsPdf');
    }

    /*public function Excel(Request $request)
    {
        //$id_ticket = $request->id;
        
        $order = Order::all(); 

        $pdf = PDF::loadView('back.reportsPdf', compact('order'));

        return $pdf->download('back.reportsPdf');
    }*/
    /* fin reporte por moneda */




    /* reporte por user  */
    public function reportViewU ()
    {
        $data = User::all(); //Manda monedas
        return view('back.reports', compact('data'));
    }

    private function sortingU($order, $key)
    {
        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    public function filterU(Request $request)
    {
        $orders = Order::where('orders.type', 'exchange')
                        ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                        ->select('orders.*', 'symbol')
                        ->orderBy('created_at', 'desc')
                        ->first()
                        ->get();

        $filter = array();
        $count = 0;

        foreach ($orders as $order) 
        {
            $ord = $order->toArray();

            foreach ($ord as $key => $value) 
            {
                $cd1 = $key != 'id';
                $cd2 = $key != 'deleted_at';

                if ($cd1 && $cd2) 
                {
                    if (empty($filter[$count])) 
                    {
                        $filter[$count] = new \stdClass();

                        if ($key == 'user_id') 
                        {
                            $filter[$count]->sym = 'fname';
                            $filter[$count]->sym = 'flastname'; 
                            $filter[$count]->sym = 'in_amount'; 
                            $filter[$count]->sym = 'symbol'; 
                            $filter[$count]->sym = 'out_amount'; 
                            $filter[$count]->sym = 'created_at'; 
                            $filter[$count]->sym = 'updated_at';
                            $filter[$count]->sym = 'reference'; 
                            $filter[$count]->sym = 'trade_type';  
                            $filter[$count]->name = Lang::get('messages.user');
                        }
                        
                        else
                        {
                            $filter[$count]->sym = $key;
                            $filter[$count]->name = Lang::get('messages.' . $key);
                        }

                    }
                    $count++;

                }

            }

        }

        return response()->json(['result' => $filter, 'message' => 'success'], 202);
    }

    public function indexU(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $filter = $request->filter;
        $total = 0;

        //Verify if $orderBy is empty
        if (empty($orderBy)) 
        {
            $orderBy = 'created_at';
        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('orders.user_id', '1')->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency');
        $query->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')->orderBy('created_at', 'desc');

        //Search by
        if ($searchValue != '') 
        {
            switch ($filter) 
            {
                case 'profiles':
                    if (strpos($searchValue, " ")) 
                    {
                        $split = explode(" ", $searchValue);
                        $query->Where(function ($query) use ($split) {
                            $query->Where('profiles.fname', 'like', '%' . $split[0] . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $split[1] . '%');
                        });

                    }
                    
                    else 
                    {
                        $query->Where(function ($query) use ($searchValue) {
                            $query->Where('profiles.fname', 'like', '%' . $searchValue . '%')
                                ->orWhere('profiles.flastname', 'like', '%' . $searchValue . '%');
                        });

                    }

                    break;
                default:
                    $query->Where($filter, 'like', '%' . $searchValue . '%');
                    break;

            }
        }

        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) 
        {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) 
            {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }
        

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total], 202);
    }

    public function ticketPdfU(Request $request,$id)
    {
        $count = 0;
        $transactions = array();
        $id = $id;   
        $transactionsP = Order::where('orders.id', $id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')->get();       

        foreach ($transactionsP as $transaction) 
        {
            //Verify if $transactions array is empty
            if (empty($transactions[$count])) 
            {
                $currency = Currency::find($transaction->out_currency);

                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        $pdf = PDF::loadView('back.ticketPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.ticketPdf');
    }

    public function reportsGeneralU(Request $request)
    {
        $count = 0;
        $transactions = array();
        $user_id = Auth::User()->id;         
        $transactionsP = Order::where('orders.user_id', $user_id)
                                ->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'orders.user_id')
                                ->select('orders.*', 'symbol', 'profiles.fname', 'profiles.flastname')
                                ->orderBy('created_at', 'desc')
                                ->get();        

        foreach ($transactionsP as $transaction) 
        {
            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->user = $transaction->fname . ' ' . $transaction->flastname;
                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        foreach ($transactions as $transaction) 
        {
            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //return $transactions;
        $pdf = PDF::loadView('back.reportsPdf', array ('transactions'=>$transactions));
        return $pdf->download('back.reportsPdf');
    }

    /*public function Excel(Request $request)
    {
        //$id_ticket = $request->id;
        
        $order = Order::all(); 

        $pdf = PDF::loadView('back.reportsPdf', compact('order'));

        return $pdf->download('back.reportsPdf');
    }*/
    /* fin reporte por user */

}